/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.manager;

import cn.jason31416.betternations.BetterNations;
import cn.jason31416.betternations.structure.PlaceableStructure;
import cn.jason31416.betternations.structure.types.FueledMachinery;
import cn.jason31416.betternations.structure.types.Machinery;
import cn.jason31416.betternations.structure.types.SolarMachinery;
import cn.jason31416.betternations.structure.upgrade.UpgradeInfo;
import cn.jason31416.betternations.structure.upgrade.UpgradeType;
import cn.jason31416.planetlib.InvalidConfigurationException;
import cn.jason31416.planetlib.PlanetLib;
import cn.jason31416.planetlib.item.CustomItemType;
import cn.jason31416.planetlib.item.ItemType;
import cn.jason31416.planetlib.item.SimpleCraftingRecipe;
import cn.jason31416.planetlib.item.SimpleFurnaceRecipe;
import cn.jason31416.planetlib.item.SimpleRecipe;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.message.MessageList;
import cn.jason31416.planetlib.message.StringMessage;
import java.io.File;
import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;

public class ItemCraftingManager {
    public static Map<ItemType, List<SimpleRecipe>> recipes = new HashMap<ItemType, List<SimpleRecipe>>();
    public static Map<String, ItemCategory> itemTypes = new HashMap<String, ItemCategory>();
    public static final Map<String, UpgradeInfo> upgradeInfoMap = new HashMap<String, UpgradeInfo>();

    public static void unregisterAll() {
        Bukkit.resetRecipes();
        itemTypes.clear();
        recipes.clear();
        CustomItemType.itemTypes.clear();
    }

    public static void loadItemCategories(ConfigurationSection section) {
        for (String i : section.getKeys(false)) {
            try {
                ItemCategory c = new ItemCategory(i, section.getString(i + ".name"), Objects.requireNonNull(Material.getMaterial((String)section.getString(i + ".material", "").toUpperCase()), "Material is not found!"));
                itemTypes.put(i, c);
            }
            catch (Exception e) {
                Message.getMessage("admin.configuration-format-error-with-loc").add("file", "items").add("line", "Item " + i).send((CommandSender)Bukkit.getConsoleSender());
                e.printStackTrace();
            }
        }
    }

    public static void loadItems(ConfigurationSection section) {
        for (String i : section.getKeys(false)) {
            try {
                ConfigurationSection enchsection;
                CustomItemType itemType = section.contains(i + ".skull") ? new CustomItemType(i, new StringMessage(section.getString(i + ".name", "")).toString(), section.getString(i + ".skull", ""), new MessageList(section.getStringList(i + ".lore")).asList()) : new CustomItemType(i, new StringMessage(section.getString(i + ".name", "")).toString(), Objects.requireNonNull(Material.getMaterial((String)section.getString(i + ".material", "").toUpperCase()), "Material is not found!"), new MessageList(section.getStringList(i + ".lore")).asList(), section.getBoolean(i + ".interaction", false));
                if (section.contains(i + ".model")) {
                    itemType.setCustomModelData(section.getInt(i + ".model"));
                }
                if (section.contains(i + ".glowing")) {
                    itemType.glow = true;
                } else if (section.contains(i + ".enchant") && (enchsection = section.getConfigurationSection(i + ".enchant")) != null) {
                    for (String j : enchsection.getKeys(false)) {
                        try {
                            itemType.enchantments.put(Enchantment.getByName((String)j.toUpperCase()), enchsection.getInt(j));
                        }
                        catch (Exception e) {
                            throw new InvalidConfigurationException("item.yml", i + ".enchant");
                        }
                    }
                }
                if (section.contains(i + ".category")) {
                    if (itemTypes.containsKey(section.getString(i + ".category"))) {
                        ItemCraftingManager.itemTypes.get((Object)section.getString((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001.category"}, (String)i)))).types.add(itemType);
                    } else {
                        throw new InvalidConfigurationException("item.yml", i + ".category");
                    }
                }
                if (section.contains(i + ".upgrade-info")) {
                    upgradeInfoMap.put(itemType.getName(), new UpgradeInfo(UpgradeType.valueOf(section.getString(i + ".upgrade-info.type")), section.getInt(i + ".upgrade-info.value")));
                }
                itemType.register();
            }
            catch (Exception e) {
                Message.getMessage("admin.configuration-format-error-with-loc").add("file", "items").add("line", "Item " + i).send((CommandSender)Bukkit.getConsoleSender());
                e.printStackTrace();
            }
        }
    }

    public static void loadMachineries(ConfigurationSection section) {
        for (String i : section.getKeys(false)) {
            try {
                ConfigurationSection machinery = section.getConfigurationSection(i);
                if (machinery == null) {
                    throw new InvalidConfigurationException("item.yml", i);
                }
                Machinery.materialMap.put(i, Objects.requireNonNull(Material.getMaterial((String)machinery.getString("material", "").toUpperCase()), "Material is not found!"));
                Machinery.recipes.put(i, new HashMap());
                String type = machinery.getString("machinery-type", "normal");
                if (type.equalsIgnoreCase("normal")) {
                    PlaceableStructure.registerClass(i, Machinery.class);
                    continue;
                }
                if (type.equalsIgnoreCase("fueled")) {
                    FueledMachinery.fuelCapacityMap.put(i, machinery.getInt("fuel-capacity", 100));
                    PlaceableStructure.registerClass(i, FueledMachinery.class);
                    continue;
                }
                if (!type.equalsIgnoreCase("solar")) continue;
                PlaceableStructure.registerClass(i, SolarMachinery.class);
            }
            catch (Exception e) {
                Message.getMessage("admin.configuration-format-error-with-loc").add("file", "items").add("line", "Machinery " + i).send((CommandSender)Bukkit.getConsoleSender());
                e.printStackTrace();
            }
        }
    }

    public static void loadRecipes(ConfigurationSection section) {
        for (String i : section.getKeys(false)) {
            try {
                SimpleRecipe recipe;
                ItemType productType;
                if (section.getString(i + ".type", "crafting").equalsIgnoreCase("crafting")) {
                    productType = ItemType.getItemType(section.getString(i + ".product", ""));
                    int amount = section.getInt(i + ".product-count", 1);
                    recipe = new SimpleCraftingRecipe(productType, amount);
                    ((SimpleCraftingRecipe)recipe).setShape(section.getStringList(i + ".shape"));
                    ConfigurationSection sub = section.getConfigurationSection(i + ".material");
                    if (sub == null) {
                        throw new RuntimeException("Lacking material section!");
                    }
                    for (String j : sub.getKeys(false)) {
                        ((SimpleCraftingRecipe)recipe).setMaterial(j, ItemType.getItemType(sub.getString(j, "")));
                    }
                    ((SimpleCraftingRecipe)recipe).register(i);
                    List<SimpleRecipe> allrec = recipes.get(productType);
                    if (allrec == null) {
                        allrec = new ArrayList<SimpleRecipe>();
                    }
                    allrec.add(recipe);
                    recipes.put(productType, allrec);
                    continue;
                }
                if (section.getString(i + ".type", "crafting").equalsIgnoreCase("smelting")) {
                    productType = ItemType.getItemType(section.getString(i + ".product", ""));
                    int amount = section.getInt(i + ".product-count", 1);
                    recipe = new SimpleFurnaceRecipe(productType.getItemStack(amount), ItemType.getItemType(section.getString(i + ".ingredient", "")), (float)section.getDouble(i + ".exp", 0.0), section.getInt(i + ".time"));
                    ((SimpleFurnaceRecipe)recipe).register();
                    List<SimpleRecipe> allrec = recipes.get(productType);
                    if (allrec == null) {
                        allrec = new ArrayList<SimpleRecipe>();
                    }
                    allrec.add(recipe);
                    recipes.put(productType, allrec);
                    continue;
                }
                if (Machinery.recipes.containsKey(section.getString(i + ".type", "crafting"))) {
                    Machinery.Recipe recipe2 = new Machinery.Recipe(ItemType.getItemType(section.getString(i + ".ingredient", "")), ItemType.getItemType(section.getString(i + ".product", "")), section.getInt(i + ".time", 1), section.getInt(i + ".product-count", 1), section.getString(i + ".type", "crafting"));
                    Machinery.recipes.get(section.getString(i + ".type", "crafting")).put(section.getString(i + ".ingredient"), recipe2);
                    ItemType productType2 = ItemType.getItemType(section.getString(i + ".product", ""));
                    List<SimpleRecipe> allrec = recipes.get(productType2);
                    if (allrec == null) {
                        allrec = new ArrayList<SimpleRecipe>();
                    }
                    allrec.add(recipe2);
                    recipes.put(productType2, allrec);
                    continue;
                }
                throw new RuntimeException("Unrecognized recipe type!");
            }
            catch (Exception e) {
                Message.getMessage("admin.configuration-format-error-with-loc").add("file", "items").add("line", "Recipe " + i).send((CommandSender)Bukkit.getConsoleSender());
                e.printStackTrace();
            }
        }
    }

    public static void loadAll() {
        YamlConfiguration fl;
        PlanetLib.instance.getLogger().info("\u001b[34mLoading items:\u001b[0m");
        File dir = new File(BetterNations.instance.getDataFolder(), "item");
        if (!dir.exists()) {
            dir.mkdir();
        }
        for (File file : dir.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".yml")) continue;
            try {
                fl = YamlConfiguration.loadConfiguration((File)file);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to load items for BetterNations!");
            }
            if (!fl.isConfigurationSection("categories")) continue;
            ItemCraftingManager.loadItemCategories(Objects.requireNonNull(fl.getConfigurationSection("categories")));
            BetterNations.instance.getLogger().info("\u001b[36m- Loaded " + fl.getConfigurationSection("categories").getKeys(false).size() + " categories from " + file.getName() + "!\u001b[0m");
        }
        for (File file : dir.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".yml")) continue;
            try {
                fl = YamlConfiguration.loadConfiguration((File)file);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to load items for BetterNations!");
            }
            if (!fl.isConfigurationSection("items")) continue;
            ItemCraftingManager.loadItems(Objects.requireNonNull(fl.getConfigurationSection("items")));
            BetterNations.instance.getLogger().info("\u001b[36m- Loaded " + fl.getConfigurationSection("items").getKeys(false).size() + " items from " + file.getName() + "!\u001b[0m");
        }
        for (File file : dir.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".yml")) continue;
            try {
                fl = YamlConfiguration.loadConfiguration((File)file);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to load items for BetterNations!");
            }
            if (fl.isConfigurationSection("machinery")) {
                ItemCraftingManager.loadMachineries(Objects.requireNonNull(fl.getConfigurationSection("machinery")));
                BetterNations.instance.getLogger().info("\u001b[36m- Loaded " + fl.getConfigurationSection("machinery").getKeys(false).size() + " machinery from " + file.getName() + "!\u001b[0m");
            }
            if (!fl.isConfigurationSection("fuels")) continue;
            for (String i : fl.getConfigurationSection("fuels").getKeys(false)) {
                FueledMachinery.fuelPointMap.put(i.toLowerCase(Locale.ROOT), fl.getInt("fuels." + i));
            }
        }
        for (File file : dir.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".yml")) continue;
            try {
                fl = YamlConfiguration.loadConfiguration((File)file);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to load items for BetterNations!");
            }
            if (!fl.isConfigurationSection("recipes")) continue;
            ItemCraftingManager.loadRecipes(Objects.requireNonNull(fl.getConfigurationSection("recipes")));
            BetterNations.instance.getLogger().info("\u001b[36m- Loaded " + fl.getConfigurationSection("recipes").getKeys(false).size() + " recipes " + file.getName() + "!\u001b[0m");
        }
    }

    public static class ItemCategory {
        public final String displayName;
        public final String catid;
        public final Material material;
        public final List<CustomItemType> types = new ArrayList<CustomItemType>();

        public ItemCategory(String id, String name, Material mat) {
            this.displayName = name;
            this.material = mat;
            this.catid = id;
        }
    }
}

