/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.structure.types;

import cn.jason31416.betternations.structure.types.Machinery;
import cn.jason31416.betternations.structure.upgrade.UpgradeType;
import cn.jason31416.planetlib.data.IDataItem;
import cn.jason31416.planetlib.gui.GUI;
import cn.jason31416.planetlib.item.ItemType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.jetbrains.annotations.NotNull;

public class FueledMachinery
extends Machinery {
    public static Map<String, Integer> fuelPointMap = new HashMap<String, Integer>();
    public static List<String> guiFuelLore = null;
    public static Map<String, Integer> fuelCapacityMap = new HashMap<String, Integer>();
    public double fuel = 0.0;
    public long lastCheckFuel = 0L;

    @Override
    public boolean serialize(IDataItem dataItem) {
        dataItem.set("fuel", this.fuel);
        return super.serialize(dataItem);
    }

    @Override
    public void deserialize(IDataItem dataItem) {
        this.fuel = dataItem.getDouble("fuel");
        super.deserialize(dataItem);
    }

    @Override
    public String getGUIName() {
        return "machinery-1-1-fueled";
    }

    @Override
    public void onGUIOpen(GUI gui) {
        super.onGUIOpen(gui);
        if (guiFuelLore == null && !gui.getItems((String)"fuel-slot").items.isEmpty()) {
            guiFuelLore = gui.getItems((String)"fuel-slot").items.get((int)0).lore;
        }
        gui.getItems("fuel-slot").setLore(new ArrayList<String>(guiFuelLore)).placeholder("fuel_amount", "" + (double)Math.round(this.fuel * 100.0) / 100.0).placeholder("fuel_capacity", "" + fuelCapacityMap.get(this.type)).setClickHandler((session, action, event) -> {
            String itemType;
            Player player = session.player.getPlayer();
            if (action == InventoryAction.SWAP_WITH_CURSOR && this.fuel < (double)fuelCapacityMap.get(this.type).intValue() && fuelPointMap.containsKey(itemType = ItemType.getItemType(player.getItemOnCursor()).getName().toLowerCase(Locale.ROOT))) {
                int count;
                for (count = player.getItemOnCursor().getAmount(); count > 0 && this.fuel < (double)fuelCapacityMap.getOrDefault(this.type, 100).intValue(); --count) {
                    this.fuel = Math.min(this.fuel + (double)fuelPointMap.get(itemType).intValue(), (double)fuelCapacityMap.getOrDefault(this.type, 100).intValue());
                }
                player.getItemOnCursor().setAmount(count);
                gui.update();
            }
        });
        if (this.fuel == 0.0) {
            gui.getItems("fuel-slot").setMaterial(Material.BUCKET);
        } else {
            gui.getItems("fuel-slot").setMaterial(Material.LAVA_BUCKET);
        }
    }

    @Override
    public synchronized void updateMachinery() {
        super.updateMachinery();
        if (this.currentProducing != null) {
            if (this.lastCheckFuel != 0L && System.currentTimeMillis() / 1000L > this.lastCheckFuel) {
                this.fuel = Math.max(0.0, this.fuel - (double)(System.currentTimeMillis() / 1000L - this.lastCheckFuel) * ((double)this.calcSpeedRate() / 100.0) / ((double)this.calcFuelEfficiency() / 100.0));
            }
            if (this.fuel == 0.0) {
                this.currentProducing = null;
                this.finishTime = 0L;
            }
        }
        this.lastCheckFuel = System.currentTimeMillis() / 1000L;
    }

    @Override
    @NotNull
    public Set<UpgradeType> getUsableUpgrades() {
        return Set.of(UpgradeType.SLOT, UpgradeType.EFFICIENCY, UpgradeType.SPEED);
    }
}

