/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.structure.types;

import cn.jason31416.betternations.BetterNations;
import cn.jason31416.betternations.manager.ItemCraftingManager;
import cn.jason31416.betternations.nation.Permission;
import cn.jason31416.betternations.structure.AbstractStructure;
import cn.jason31416.betternations.structure.PlaceableStructure;
import cn.jason31416.betternations.structure.upgrade.UpgradeInfo;
import cn.jason31416.betternations.structure.upgrade.UpgradeType;
import cn.jason31416.planetlib.data.IDataItem;
import cn.jason31416.planetlib.gui.GUI;
import cn.jason31416.planetlib.gui.GUISession;
import cn.jason31416.planetlib.item.CustomItemType;
import cn.jason31416.planetlib.item.ItemType;
import cn.jason31416.planetlib.item.SimpleRecipe;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.message.MessageLoader;
import cn.jason31416.planetlib.wrapper.SimplePlayer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Machinery
extends PlaceableStructure {
    public static Set<Machinery> machineries = new HashSet<Machinery>();
    public static Map<String, Map<String, Recipe>> recipes = new HashMap<String, Map<String, Recipe>>();
    public static Map<String, Material> materialMap = new HashMap<String, Material>();
    public ItemStack inputSlot = null;
    public ItemStack outputSlot = null;
    public String currentProducing = null;
    public long finishTime = 0L;
    public int speedRate = 100;
    public String type;
    public String[] upgrades = new String[]{"", "", "", "", "", "", "", "", ""};

    @Override
    public String getHologramText() {
        return Message.of("&8-= " + Message.getMessage("structure." + this.type + ".hologram").toFormatted() + " &8=-").toString();
    }

    @Override
    public void register() {
        super.register();
        machineries.add(this);
    }

    @Override
    public void unregister() {
        super.unregister();
        machineries.remove(this);
    }

    @Override
    public Material getMaterial() {
        return materialMap.get(this.type);
    }

    @Override
    public void breakStructure() {
        if (Bukkit.isPrimaryThread()) {
            this.hologram.removeHologram();
            this.location.setBlockMaterial(Material.AIR);
        } else {
            new BukkitRunnable(){

                public void run() {
                    Machinery.this.hologram.removeHologram();
                    Machinery.this.location.setBlockMaterial(Material.AIR);
                }
            }.runTaskLater((Plugin)BetterNations.instance, 0L);
        }
        this.exists = false;
        if (this.location.getBukkitLocation().getWorld() == null || !CustomItemType.itemTypes.containsKey(this.type)) {
            return;
        }
        this.location.getBukkitLocation().getWorld().dropItem(this.location.getBukkitLocation(), ItemType.getItemType(this.type).getItemStack());
        if (this.inputSlot != null) {
            this.location.getBukkitLocation().getWorld().dropItem(this.location.getBukkitLocation(), this.inputSlot.clone());
        }
        if (this.outputSlot != null) {
            this.location.getBukkitLocation().getWorld().dropItem(this.location.getBukkitLocation(), this.outputSlot.clone());
        }
        for (int i = 0; i < 9; ++i) {
            if (this.upgrades[i].isEmpty()) continue;
            this.location.getBukkitLocation().getWorld().dropItemNaturally(this.location.getBukkitLocation(), ItemType.getItemType(this.upgrades[i]).getItemStack());
        }
    }

    @Override
    public boolean serialize(IDataItem dataItem) {
        if (this.currentProducing != null) {
            dataItem.set("cp", this.currentProducing);
        }
        dataItem.set("ct", this.finishTime);
        dataItem.set("tp", this.type);
        dataItem.set("is", this.inputSlot);
        dataItem.set("os", this.outputSlot);
        dataItem.set("upgrades", String.join((CharSequence)"/", Arrays.stream(this.upgrades).map(s -> s.isEmpty() ? "*" : s).toList()));
        return true;
    }

    public void onGUIOpen(GUI gui) {
        this.flushUpgradeSlot(gui, null);
    }

    @Override
    public void deserialize(IDataItem dataItem) {
        this.currentProducing = dataItem.getString("cp");
        this.finishTime = dataItem.getLong("ct");
        this.type = dataItem.getString("tp");
        this.inputSlot = (ItemStack)dataItem.get("is");
        this.outputSlot = (ItemStack)dataItem.get("os");
        this.upgrades = Arrays.stream(dataItem.getString("upgrades").split("/")).map(s -> s.equals("*") ? "" : s).toList().toArray(new String[9]);
    }

    public String formatTime(long time) {
        long hours = time / 3600000L;
        long minutes = time % 3600000L / 60000L;
        long seconds = time % 60000L / 1000L;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    public String getGUIName() {
        return "machinery-1-1";
    }

    @Override
    public boolean processInteraction(AbstractStructure.InteractionType t, SimplePlayer player) {
        if (t == AbstractStructure.InteractionType.INTERACT) {
            if (player.hasPermission(Permission.STRUCTURE, this.location) || !this.location.getChunkLocation().isClaimed()) {
                new GUISession(player){

                    public void loadItems(GUI gui) {
                        if (Machinery.this.currentProducing != null) {
                            gui.getItems("progress-item").setMaterial(Material.ARROW).setName(Message.getMessage("structure.machinery.progress-item.active.name").toString()).setLore(MessageLoader.getList("structure.machinery.progress-item.active.lore").add("time", Machinery.this.formatTime(Machinery.this.finishTime - System.currentTimeMillis())).asList());
                        } else {
                            gui.getItems("progress-item").setMaterial(Material.BARRIER).setName(Message.getMessage("structure.machinery.progress-item.inactive.name").toString()).setLore(MessageLoader.getList("structure.machinery.progress-item.inactive.lore").asList());
                        }
                        if (Machinery.this.inputSlot != null) {
                            gui.getItems("input-slot").setItemStack(Machinery.this.inputSlot);
                        } else {
                            gui.getItems("input-slot").setName(Message.getMessage("structure.machinery.input").toString()).setMaterial(Material.LIGHT_GRAY_STAINED_GLASS_PANE).setGlow(false).setLore(new ArrayList<String>()).setSkullID(null).setQuantity(1);
                        }
                        if (Machinery.this.outputSlot != null) {
                            gui.getItems("output-slot").setItemStack(Machinery.this.outputSlot);
                        } else {
                            gui.getItems("output-slot").setName(Message.getMessage("structure.machinery.output").toString()).setMaterial(Material.LIGHT_GRAY_STAINED_GLASS_PANE).setGlow(false).setLore(new ArrayList<String>()).setSkullID(null).setQuantity(1);
                        }
                        Machinery.this.onGUIOpen(gui);
                    }

                    @Override
                    public void constructGUI(String guiID, final GUI gui) {
                        Machinery.this.updateMachinery();
                        gui.getItems("close").setClickHandler(new GUI.CloseGuiRunnable());
                        this.loadItems(gui);
                        gui.getItems("input-slot").setClickHandler((session, a, c) -> {
                            if (a == InventoryAction.PICKUP_ALL && Machinery.this.inputSlot != null) {
                                this.player.getPlayer().setItemOnCursor(Machinery.this.inputSlot.clone());
                                Machinery.this.inputSlot = null;
                                this.loadItems(gui);
                                gui.update();
                                if (Machinery.this.currentProducing != null) {
                                    Machinery.this.currentProducing = null;
                                    Machinery.this.finishTime = 0L;
                                }
                            } else if (a == InventoryAction.SWAP_WITH_CURSOR && Machinery.this.inputSlot == null) {
                                Machinery.this.inputSlot = this.player.getPlayer().getItemOnCursor().clone();
                                this.player.getPlayer().setItemOnCursor(null);
                                this.loadItems(gui);
                                gui.update();
                            } else if (a == InventoryAction.SWAP_WITH_CURSOR && ItemType.getItemType(Machinery.this.inputSlot).getName().equals(ItemType.getItemType(this.player.getPlayer().getItemOnCursor().clone()).getName())) {
                                int transfer = Math.min(Machinery.this.inputSlot.getMaxStackSize() - Machinery.this.inputSlot.getAmount(), this.player.getPlayer().getItemOnCursor().getAmount());
                                Machinery.this.inputSlot.setAmount(Machinery.this.inputSlot.getAmount() + transfer);
                                this.player.getPlayer().getItemOnCursor().setAmount(this.player.getPlayer().getItemOnCursor().getAmount() - transfer);
                                this.loadItems(gui);
                                gui.update();
                            }
                        });
                        gui.getItems("output-slot").setClickHandler((session, a, c) -> {
                            if (a == InventoryAction.PICKUP_ALL && Machinery.this.outputSlot != null) {
                                this.player.getPlayer().setItemOnCursor(Machinery.this.outputSlot.clone());
                                Machinery.this.outputSlot = null;
                                this.loadItems(gui);
                                gui.update();
                            }
                        });
                        gui.placeholder("structure_name", Message.getMessage("structure." + Machinery.this.type + ".hologram").toString());
                        new BukkitRunnable(){

                            public void run() {
                                if (!GUISession.sessions.containsKey(player) || GUISession.sessions.get((Object)player).gui != gui) {
                                    this.cancel();
                                    return;
                                }
                                this.loadItems(gui);
                                gui.update();
                            }
                        }.runTaskTimer((Plugin)BetterNations.instance, 5L, 5L);
                    }
                }.display(this.getGUIName());
            } else {
                Message.getMessage("town.cannot-build").sendActionbar(player);
            }
        } else if (t == AbstractStructure.InteractionType.BREAK) {
            this.breakStructure();
            this.unregister();
            return false;
        }
        return true;
    }

    public void updateRate(int oldRate, int newRate) {
        if (oldRate == newRate) {
            return;
        }
        this.speedRate = newRate;
        long timeLeft = this.finishTime - System.currentTimeMillis();
        if (timeLeft > 0L) {
            this.finishTime = System.currentTimeMillis() + timeLeft / (long)newRate * (long)oldRate;
        }
    }

    public synchronized void updateMachinery() {
        if (this.currentProducing != null) {
            Recipe recipe = recipes.get(this.type).get(this.currentProducing);
            if (recipe == null || this.outputSlot != null && (this.outputSlot.getAmount() + recipe.productAmount > this.outputSlot.getMaxStackSize() || !recipe.product.equals(ItemType.getItemType(this.outputSlot))) || this.inputSlot == null || !ItemType.getItemType(this.inputSlot).getName().toLowerCase(Locale.ROOT).equals(this.currentProducing)) {
                this.currentProducing = null;
                this.finishTime = 0L;
                return;
            }
            if (System.currentTimeMillis() >= this.finishTime) {
                this.finishTime = 0L;
                this.currentProducing = null;
                this.inputSlot.setAmount(this.inputSlot.getAmount() - 1);
                if (this.inputSlot.getAmount() <= 0) {
                    this.inputSlot = null;
                }
                if (this.outputSlot == null) {
                    this.outputSlot = recipe.product.getItemStack(recipe.productAmount);
                } else {
                    this.outputSlot.setAmount(this.outputSlot.getAmount() + recipe.productAmount);
                }
            }
        }
        if (this.currentProducing == null && this.inputSlot != null) {
            String inputName = ItemType.getItemType(this.inputSlot).getName().toLowerCase(Locale.ROOT);
            if (!recipes.get(this.type).containsKey(inputName)) {
                return;
            }
            Recipe recipe = recipes.get(this.type).get(inputName);
            if (!(this.outputSlot == null || this.outputSlot.getAmount() + recipe.productAmount <= this.outputSlot.getMaxStackSize() && recipe.product.equals(ItemType.getItemType(this.outputSlot)))) {
                return;
            }
            this.currentProducing = inputName;
            this.speedRate = this.calcSpeedRate();
            this.finishTime = System.currentTimeMillis() + (long)((double)(recipe.duration * 1000L) / ((double)this.speedRate / 100.0));
        }
    }

    @NotNull
    public Set<UpgradeType> getUsableUpgrades() {
        return Set.of(UpgradeType.SLOT, UpgradeType.SPEED);
    }

    private void flushUpgradeSlot(@NotNull GUI gui, @Nullable Player argument) {
        int i;
        int slotLimit = 1;
        for (i = 0; i < 9; ++i) {
            UpgradeInfo upgradeInfo;
            if (this.upgrades[i].isEmpty() || (upgradeInfo = ItemCraftingManager.upgradeInfoMap.get(this.upgrades[i])) == null || upgradeInfo.type() != UpgradeType.SLOT) continue;
            slotLimit += upgradeInfo.value();
        }
        slotLimit = Math.min(slotLimit, 9);
        for (i = 0; i < 9; ++i) {
            boolean usable = i < slotLimit;
            gui.removeItem(i + 27);
            int fi = i;
            if (this.upgrades[i].isEmpty()) {
                if (usable) {
                    gui.addItem(UUID.randomUUID().toString(), i + 27, this.getUpgradeSlotItem(true)).setClickHandler((session, a, c) -> {
                        Player player = session.player.getPlayer();
                        UpgradeInfo upgradeInfo = ItemCraftingManager.upgradeInfoMap.get(ItemType.getItemType(player.getItemOnCursor()).getName());
                        GUI.Item item = session.gui.getItem(fi + 27);
                        if (a == InventoryAction.SWAP_WITH_CURSOR && item != null && upgradeInfo != null && this.getUsableUpgrades().contains((Object)upgradeInfo.type())) {
                            this.upgrades[c.getSlot() - 27] = ItemType.getItemType(player.getItemOnCursor()).getName();
                            player.setItemOnCursor(null);
                            this.flushUpgradeSlot(session.gui, player);
                        }
                    });
                    continue;
                }
                gui.addItem(UUID.randomUUID().toString(), i + 27, this.getUpgradeSlotItem(false));
                continue;
            }
            if (usable) {
                gui.addItem(UUID.randomUUID().toString(), i + 27, ItemType.getItemType(this.upgrades[i]).getItemStack()).setClickHandler((session, a, c) -> {
                    Player player = session.player.getPlayer();
                    GUI.Item item = session.gui.getItem(fi + 27);
                    if (a == InventoryAction.PICKUP_ALL) {
                        player.setItemOnCursor(ItemType.getItemType(this.upgrades[fi]).getItemStack());
                        this.upgrades[fi] = "";
                        item.setItemStack(this.getUpgradeSlotItem(true));
                        this.flushUpgradeSlot(gui, player);
                    }
                });
                continue;
            }
            this.returnToPlayer(Objects.requireNonNull(argument), ItemType.getItemType(this.upgrades[i]).getItemStack());
            this.upgrades[i] = "";
            gui.addItem(UUID.randomUUID().toString(), i + 27, this.getUpgradeSlotItem(false));
        }
        this.updateRate(this.speedRate, this.calcSpeedRate());
        gui.update();
    }

    public static void updateMachineries() {
        for (Machinery machinery : machineries) {
            machinery.updateMachinery();
        }
    }

    private void returnToPlayer(@NotNull Player player, @NotNull ItemStack item) {
        if (item.getAmount() <= 0) {
            return;
        }
        PlayerInventory inventory = player.getInventory();
        HashMap leftOver = inventory.addItem(new ItemStack[]{item});
        if (!leftOver.isEmpty()) {
            for (ItemStack leftoverItem : leftOver.values()) {
                player.getWorld().dropItemNaturally(player.getLocation(), leftoverItem);
            }
        }
    }

    @NotNull
    private ItemStack getUpgradeSlotItem(boolean usable) {
        ItemStack item = new ItemStack(usable ? Material.GREEN_STAINED_GLASS_PANE : Material.BARRIER);
        ItemMeta meta = Objects.requireNonNull(item.getItemMeta());
        meta.setDisplayName(Message.getMessage(usable ? "structure.upgrade.usable-slot-name" : "structure.upgrade.unusable-slot-name").toString());
        meta.setLore(MessageLoader.getList(usable ? "structure.upgrade.usable-slot-lore" : "structure.upgrade.unusable-slot-lore").asList());
        item.setItemMeta(meta);
        return item;
    }

    public int calcSpeedRate() {
        int speed = 100;
        for (int i = 0; i < 9; ++i) {
            UpgradeInfo info;
            if (this.upgrades[i].isEmpty() || (info = ItemCraftingManager.upgradeInfoMap.get(this.upgrades[i])).type() != UpgradeType.SPEED) continue;
            speed += info.value();
        }
        return speed;
    }

    public int calcFuelEfficiency() {
        int efficiency = 100;
        for (int i = 0; i < 9; ++i) {
            UpgradeInfo info;
            if (this.upgrades[i].isEmpty() || (info = ItemCraftingManager.upgradeInfoMap.get(this.upgrades[i])).type() != UpgradeType.EFFICIENCY) continue;
            efficiency += info.value();
        }
        return efficiency;
    }

    public static class Recipe
    implements SimpleRecipe {
        public final ItemType product;
        public final ItemType ingredient;
        public final long duration;
        public final String machineryType;
        public final int productAmount;

        public Recipe(ItemType ingredient, ItemType product, long duration, int productAmount, String machineryType) {
            this.product = product;
            this.duration = duration;
            this.ingredient = ingredient;
            this.machineryType = machineryType;
            this.productAmount = productAmount;
        }

        @Override
        public ItemStack getProduct() {
            return this.product.getItemStack(this.productAmount);
        }
    }
}

