/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.structure.types;

import cn.jason31416.betternations.structure.types.Machinery;
import cn.jason31416.betternations.structure.upgrade.UpgradeType;
import cn.jason31416.planetlib.data.IDataItem;
import cn.jason31416.planetlib.gui.GUI;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;

public class SolarMachinery
extends Machinery {
    @Override
    public boolean serialize(IDataItem dataItem) {
        return super.serialize(dataItem);
    }

    @Override
    public void deserialize(IDataItem dataItem) {
        super.deserialize(dataItem);
    }

    @Override
    public String getGUIName() {
        return "machinery-1-1-solar";
    }

    @Override
    public void onGUIOpen(GUI gui) {
        super.onGUIOpen(gui);
        gui.getItems("solar-state").setMaterial(this.hasSunshine() ? Material.MAGMA_CREAM : Material.SLIME_BALL);
    }

    @Override
    public synchronized void updateMachinery() {
        super.updateMachinery();
        if (this.currentProducing != null && !this.hasSunshine()) {
            this.currentProducing = null;
            this.finishTime = 0L;
        }
    }

    private boolean hasSunshine() {
        return this.location.world().getBukkitWorld().getEnvironment() == World.Environment.NORMAL && this.location.world().getBukkitWorld().isClearWeather() && (this.location.world().getBukkitWorld().getTime() % 24000L + 24000L) % 24000L < 12000L;
    }

    @Override
    @NotNull
    public Set<UpgradeType> getUsableUpgrades() {
        return Set.of(UpgradeType.SLOT, UpgradeType.SPEED, UpgradeType.SOLAR);
    }
}

