/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.structure.types;

import cn.jason31416.betternations.nation.Town;
import cn.jason31416.betternations.nation.TownRole;
import cn.jason31416.betternations.structure.AbstractStructure;
import cn.jason31416.planetlib.data.IDataItem;
import cn.jason31416.planetlib.gui.GUI;
import cn.jason31416.planetlib.gui.GUISession;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.message.MessageLoader;
import cn.jason31416.planetlib.message.StringMessage;
import cn.jason31416.planetlib.wrapper.SimplePlayer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class TownCore
extends AbstractStructure {
    public Town town;

    @Override
    public String getHologramText() {
        return Message.getMessage("structure.towncore.hologram").add("nation_color", this.town.getNation().getColorTag()).add("town", this.town.getName()).toString();
    }

    @Override
    public boolean processInteraction(AbstractStructure.InteractionType type, SimplePlayer player) {
        if (type == AbstractStructure.InteractionType.INTERACT) {
            new GUISession(player){
                Town curtown;
                int memberPage;
                {
                    this.curtown = TownCore.this.town;
                    this.memberPage = 0;
                }

                @Override
                public void constructGUI(String guiID, final GUI gui) {
                    block6 : switch (guiID) {
                        case "town-core": {
                            gui.placeholder("town_name", this.curtown.getName()).placeholder("nation", new StringMessage(this.curtown.getNation().getColorTag() + this.curtown.getNation().getName()).toString());
                            if (this.curtown.getLevel().getNextLevel() != null) {
                                StringBuilder barbuilder = new StringBuilder("&b");
                                for (int i = 0; i <= 10; ++i) {
                                    int x = (int)((this.curtown.devPoints - this.curtown.getLevel().points) / (this.curtown.getLevel().getNextLevel().points - this.curtown.getLevel().points) * 10.0);
                                    if (x == i) {
                                        barbuilder.append("&7");
                                    }
                                    if (i < x) {
                                        barbuilder.append("=");
                                        continue;
                                    }
                                    barbuilder.append("-");
                                }
                                gui.getItems("info").setMaterial(this.curtown.getLevel().material).placeholder("hp", "" + this.curtown.townHealth).placeholder("level", new StringMessage(this.curtown.getLevel().name).toString()).placeholder("level_bar", new StringMessage(barbuilder.toString()).toString()).placeholder("dev_points", "" + (double)Math.round(this.curtown.devPoints * 100.0) / 100.0).placeholder("next_level_points", "" + this.curtown.getLevel().getNextLevel().points).placeholder("next_level", new StringMessage(this.curtown.getLevel().getNextLevel().name).toString());
                            } else {
                                gui.getItems("info").removeLoreLine(1).placeholder("nation", this.curtown.getNation().getColorTag() + this.curtown.getNation().getName()).placeholder("level", this.curtown.getLevel().name).setMaterial(this.curtown.getLevel().material);
                            }
                            gui.getItems("nation").setClickHandler(new GUI.SwitchGuiRunnable("nation-core"));
                            gui.getItems("members").setClickHandler((s, a, e) -> {
                                this.memberPage = 0;
                                s.display("town-members");
                            });
                            break;
                        }
                        case "town-members": {
                            gui.placeholder("town_name", this.curtown.getName());
                            gui.getItems("back").setClickHandler(new GUI.SwitchGuiRunnable("town-core"));
                            List members = new ArrayList<SimplePlayer>();
                            members.add(this.curtown.getMayor());
                            for (SimplePlayer i : this.curtown.roles.keySet()) {
                                if (this.curtown.getRole(i) != TownRole.MANAGER) continue;
                                members.add(i);
                            }
                            for (SimplePlayer i : this.curtown.roles.keySet()) {
                                if (this.curtown.getRole(i) != TownRole.RESIDENT) continue;
                                members.add(i);
                            }
                            for (SimplePlayer i : this.curtown.roles.keySet()) {
                                if (this.curtown.getRole(i) != TownRole.GREENCARD) continue;
                                members.add(i);
                            }
                            for (SimplePlayer i : this.curtown.getNation().getMembers()) {
                                if (this.curtown.getRole(i) != TownRole.NONE) continue;
                                members.add(i);
                            }
                            int totalpages = members.size() / 28 + 1;
                            if (this.memberPage < totalpages - 1) {
                                gui.getItems("nextpage").setMaterial(Material.LIME_STAINED_GLASS_PANE).setClickHandler((session, action, event) -> {
                                    ++this.memberPage;
                                    this.constructGUI(guiID, gui);
                                });
                            } else {
                                gui.getItems("nextpage").setMaterial(Material.BLACK_STAINED_GLASS_PANE).setName(" ");
                            }
                            if (this.memberPage > 0) {
                                gui.getItems("prevpage").setMaterial(Material.LIME_STAINED_GLASS_PANE).setClickHandler((session, action, event) -> {
                                    --this.memberPage;
                                    this.constructGUI(guiID, gui);
                                });
                            } else {
                                gui.getItems("prevpage").setMaterial(Material.BLACK_STAINED_GLASS_PANE).setName(" ");
                            }
                            members = members.subList(this.memberPage * 28, Math.min(this.memberPage * 28 + 28, members.size()));
                            int cur = 0;
                            for (int i = 10; i < 44; ++i) {
                                if (i % 9 == 8) {
                                    i += 2;
                                }
                                if (cur >= members.size()) break block6;
                                final SimplePlayer p = (SimplePlayer)members.get(cur);
                                ItemStack head = new ItemStack(Material.PLAYER_HEAD);
                                ItemMeta itemMeta = head.getItemMeta();
                                if (itemMeta instanceof SkullMeta) {
                                    SkullMeta meta = (SkullMeta)itemMeta;
                                    try {
                                        meta.setOwnerProfile(p.offlinePlayer().getPlayerProfile());
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    meta.setDisplayName("\u00a7e\u00a7l" + p.getName());
                                    meta.setLore(MessageLoader.getList(this.curtown.getRole(this.player) == TownRole.MAYOR || this.player.offlinePlayer().isOp() ? "town.gui-member-lore" : "town.gui-member-lore-no-permission").add("permission", this.curtown.getRole(p).getName()).asList());
                                    head.setItemMeta((ItemMeta)meta);
                                }
                                gui.addItem("memberitem-" + i, i).setAsVanillaItemStack(head);
                                final int pos = i;
                                if (this.curtown.getRole(this.player) == TownRole.MAYOR || this.player.offlinePlayer().isOp()) {
                                    gui.getItems("memberitem-" + i).setClickHandler(new GUI.GUIRunnable(){

                                        private void updateItem() {
                                            ItemStack h = new ItemStack(Material.PLAYER_HEAD);
                                            ItemMeta itemMeta = h.getItemMeta();
                                            if (itemMeta instanceof SkullMeta) {
                                                SkullMeta meta = (SkullMeta)itemMeta;
                                                try {
                                                    meta.setOwnerProfile(p.offlinePlayer().getPlayerProfile());
                                                }
                                                catch (Exception exception) {
                                                    // empty catch block
                                                }
                                                meta.setDisplayName("\u00a7e\u00a7l" + p.getName());
                                                meta.setLore(MessageLoader.getList(curtown.getRole(player) == TownRole.MAYOR ? "town.gui-member-lore" : "town.gui-member-lore-no-permission").add("permission", curtown.getRole(p).getName()).asList());
                                                h.setItemMeta((ItemMeta)meta);
                                            }
                                            gui.getItem(pos).setAsVanillaItemStack(h);
                                            gui.update();
                                        }

                                        @Override
                                        public void run(GUISession session, InventoryAction action, InventoryClickEvent event) {
                                            if (action == InventoryAction.PICKUP_ALL && (player.getPlayer().isOp() || curtown.getRole(player) == TownRole.MAYOR || curtown.getRole(player) == TownRole.MANAGER && (curtown.getRole(p) == TownRole.RESIDENT || curtown.getRole(p) == TownRole.GREENCARD))) {
                                                if (curtown.getRole(p) != TownRole.NONE && curtown.getRole(p) != TownRole.MAYOR) {
                                                    curtown.setRole(p, curtown.getRole(p).demote());
                                                    this.updateItem();
                                                }
                                            } else if (action == InventoryAction.PICKUP_HALF) {
                                                if (p.getNation() != curtown.getNation()) {
                                                    return;
                                                }
                                                if ((curtown.getRole(player) == TownRole.MANAGER && curtown.getRole(p) == TownRole.NONE || curtown.getRole(player) == TownRole.MAYOR || player.getPlayer().isOp()) && curtown.getRole(p) != TownRole.MAYOR) {
                                                    curtown.setRole(p, curtown.getRole(p).promote());
                                                    if (curtown.getRole(p) == TownRole.MAYOR) {
                                                        curtown.setRole(curtown.getMayor(), TownRole.MAYOR.demote());
                                                        curtown.mayor = p;
                                                        session.display("town-members");
                                                    } else {
                                                        this.updateItem();
                                                    }
                                                }
                                            }
                                        }
                                    });
                                }
                                ++cur;
                            }
                            break;
                        }
                        case "nation-core": {
                            gui.placeholder("nation", this.curtown.getNation().getName());
                        }
                    }
                }
            }.display("town-core");
        } else if (type == AbstractStructure.InteractionType.BREAK) {
            return false;
        }
        return true;
    }

    @Override
    public Material getMaterial() {
        return Material.BEACON;
    }

    @Override
    public boolean serialize(IDataItem dataItem) {
        dataItem.set("town", this.town.getId().toString());
        return true;
    }

    @Override
    public void deserialize(IDataItem dataItem) {
        this.town = Town.getTown(UUID.fromString(dataItem.getString("town")));
        this.town.core = this;
    }
}

