/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.structure.types;

import cn.jason31416.betternations.command.nation.NationClaimCommand;
import cn.jason31416.betternations.manager.HistoricalBroadcastManager;
import cn.jason31416.betternations.nation.Town;
import cn.jason31416.betternations.structure.AbstractStructure;
import cn.jason31416.planetlib.Config;
import cn.jason31416.planetlib.data.IDataItem;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.wrapper.SimpleChunkLocation;
import cn.jason31416.planetlib.wrapper.SimpleLocation;
import cn.jason31416.planetlib.wrapper.SimplePlayer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;

public class TownRuin
extends AbstractStructure {
    public static Map<SimpleChunkLocation, TownRuin> ruins = new HashMap<SimpleChunkLocation, TownRuin>();
    public String name;

    @Override
    public String getHologramText() {
        return Message.getMessage("structure.townruin.hologram").add("town", this.name).toString();
    }

    @Override
    public boolean processInteraction(AbstractStructure.InteractionType type, SimplePlayer player) {
        if (type == AbstractStructure.InteractionType.INTERACT) {
            player.sendMessage(Message.getMessage("structure.townruin.message.interact").add("cost", Config.getDouble("town.creation-cost")));
        } else {
            if (type == AbstractStructure.InteractionType.BREAK) {
                if (player.getPlayer().isOp()) {
                    this.breakStructure();
                    this.unregister();
                }
                return false;
            }
            if (type == AbstractStructure.InteractionType.SNEAK_CLICK) {
                if (this.location.getChunkLocation().isClaimed() && player.getNation() != this.location.getChunkLocation().getNation()) {
                    player.sendMessage(Message.getMessage("structure.townruin.message.claimed"));
                    return true;
                }
                if (player.getNation() == null) {
                    player.sendMessage(Message.getMessage("structure.townruin.message.no_nation"));
                    return true;
                }
                if (!NationClaimCommand.checkWorld(this.location.world())) {
                    player.sendMessage(Message.getMessage("command.failed.chunk-claim-invalid-world"));
                    return true;
                }
                if (Town.getTown(this.name) != null) {
                    player.sendMessage(Message.getMessage("command.failed.town-name-exists"));
                    return true;
                }
                if (!player.withdrawBalance(Config.getDouble("town.creation-cost"))) {
                    player.sendMessage(Message.getMessage("not-enough-money").add("amount", Config.getDouble("town.creation-cost")));
                    return true;
                }
                this.breakStructure();
                this.unregister();
                player.sendMessage(Message.getMessage("command.success.town-created").add("name", this.name));
                Town town = Town.createTown(this.name, this.location, player.getNation(), player);
                if (town != null) {
                    HistoricalBroadcastManager.broadcast(Message.getMessage("history.town-creation").add("player", player.getName()).add("nation", town.getNation().getName()).add("town", this.name), List.of(town.getNation()));
                }
                return true;
            }
        }
        return true;
    }

    @Override
    public void register() {
        super.register();
        ruins.put(this.location.getChunkLocation(), this);
    }

    @Override
    public void unregister() {
        super.unregister();
        ruins.remove(this.location.getChunkLocation());
    }

    public static void create(SimpleLocation location, String name) {
        TownRuin townRuin = new TownRuin();
        townRuin.location = location;
        townRuin.name = name;
        townRuin.place();
    }

    @Override
    public Material getMaterial() {
        return Material.GLASS;
    }

    @Override
    public boolean serialize(IDataItem dataItem) {
        dataItem.set("town", this.name);
        return true;
    }

    @Override
    public void deserialize(IDataItem dataItem) {
        this.name = dataItem.getString("town");
    }
}

