/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.structure.types;

import cn.jason31416.betternations.BetterNations;
import cn.jason31416.betternations.army.ArmyStack;
import cn.jason31416.betternations.army.ArmyType;
import cn.jason31416.betternations.army.states.ArmyCamp;
import cn.jason31416.betternations.army.states.TransportArmy;
import cn.jason31416.betternations.nation.Permission;
import cn.jason31416.betternations.structure.AbstractStructure;
import cn.jason31416.betternations.structure.PlaceableStructure;
import cn.jason31416.planetlib.Utils;
import cn.jason31416.planetlib.data.IDataItem;
import cn.jason31416.planetlib.gui.GUI;
import cn.jason31416.planetlib.gui.GUISession;
import cn.jason31416.planetlib.item.CustomItemType;
import cn.jason31416.planetlib.item.ItemType;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.message.MessageLoader;
import cn.jason31416.planetlib.wrapper.SimplePlayer;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class UnitProductionStructure
extends PlaceableStructure {
    public static Map<String, Map<String, Recipe>> recipes = new HashMap<String, Map<String, Recipe>>();
    public static Map<String, Material> materialMap = new HashMap<String, Material>();
    public Map<ArmyType, ArmyStack.Unit> armyStorage = new HashMap<ArmyType, ArmyStack.Unit>();
    public String currentProducing = null;
    public long finishTime = 0L;
    public String type;

    @Override
    public String getHologramText() {
        return Message.getMessage("structure." + this.type + ".hologram").toString();
    }

    @Override
    public Material getMaterial() {
        return materialMap.get(this.type);
    }

    @Override
    public void breakStructure() {
        if (Bukkit.isPrimaryThread()) {
            this.hologram.removeHologram();
            this.location.setBlockMaterial(Material.AIR);
        } else {
            new BukkitRunnable(){

                public void run() {
                    UnitProductionStructure.this.hologram.removeHologram();
                    UnitProductionStructure.this.location.setBlockMaterial(Material.AIR);
                }
            }.runTaskLater((Plugin)BetterNations.instance, 0L);
        }
        this.exists = false;
        if (this.location.getBukkitLocation().getWorld() == null || !CustomItemType.itemTypes.containsKey(this.type)) {
            return;
        }
        this.location.getBukkitLocation().getWorld().dropItem(this.location.getBukkitLocation(), ItemType.getItemType(this.type).getItemStack());
    }

    @Override
    public boolean serialize(IDataItem dataItem) {
        if (this.currentProducing != null) {
            dataItem.set("cp", this.currentProducing);
        }
        dataItem.set("ct", this.finishTime);
        dataItem.set("tp", this.type);
        ArrayList<CallSite> armiesList = new ArrayList<CallSite>();
        for (ArmyType i : this.armyStorage.keySet()) {
            armiesList.add((CallSite)((Object)(i.id + ":" + this.armyStorage.get((Object)i).count)));
        }
        dataItem.set("armies", String.join((CharSequence)";", armiesList));
        return true;
    }

    @Override
    public void deserialize(IDataItem dataItem) {
        this.currentProducing = dataItem.getString("cp");
        this.finishTime = dataItem.getLong("ct");
        this.type = dataItem.getString("tp");
        this.armyStorage.clear();
        for (String armyStr : dataItem.getString("armies").split(";")) {
            if (armyStr.isEmpty()) continue;
            String[] armyArr = armyStr.split(":");
            ArmyType tp = ArmyType.armyTypes.get(armyArr[0]);
            if (tp == null) {
                Bukkit.getLogger().severe("Unknown army type!");
                continue;
            }
            this.armyStorage.put(tp, new ArmyStack.Unit(tp, Integer.parseInt(armyArr[1])));
        }
    }

    private void checkComplete() {
        Map<String, Recipe> recipeMap = recipes.get(this.type);
        if (System.currentTimeMillis() >= this.finishTime && this.currentProducing != null) {
            if (recipeMap.containsKey(this.currentProducing)) {
                ArmyType type = recipeMap.get((Object)this.currentProducing).armyType;
                if (!this.armyStorage.containsKey(type)) {
                    this.armyStorage.put(type, new ArmyStack.Unit(type, 1));
                } else {
                    ++this.armyStorage.get((Object)type).count;
                    this.armyStorage.get((Object)type).hp += type.health;
                }
            }
            this.currentProducing = null;
            this.finishTime = 0L;
        }
    }

    @Override
    public boolean processInteraction(AbstractStructure.InteractionType type, SimplePlayer player) {
        if (type == AbstractStructure.InteractionType.INTERACT) {
            final Map<String, Recipe> recipeMap = recipes.get(this.type);
            if (this.location.getChunkLocation().isTownChunk() && player.hasPermission(Permission.STRUCTURE, this.location) || !this.location.getChunkLocation().isClaimed()) {
                this.checkComplete();
                ItemStack hand = player.getPlayer().getInventory().getItemInMainHand();
                if (recipeMap.containsKey(ItemType.getItemType(hand).getName())) {
                    if (this.currentProducing == null) {
                        this.currentProducing = ItemType.getItemType(hand).getName();
                        this.finishTime = recipeMap.get((Object)ItemType.getItemType((ItemStack)hand).getName()).duration + System.currentTimeMillis();
                        player.getPlayer().getInventory().getItemInMainHand().setAmount(hand.getAmount() - 1);
                    }
                    return true;
                }
                new GUISession(player){
                    ItemStack ti;
                    {
                        super(player);
                        this.ti = null;
                    }

                    @Override
                    public void constructGUI(final String guiID, final GUI gui) {
                        if (this.ti == null) {
                            this.ti = gui.getItems("training").toBukkitItem();
                        }
                        gui.placeholder("structure_name", UnitProductionStructure.this.getHologramText());
                        UnitProductionStructure.this.checkComplete();
                        int pos = 28;
                        for (ArmyType type : UnitProductionStructure.this.armyStorage.keySet()) {
                            gui.addItem("army-" + pos, pos, UnitProductionStructure.this.armyStorage.get(type).getItemStack());
                            if (++pos % 9 != 8) continue;
                            pos += 2;
                        }
                        gui.getItems("close").setClickHandler(new GUI.CloseGuiRunnable());
                        gui.getItems("extract").setMaterial(UnitProductionStructure.this.armyStorage.isEmpty() ? Material.GRAY_WOOL : Material.LIME_WOOL).setClickHandler((session, action, event) -> {
                            if (!(UnitProductionStructure.this.armyStorage.isEmpty() || this.player.getNation() == null || this.player.getNation() != UnitProductionStructure.this.location.getChunkLocation().getNation() && UnitProductionStructure.this.location.getChunkLocation().isClaimed())) {
                                ArmyStack stack = new ArmyStack(this.player.getNation());
                                stack.armies = new HashMap<ArmyType, ArmyStack.Unit>(UnitProductionStructure.this.armyStorage);
                                stack.supply = stack.getMaxSupply();
                                UnitProductionStructure.this.armyStorage.clear();
                                TransportArmy.spawn(UnitProductionStructure.this.location.getRelative(0.5, 1.0, 0.5), this.player, stack);
                            }
                        });
                        gui.getItems("material").setMaterial(UnitProductionStructure.this.currentProducing == null ? Material.LIME_STAINED_GLASS_PANE : Material.ORANGE_STAINED_GLASS_PANE).setClickHandler((session, action, event) -> {
                            if (event.getCursor() != null && UnitProductionStructure.this.currentProducing == null) {
                                for (String type : recipeMap.keySet()) {
                                    if (!ItemType.getItemType(event.getCursor()).getName().equals(type)) continue;
                                    event.getCursor().setAmount(event.getCursor().getAmount() - 1);
                                    UnitProductionStructure.this.currentProducing = type;
                                    UnitProductionStructure.this.finishTime = ((Recipe)recipeMap2.get((Object)type)).duration + System.currentTimeMillis();
                                    break;
                                }
                            }
                        });
                        if (UnitProductionStructure.this.currentProducing != null) {
                            gui.getItems("training").setMaterial(Material.IRON_SWORD).setName(Message.getMessage("combat.training.progress-item.name").add("type", ((Recipe)recipeMap.get((Object)UnitProductionStructure.this.currentProducing)).armyType.name).toString()).setLore(MessageLoader.getList("combat.training.progress-item.lore").add("time", Utils.formatSeconds((int)((UnitProductionStructure.this.finishTime - System.currentTimeMillis()) / 1000L))).asList());
                        } else {
                            gui.getItems("training").setItemStack(this.ti);
                        }
                        new BukkitRunnable(){

                            public void run() {
                                if (!GUISession.sessions.containsKey(player) || GUISession.sessions.get((Object)player).gui != gui) {
                                    return;
                                }
                                int pos = 28;
                                while (pos < 44) {
                                    gui.container.remove(pos);
                                    if (++pos % 9 != 8) continue;
                                    pos += 2;
                                }
                                this.constructGUI(guiID, gui);
                                gui.update();
                            }
                        }.runTaskLater((Plugin)BetterNations.instance, 5L);
                    }
                }.display("army-production");
            } else {
                Message.getMessage("town.cannot-build").sendActionbar(player);
            }
        } else if (type == AbstractStructure.InteractionType.BREAK) {
            this.breakStructure();
            this.unregister();
            if (!this.armyStorage.isEmpty() && player.getNation() != null) {
                ArmyStack stack = new ArmyStack(player.getNation());
                stack.armies = new HashMap<ArmyType, ArmyStack.Unit>(this.armyStorage);
                stack.supply = stack.getMaxSupply();
                this.armyStorage.clear();
                ArmyCamp c = new ArmyCamp();
                c.stack = stack;
                c.location = this.location;
                stack.curHolder = c;
                c.place();
            }
            return false;
        }
        return true;
    }

    public record Recipe(ArmyType armyType, long duration) {
    }
}

