/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.planetlib.hook;

import cn.jason31416.planetlib.PlanetLib;
import javax.annotation.Nonnull;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultHook {
    private static RegisteredServiceProvider<Economy> rsp = null;

    public static void init() {
        rsp = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            PlanetLib.instance.getLogger().info("\u001b[31mFailed to hook Vault, disabling plugin...\u001b[0m");
            Bukkit.getPluginManager().disablePlugin((Plugin)PlanetLib.instance);
            return;
        }
        PlanetLib.instance.getLogger().info("\u001b[32mHook Vault successfully\u001b[0m");
    }

    public static void end() {
    }

    public static double getBalance(@Nonnull OfflinePlayer player) {
        if (rsp == null) {
            Bukkit.getLogger().severe("BetterNations: Attempted to access Vault without proper initialization...");
            return 0.0;
        }
        return ((Economy)rsp.getProvider()).getBalance(player);
    }

    public static void depositBalance(@Nonnull OfflinePlayer player, double balance) {
        if (rsp != null) {
            ((Economy)rsp.getProvider()).depositPlayer(player, balance);
        } else {
            Bukkit.getLogger().severe("BetterNations: Attempted to access Vault without proper initialization...");
        }
    }

    public static boolean withdrawBalance(@Nonnull OfflinePlayer player, double balance) {
        if (VaultHook.getBalance(player) < balance) {
            return false;
        }
        if (rsp != null) {
            ((Economy)rsp.getProvider()).withdrawPlayer(player, balance);
        }
        return true;
    }

    public static boolean haveBalance(@Nonnull OfflinePlayer player, double balance) {
        return VaultHook.getBalance(player) >= balance;
    }

    public static void setBalance(@Nonnull OfflinePlayer player, double balance) {
        if (VaultHook.getBalance(player) >= balance) {
            VaultHook.withdrawBalance(player, VaultHook.getBalance(player) - balance);
        } else {
            VaultHook.depositBalance(player, balance - VaultHook.getBalance(player));
        }
    }
}

