/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.planetlib.item;

import cn.jason31416.planetlib.hook.NbtHook;
import cn.jason31416.planetlib.item.CustomItemType;
import cn.jason31416.planetlib.item.VanillaItemType;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public abstract class ItemType {
    public abstract Material getMaterial();

    public abstract String getName();

    public ItemStack getItemStack() {
        return this.getItemStack(1);
    }

    public ItemStack getItemStack(int amount) {
        return new ItemStack(this.getMaterial(), amount);
    }

    public boolean allowInteraction() {
        return true;
    }

    public boolean equals(Object ot) {
        if (ot == null) {
            return this.getMaterial() == Material.AIR;
        }
        if (ot instanceof ItemType) {
            ItemType other = (ItemType)ot;
            return other.getName().equals(this.getName());
        }
        return false;
    }

    public static ItemType getItemType(String name) {
        if (CustomItemType.itemTypes.containsKey(name.toLowerCase())) {
            return CustomItemType.itemTypes.get(name.toLowerCase());
        }
        try {
            return new VanillaItemType(Material.getMaterial((String)name.toUpperCase()));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to find the item type: " + name);
        }
    }

    public static ItemType getItemType(ItemStack item) {
        if (item == null) {
            return new VanillaItemType(Material.AIR);
        }
        if (NbtHook.hasTag(item, "plib.itemType") && CustomItemType.itemTypes.containsKey(NbtHook.getTag(item, "plib.itemType"))) {
            return CustomItemType.get(item);
        }
        return new VanillaItemType(item.getType());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

