/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.planetlib.message;

import cn.jason31416.planetlib.PlanetLib;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.message.MessageList;
import cn.jason31416.planetlib.message.StringMessage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MessageLoader {
    public static MessageLoader instance;
    public ConfigurationSection messageConfig;

    public MessageLoader(ConfigurationSection messageConfig) {
        this.messageConfig = messageConfig;
    }

    public MessageLoader(File filePath) {
        try {
            this.messageConfig = YamlConfiguration.loadConfiguration((File)filePath);
        }
        catch (Exception ignored) {
            throw new RuntimeException("Failed to load message config file!");
        }
    }

    public StringMessage getStringMessage(String key, String defaultMessage) {
        if (this.messageConfig.isList(key)) {
            return new StringMessage(String.join((CharSequence)"\n", this.messageConfig.getStringList(key)));
        }
        if (this.messageConfig.contains(key)) {
            return new StringMessage(this.messageConfig.getString(key));
        }
        return defaultMessage == null ? null : new StringMessage(defaultMessage);
    }

    public String getRawMessage(String key, String defaultMessage) {
        if (this.messageConfig.contains(key)) {
            return this.messageConfig.getString(key);
        }
        return defaultMessage;
    }

    public List<String> getStringList(String key, List<String> defaultList) {
        if (this.messageConfig.isList(key)) {
            return this.messageConfig.getStringList(key);
        }
        return defaultList;
    }

    public static MessageList getList(String key) {
        if (instance == null) {
            throw new RuntimeException("Planetlib not initialized!");
        }
        return new MessageList(instance.getStringList(key, new ArrayList<String>()));
    }

    public static MessageList getList(String key, List<String> defaultList) {
        if (instance == null) {
            throw new RuntimeException("Planetlib not initialized!");
        }
        return new MessageList(instance.getStringList(key, defaultList));
    }

    public static Message getMessage(String key) {
        if (instance == null) {
            throw new RuntimeException("Planetlib not initialized!");
        }
        return instance.getStringMessage(key, "<red>Error: message " + key + " not found, please contact admin!");
    }

    public static Message getMessage(String key, String defaultMessage) {
        if (instance == null) {
            throw new RuntimeException("Planetlib not initialized!");
        }
        return instance.getStringMessage(key, defaultMessage);
    }

    public static void initialize(File filePath, JavaPlugin plugin) {
        PlanetLib.instance.getLogger().info("\u001b[34mLoading messages: " + filePath.getName() + "\u001b[0m");
        instance = new MessageLoader(filePath);
        StringMessage.bukkitAudiences = BukkitAudiences.create((Plugin)plugin);
        StringMessage.miniMessage = MiniMessage.miniMessage();
    }

    public static void close() {
        StringMessage.bukkitAudiences.close();
    }
}

