/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.army;

import cn.jason31416.betternations.army.ArmyStack;
import cn.jason31416.betternations.army.ArmyType;
import cn.jason31416.betternations.army.states.StructuredArmy;
import cn.jason31416.betternations.army.states.TransportArmy;
import cn.jason31416.betternations.mob.SimpleMob;
import cn.jason31416.planetlib.Config;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.wrapper.SimpleLocation;
import cn.jason31416.planetlib.wrapper.SimplePlayer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;

public class BreakCampRunnable
extends BukkitRunnable {
    public static Map<SimplePlayer, BreakCampRunnable> breakingPlayers = new HashMap<SimplePlayer, BreakCampRunnable>();
    public SimplePlayer breaker;
    public StructuredArmy camp;
    public static HashSet<Entity> defendingMobs = new HashSet();
    public Map<ArmyType, ArmyStack.Unit> unitLeft = new HashMap<ArmyType, ArmyStack.Unit>();
    public Map<SimpleMob, ArmyType> instanceMobs = new HashMap<SimpleMob, ArmyType>();

    public BreakCampRunnable(SimplePlayer breaker, StructuredArmy camp) {
        this.breaker = breaker;
        this.camp = camp;
        breakingPlayers.put(breaker, this);
        for (ArmyType i : camp.stack.armies.keySet()) {
            this.unitLeft.put(i, camp.stack.armies.get(i).copy());
        }
    }

    public ArmyType getNextType() {
        if (this.unitLeft.isEmpty()) {
            return null;
        }
        int rnd = new Random().nextInt() % this.camp.stack.size();
        for (ArmyType i : this.unitLeft.keySet()) {
            if ((rnd -= this.unitLeft.get((Object)i).count) >= 0) continue;
            return i;
        }
        return null;
    }

    public void failed() {
        Message.getMessage("combat.breakage.failed").send(this.breaker);
        breakingPlayers.remove(this.breaker);
        this.camp.runnable = null;
        for (SimpleMob i : this.instanceMobs.keySet()) {
            defendingMobs.remove(i.getBukkitEntity());
            if (!i.isAlive()) continue;
            i.remove();
        }
        this.camp.hologram.setText(this.camp.getHologramText());
        this.camp.stack.processDamageQueue();
        this.cancel();
    }

    public void run() {
        ArmyType type;
        if (!this.camp.running) {
            this.cancel();
            return;
        }
        while (this.instanceMobs.size() < Config.getInt("combat.defend-units", 10) && (type = this.getNextType()) != null) {
            SimpleMob mob = SimpleMob.spawn(type.type, this.breaker.getLocation(), Message.getMessage("combat.defender-name").add("nation", this.camp.stack.nation.getColorTag() + this.camp.stack.nation.getName()).add("type", type.name).toString());
            double hp = this.unitLeft.get((Object)type).hp / (double)this.unitLeft.get((Object)type).count;
            mob.setMaxHealth(hp);
            mob.setHealth(hp);
            this.unitLeft.get((Object)type).hp -= hp;
            --this.unitLeft.get((Object)type).count;
            if (this.unitLeft.get((Object)type).count <= 0) {
                this.unitLeft.remove(type);
            }
            this.instanceMobs.put(mob, type);
            defendingMobs.add(mob.getBukkitEntity());
        }
        if (this.instanceMobs.isEmpty()) {
            Message.getMessage("combat.breakage.success").send(this.breaker);
            breakingPlayers.remove(this.breaker);
            this.camp.stack.armies.clear();
            this.camp.breakStructure();
            this.camp.unregister();
            this.cancel();
            return;
        }
        for (SimpleMob i : new ArrayList<SimpleMob>(this.instanceMobs.keySet())) {
            if (!i.isAlive()) {
                defendingMobs.remove(i.getBukkitEntity());
                this.instanceMobs.remove(i);
                continue;
            }
            if (i.getLocation().getChunkLocation().equals(this.camp.location.getChunkLocation())) continue;
            i.teleport(this.breaker.getLocation());
        }
    }

    public static class CampBreakingListener
    implements Listener {
        @EventHandler
        public void onMobDeath(EntityDeathEvent event) {
            if (defendingMobs.contains(event.getEntity())) {
                event.setDroppedExp(0);
                event.getDrops().clear();
                defendingMobs.remove(event.getEntity());
            }
        }

        @EventHandler
        public void onMobHeal(EntityRegainHealthEvent event) {
            if (defendingMobs.contains(event.getEntity())) {
                event.setCancelled(true);
            }
        }

        @EventHandler
        public void onMobDamaged(EntityDamageByEntityEvent event) {
            if (defendingMobs.contains(event.getEntity())) {
                Entity entity = event.getDamager();
                if (entity instanceof Player) {
                    Player pl = (Player)entity;
                    p = SimplePlayer.of(pl);
                    if (!((SimplePlayer)p).getLocation().getChunkLocation().equals(SimpleLocation.of(event.getEntity().getLocation()).getChunkLocation())) {
                        event.setCancelled(true);
                    }
                } else {
                    Player pl;
                    SimplePlayer p;
                    Projectile pj;
                    ProjectileSource projectileSource;
                    p = event.getDamager();
                    if (p instanceof Projectile && (projectileSource = (pj = (Projectile)p).getShooter()) instanceof Player && !(p = SimplePlayer.of(pl = (Player)projectileSource)).getLocation().getChunkLocation().equals(SimpleLocation.of(event.getEntity().getLocation()).getChunkLocation())) {
                        event.setCancelled(true);
                    }
                }
            }
        }

        @EventHandler
        public void onMobDamaged(EntityDamageEvent event) {
            if ((defendingMobs.contains(event.getEntity()) || TransportArmy.transportArmyMap.containsKey(event.getEntity())) && Config.getConfig().getStringList("combat.disabled-damage-source").contains(event.getCause().name())) {
                event.setCancelled(true);
            }
        }

        @EventHandler
        public void onPlayerMove(PlayerMoveEvent event) {
            SimplePlayer player = SimplePlayer.of(event.getPlayer());
            if (event.getTo() == null) {
                return;
            }
            if (breakingPlayers.containsKey(player) && !BreakCampRunnable.breakingPlayers.get((Object)player).camp.location.getChunkLocation().equals(SimpleLocation.of(event.getTo()).getChunkLocation())) {
                breakingPlayers.get(player).failed();
            }
        }

        @EventHandler
        public void onPlayerTeleport(PlayerTeleportEvent event) {
            SimplePlayer player = SimplePlayer.of(event.getPlayer());
            if (event.getTo() == null) {
                return;
            }
            if (breakingPlayers.containsKey(player) && !BreakCampRunnable.breakingPlayers.get((Object)player).camp.location.getChunkLocation().equals(SimpleLocation.of(event.getTo()).getChunkLocation())) {
                breakingPlayers.get(player).failed();
            }
        }

        @EventHandler
        public void onPlayerDeath(PlayerDeathEvent event) {
            SimplePlayer player = SimplePlayer.of(event.getEntity());
            if (breakingPlayers.containsKey(player)) {
                breakingPlayers.get(player).failed();
            }
        }

        @EventHandler
        public void onPlayerQuit(PlayerQuitEvent event) {
            SimplePlayer player = SimplePlayer.of(event.getPlayer());
            if (breakingPlayers.containsKey(player)) {
                breakingPlayers.get(player).failed();
            }
        }

        @EventHandler
        public void onMobLeashed(PlayerLeashEntityEvent event) {
            if (defendingMobs.contains(event.getEntity())) {
                event.setCancelled(true);
            }
        }
    }
}

