/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.army.states;

import cn.jason31416.betternations.BetterNations;
import cn.jason31416.betternations.army.ArmyStack;
import cn.jason31416.betternations.army.states.ArmyCamp;
import cn.jason31416.betternations.army.states.ArmyStackHolder;
import cn.jason31416.betternations.mob.SimpleMob;
import cn.jason31416.planetlib.Config;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.wrapper.SimpleLocation;
import cn.jason31416.planetlib.wrapper.SimplePlayer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class TransportArmy
implements ArmyStackHolder {
    public static Map<SimplePlayer, Set<TransportArmy>> transports = new HashMap<SimplePlayer, Set<TransportArmy>>();
    public static Map<Entity, TransportArmy> transportArmyMap = new HashMap<Entity, TransportArmy>();
    public SimpleMob mob;
    public SimplePlayer player;
    public ArmyStack stack;
    public BukkitRunnable runnable;
    public boolean isActive = true;

    public TransportArmy(final SimplePlayer player, final SimpleMob mob, ArmyStack stack) {
        stack.curHolder = this;
        this.stack = stack;
        this.mob = mob;
        this.player = player;
        if (!transports.containsKey(player)) {
            transports.put(player, new HashSet());
        }
        transports.get(player).add(this);
        transportArmyMap.put(mob.getBukkitEntity(), this);
        this.runnable = new BukkitRunnable(){
            double curPenalty = 0.1;
            long lstwarn = 0L;

            public void run() {
                Waterlogged a;
                BlockData blockData;
                mob.setTarget((LivingEntity)player.getPlayer());
                if (!(mob.getBukkitEntity().getVehicle() instanceof Boat) && (mob.getLocation().getBlockMaterial() == Material.WATER || mob.getLocation().getBlockMaterial() == Material.BUBBLE_COLUMN || (blockData = mob.getLocation().getBlock().getBlockData()) instanceof Waterlogged && (a = (Waterlogged)blockData).isWaterlogged())) {
                    mob.damage(this.curPenalty);
                    this.curPenalty += 0.02;
                } else {
                    this.curPenalty = 0.1;
                }
                if (!player.getLocation().world().equals(mob.getLocation().world()) || player.getLocation().getBukkitLocation().distance(mob.getLocation().getBukkitLocation()) >= Config.getDouble("combat.transport-max-distance")) {
                    TransportArmy.this.encamp();
                } else if (player.getLocation().getBukkitLocation().distance(mob.getLocation().getBukkitLocation()) >= Config.getDouble("combat.transport-warn-distance") & System.currentTimeMillis() - this.lstwarn > 750L) {
                    Message.getMessage("combat.transport-too-far").send(player);
                    this.lstwarn = System.currentTimeMillis();
                }
            }
        };
        this.runnable.runTaskTimer((Plugin)BetterNations.instance, 10L, 0L);
    }

    public void unregister() {
        transportArmyMap.remove(this.mob.getBukkitEntity());
        if (transports.containsKey(this.player)) {
            transports.get(this.player).remove(this);
            if (transports.get(this.player).isEmpty()) {
                transports.remove(this.player);
            }
        }
        this.runnable.cancel();
        this.isActive = false;
    }

    public void destroy(boolean doKill) {
        Message.getMessage("combat.transport-destroyed").send(this.player);
        this.unregister();
        if (doKill) {
            this.mob.remove();
        }
    }

    public void encamp() {
        if (this.isActive) {
            SimpleLocation loc = this.mob.getLocation().getBlockLocation();
            while (loc.y() < (double)loc.world().getBukkitWorld().getMaxHeight() && loc.getBlockMaterial() != Material.AIR) {
                loc = loc.getRelative(0.0, 1.0, 0.0);
            }
            if (loc.y() >= (double)loc.world().getBukkitWorld().getMaxHeight()) {
                return;
            }
            ArmyCamp c = new ArmyCamp();
            this.unregister();
            c.stack = this.stack;
            c.location = loc;
            this.stack.curHolder = c;
            c.place();
            this.mob.remove();
        }
    }

    @Override
    public ArmyStack getStack() {
        return this.stack;
    }

    public void destroy() {
        this.destroy(true);
    }

    @Override
    public SimpleLocation getLocation() {
        return this.mob.getLocation();
    }

    public static void spawn(SimpleLocation location, SimplePlayer player, ArmyStack stack) {
        SimpleMob mob = SimpleMob.spawn(Config.getString("combat.transport-mob"), location, "");
        mob.setMaxHealth(stack.getHealth());
        mob.setHealth(stack.getHealth());
        PotionEffect effect = new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, 1000000, 3);
        effect.apply((LivingEntity)mob.getBukkitEntity());
        TransportArmy army = new TransportArmy(player, mob, stack);
        army.updateName();
        stack.curHolder = army;
    }

    public void updateName() {
        this.mob.setName(Message.getMessage("combat.transport-name").add("nation", this.stack.nation.getColorTag() + this.stack.nation.getName()).add("hp", (double)Math.round(this.stack.getHealth() * 10.0) / 10.0).add("mxhp", (double)Math.round(this.stack.getMaxHealth() * 10.0) / 10.0).add("units", this.stack.size()).toString());
    }
}

