/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.command.admin;

import cn.jason31416.betternations.item.CustomItemType;
import cn.jason31416.betternations.item.ItemType;
import cn.jason31416.planetlib.command.ChildCommand;
import cn.jason31416.planetlib.command.ICommandContext;
import cn.jason31416.planetlib.command.IParentCommand;
import cn.jason31416.planetlib.command.ParameterType;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.wrapper.SimplePlayer;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class GiveCommand
extends ChildCommand {
    public GiveCommand(IParentCommand parent) {
        super(List.of("give", "item"), parent);
    }

    @Override
    @Nullable
    public Message execute(ICommandContext context) {
        if (!context.getSender().sender().isOp()) {
            return Message.getMessage("command.failed.no-permission");
        }
        if (!context.checkArgs(ParameterType.STRING)) {
            return null;
        }
        SimplePlayer target = null;
        if (context.getSender().isPlayer()) {
            target = context.getSender().toPlayer();
        }
        if (context.args().size() >= 2) {
            target = context.getPlayerArg(1);
        }
        if (target == null || !target.isOnline()) {
            return Message.getMessage("command.failed.invalid-target");
        }
        if (!CustomItemType.itemTypes.containsKey(context.getArg(0).toLowerCase())) {
            return Message.getMessage("command.failed.unknown-item-type");
        }
        ItemType type = CustomItemType.itemTypes.get(context.getArg(0).toLowerCase());
        target.getPlayer().getInventory().addItem(new ItemStack[]{type.getItemStack()});
        return Message.getMessage("command.success.give-item").add("item", type.getName()).add("player", target.getName());
    }

    @Override
    public List<String> tabComplete(ICommandContext context) {
        if (context.getCurrentArg() == 1) {
            return new ArrayList<String>(CustomItemType.itemTypes.keySet());
        }
        if (context.getCurrentArg() == 2) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).toList();
        }
        return null;
    }
}

