/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.command.admin;

import cn.jason31416.betternations.item.CustomItemType;
import cn.jason31416.betternations.item.ItemType;
import cn.jason31416.betternations.manager.NaturalResourcesManager;
import cn.jason31416.planetlib.command.ChildCommand;
import cn.jason31416.planetlib.command.ICommandContext;
import cn.jason31416.planetlib.command.IParentCommand;
import cn.jason31416.planetlib.message.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.jetbrains.annotations.Nullable;

public class SetNaturalResourceCommand
extends ChildCommand {
    public SetNaturalResourceCommand(IParentCommand parent) {
        super("resource", parent);
    }

    @Override
    @Nullable
    public Message execute(ICommandContext context) {
        if (context.getPlayer() == null) {
            return null;
        }
        if (!context.getPlayer().getPlayer().isOp()) {
            return Message.getMessage("command.failed.no-permission");
        }
        ItemType itemType = null;
        if (!context.args().isEmpty()) {
            try {
                itemType = ItemType.getItemType(context.getArg(0));
                assert (itemType != null && itemType.getMaterial() != null);
            }
            catch (Exception e) {
                return Message.getMessage("command.failed.invalid-item-type");
            }
        }
        if (itemType == null) {
            NaturalResourcesManager.naturalResourcesMap.remove(context.getPlayer().getLocation().getChunkLocation());
        } else {
            NaturalResourcesManager.naturalResourcesMap.put(context.getPlayer().getLocation().getChunkLocation(), itemType);
        }
        NaturalResourcesManager.save();
        return Message.getMessage("command.success.set-natural-resource").add("resource", context.getArg(0));
    }

    @Override
    public List<String> tabComplete(ICommandContext context) {
        if (!context.getPlayer().getPlayer().isOp()) {
            return null;
        }
        ArrayList<String> suggestions = new ArrayList<String>(Arrays.stream(Material.values()).map(Enum::name).map(String::toLowerCase).toList());
        suggestions.addAll(CustomItemType.itemTypes.keySet());
        return suggestions.stream().filter(s -> s.startsWith(context.getArg(0).toLowerCase())).toList();
    }
}

