/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.item;

import cn.jason31416.betternations.item.ItemType;
import cn.jason31416.planetlib.hook.NbtHook;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;

public class CustomItemType
extends ItemType {
    public static Map<String, CustomItemType> itemTypes = new HashMap<String, CustomItemType>();
    public final String registryName;
    public final String displayName;
    public int customModelData = 0;
    public final Material material;
    public final String skullValue;
    public final List<String> lore;
    public final Map<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
    public boolean glow = false;
    public boolean allowInteraction = true;

    @Override
    public Material getMaterial() {
        return this.material;
    }

    public CustomItemType(String registryName, String displayName, Material material, List<String> lore) {
        this.registryName = registryName;
        this.displayName = displayName;
        this.lore = lore;
        this.material = material;
        this.skullValue = null;
    }

    public CustomItemType(String registryName, String displayName, String skullValue, List<String> lore) {
        this.registryName = registryName;
        this.displayName = displayName;
        this.lore = lore;
        this.material = Material.PLAYER_HEAD;
        this.skullValue = skullValue;
        this.allowInteraction = false;
    }

    public CustomItemType(String registryName, String displayName, Material material, List<String> lore, boolean allowInteraction) {
        this(registryName, displayName, material, lore);
        this.allowInteraction = allowInteraction;
    }

    public ItemStack newItemStack(int amount) {
        ItemStack itemStack = new ItemStack(this.material, amount);
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            throw new RuntimeException("item meta is null");
        }
        itemMeta.setDisplayName(this.displayName);
        itemMeta.setLore(this.lore);
        if (this.customModelData != 0) {
            itemMeta.setCustomModelData(Integer.valueOf(this.customModelData));
        }
        try {
            if (itemMeta instanceof SkullMeta) {
                SkullMeta meta = (SkullMeta)itemMeta;
                if (this.skullValue != null) {
                    PlayerProfile profile = Bukkit.getServer().createPlayerProfile(UUID.nameUUIDFromBytes(this.registryName.getBytes()));
                    PlayerTextures textures = profile.getTextures();
                    textures.setSkin(new URL("https://textures.minecraft.net/texture/" + this.skullValue));
                    profile.setTextures(textures);
                    meta.setOwnerProfile(profile);
                }
            }
        }
        catch (MalformedURLException ignored) {
            throw new RuntimeException(ignored);
        }
        if (this.glow) {
            itemMeta.addEnchant(Enchantment.DURABILITY, 1, true);
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        } else if (!this.enchantments.isEmpty()) {
            for (Enchantment i : this.enchantments.keySet()) {
                itemMeta.addEnchant(i, this.enchantments.get(i).intValue(), true);
            }
        }
        itemStack.setItemMeta(itemMeta);
        NbtHook.setTag(itemStack, "plib.itemType", this.registryName);
        return itemStack;
    }

    @Override
    public boolean allowInteraction() {
        return this.allowInteraction;
    }

    public CustomItemType setCustomModelData(int customModelData) {
        this.customModelData = customModelData;
        return this;
    }

    public void register() {
        itemTypes.put(this.registryName, this);
    }

    @Override
    public String getName() {
        return this.registryName;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof CustomItemType) {
            CustomItemType type = (CustomItemType)other;
            return type.registryName.equals(this.registryName);
        }
        return false;
    }

    @Override
    public ItemStack getItemStack(int amount) {
        return this.newItemStack(amount);
    }

    public static CustomItemType get(String registryName) {
        return itemTypes.get(registryName);
    }

    public static CustomItemType get(ItemStack itemStack) {
        if (NbtHook.hasTag(itemStack, "plib.itemType")) {
            return CustomItemType.get(NbtHook.getTag(itemStack, "plib.itemType"));
        }
        return null;
    }
}

