/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.lib.nbtapi;

import cn.jason31416.betternations.lib.nbtapi.NBTCompound;
import cn.jason31416.betternations.lib.nbtapi.NBTContainer;
import cn.jason31416.betternations.lib.nbtapi.NBTList;
import cn.jason31416.betternations.lib.nbtapi.NBTType;
import cn.jason31416.betternations.lib.nbtapi.NbtApiException;
import cn.jason31416.betternations.lib.nbtapi.utils.nmsmappings.ClassWrapper;
import cn.jason31416.betternations.lib.nbtapi.utils.nmsmappings.ReflectionMethod;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class NBTIntArrayList
extends NBTList<int[]> {
    private final NBTContainer tmpContainer = new NBTContainer();

    protected NBTIntArrayList(NBTCompound owner, String name, NBTType type, Object list) {
        super(owner, name, type, list);
    }

    @Override
    protected Object asTag(int[] object) {
        try {
            Constructor<?> con = ClassWrapper.NMS_NBTTAGINTARRAY.getClazz().getDeclaredConstructor(int[].class);
            con.setAccessible(true);
            return con.newInstance(new Object[]{object});
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new NbtApiException("Error while wrapping the Object " + object + " to it's NMS object!", e);
        }
    }

    @Override
    public int[] get(int index) {
        try {
            Object obj = ReflectionMethod.LIST_GET.run(this.listObject, index);
            ReflectionMethod.COMPOUND_SET.run(this.tmpContainer.getCompound(), "tmp", obj);
            int[] val2 = this.tmpContainer.getIntArray("tmp");
            this.tmpContainer.removeKey("tmp");
            return val2;
        }
        catch (NumberFormatException nf) {
            return null;
        }
        catch (Exception ex) {
            throw new NbtApiException(ex);
        }
    }
}

