/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.manager;

import cn.jason31416.betternations.BetterNations;
import cn.jason31416.betternations.army.ArmyStack;
import cn.jason31416.betternations.army.ArmyType;
import cn.jason31416.betternations.army.states.InvasionFlag;
import cn.jason31416.betternations.army.states.SiegeFlag;
import cn.jason31416.betternations.nation.Nation;
import cn.jason31416.betternations.nation.Relation;
import cn.jason31416.betternations.nation.Town;
import cn.jason31416.planetlib.Config;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.wrapper.SimpleChunkLocation;
import cn.jason31416.planetlib.wrapper.SimpleLocation;
import cn.jason31416.planetlib.wrapper.SimplePlayer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BarbarianInvasionManager {
    private static Nation barbarianNation = null;

    public static Nation getBarbarianNation() {
        if (barbarianNation == null && (barbarianNation = Nation.getNation(Config.getString("barbarian.barbarian-nation-name", "Barbarians"))) == null) {
            barbarianNation = Nation.createNation(SimplePlayer.of("_#Neutral.Player"), Config.getString("barbarian.barbarian-nation-name", "Barbarians"));
        }
        return barbarianNation;
    }

    public static void startBarbarianInvasionAt(SimpleChunkLocation chunkLocation, final ArmyStack stack) {
        if (chunkLocation.isTownChunk() || !chunkLocation.isClaimed()) {
            return;
        }
        if (BarbarianInvasionManager.getBarbarianNation().nationalChunks.contains(chunkLocation)) {
            return;
        }
        Nation nation = chunkLocation.getNation();
        if (!BarbarianInvasionManager.getBarbarianNation().getRelation(nation).equals((Object)Relation.ENEMY)) {
            BarbarianInvasionManager.getBarbarianNation().setRelation(nation, Relation.ENEMY);
        }
        Random rand = new Random();
        SimpleLocation loc = SimpleLocation.of(chunkLocation.getBukkitWorld().getHighestBlockAt(chunkLocation.x() * 16 + rand.nextInt(16), chunkLocation.z() * 16 + rand.nextInt(16)));
        while (loc.y() < (double)loc.world().getBukkitWorld().getMaxHeight() && loc.getBlockMaterial() != Material.AIR) {
            loc = loc.getRelative(0.0, 1.0, 0.0);
        }
        if (loc.y() >= (double)loc.world().getBukkitWorld().getMaxHeight()) {
            loc = loc.getRelative(0.0, -1.0, 0.0);
        }
        final SimpleLocation location = loc;
        new BukkitRunnable(){

            public void run() {
                InvasionFlag c = new InvasionFlag();
                c.stack = stack;
                c.location = location;
                stack.curHolder = c;
                c.place();
            }
        }.runTaskLater((Plugin)BetterNations.instance, 1L);
        Message.getMessage("combat.barbarian-invasion-started").add("nation", chunkLocation.getNation().getName()).add("location", loc.x() + "," + loc.y() + "," + loc.z()).send(chunkLocation.getNation().getMembers());
    }

    public static void startBarbarianSiege(SimpleChunkLocation chunkLocation, final ArmyStack stack, final Town town) {
        Nation nation = town.getNation();
        if (!BarbarianInvasionManager.getBarbarianNation().getRelation(nation).equals((Object)Relation.ENEMY)) {
            BarbarianInvasionManager.getBarbarianNation().setRelation(nation, Relation.ENEMY);
        }
        SimpleLocation loc = SimpleLocation.of(chunkLocation.getBukkitWorld().getHighestBlockAt(chunkLocation.x() * 16 + 8, chunkLocation.z() * 16 + 8));
        while (loc.y() < (double)loc.world().getBukkitWorld().getMaxHeight() && loc.getBlockMaterial() != Material.AIR) {
            loc = loc.getRelative(0.0, 1.0, 0.0);
        }
        if (loc.y() >= (double)loc.world().getBukkitWorld().getMaxHeight()) {
            loc = loc.getRelative(0.0, -1.0, 0.0);
        }
        final SimpleLocation location = loc;
        new BukkitRunnable(){

            public void run() {
                SiegeFlag c = new SiegeFlag();
                c.target = town;
                c.location = location;
                c.stack = stack;
                stack.curHolder = c;
                c.place();
            }
        }.runTaskLater((Plugin)BetterNations.instance, 1L);
    }

    private static ArmyStack createArmyStack() {
        ArmyStack stack = new ArmyStack(BarbarianInvasionManager.getBarbarianNation());
        stack.supply = 100.0;
        ArrayList possibleTypes = new ArrayList(Config.config.getConfigurationSection("barbarian.army.units").getKeys(false));
        int tot = 0;
        for (String type : possibleTypes) {
            tot += Config.getInt("barbarian.army.units." + type, 0);
        }
        for (int i = 0; i < Config.getInt("barbarian.army.initial-count", 10); ++i) {
            int cur;
            int num = new Random().nextInt(tot);
            for (cur = 0; cur < possibleTypes.size() && num >= Config.getInt("barbarian.army.units." + (String)possibleTypes.get(cur), 0); num -= Config.getInt("barbarian.army.units." + (String)possibleTypes.get(cur), 0), ++cur) {
            }
            String type = (String)possibleTypes.get(cur);
            stack.addArmy(ArmyType.armyTypes.get(type), 1);
        }
        return stack;
    }

    public static void attemptStartBarbarianInvasion() {
        SimpleChunkLocation rand;
        block7: {
            if (Nation.chunkNationMap.isEmpty()) {
                return;
            }
            ArrayList<SimpleChunkLocation> chunkLocations = new ArrayList<SimpleChunkLocation>(Nation.chunkNationMap.keySet());
            rand = (SimpleChunkLocation)chunkLocations.get(new Random().nextInt(chunkLocations.size()));
            if (BarbarianInvasionManager.getBarbarianNation().nationalChunks.contains(rand)) {
                return;
            }
            if (rand.isTownChunk()) {
                List<SimpleChunkLocation> adjs = rand.getAdjacentChunks();
                Collections.shuffle(adjs);
                for (SimpleChunkLocation adj : adjs) {
                    if (!adj.isClaimed()) {
                        BarbarianInvasionManager.getBarbarianNation().claim(adj);
                    }
                    if (!Objects.equals(adj.getNation(), BarbarianInvasionManager.getBarbarianNation()) || adj.isTownChunk()) continue;
                    BarbarianInvasionManager.startBarbarianSiege(adj, BarbarianInvasionManager.createArmyStack(), rand.getTown());
                    break;
                }
                return;
            }
            for (SimpleChunkLocation adj : rand.getAdjacentChunks()) {
                if (adj.isClaimed() && !Objects.equals(adj.getNation(), BarbarianInvasionManager.getBarbarianNation())) continue;
                break block7;
            }
            return;
        }
        if (!Config.config.contains("barbarian.army.units")) {
            return;
        }
        BarbarianInvasionManager.startBarbarianInvasionAt(rand, BarbarianInvasionManager.createArmyStack());
    }
}

