/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.manager;

import cn.jason31416.planetlib.Config;
import cn.jason31416.planetlib.update.UpdateTask;
import cn.jason31416.planetlib.wrapper.SimpleChunkLocation;
import cn.jason31416.planetlib.wrapper.SimpleLocation;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.entity.Player;

public class BorderDisplayManager
implements UpdateTask.RunnableTask {
    private void drawBorder(SimpleChunkLocation chunk, int dx, int dz, Player player, Color color, int shifting) {
        int i;
        int z;
        int x;
        Particle.DustOptions dustOptions = new Particle.DustOptions(color, (float)Config.getDouble("border-display.particle-size", 1.5));
        if (dx == 1) {
            x = chunk.x() * 16 + 15 - shifting;
            z = chunk.z() * 16 + shifting;
            for (i = 0; i < 16 - 2 * shifting; ++i) {
                player.spawnParticle(Particle.REDSTONE, SimpleLocation.of((double)x + 0.5, (double)player.getWorld().getHighestBlockYAt(x, z + i) + 1.1, (double)(z + i) + 0.5, chunk.world()).getBukkitLocation(), 1, (Object)dustOptions);
            }
        }
        if (dx == -1) {
            x = chunk.x() * 16 + shifting;
            z = chunk.z() * 16 + shifting;
            for (i = 0; i < 16 - 2 * shifting; ++i) {
                player.spawnParticle(Particle.REDSTONE, SimpleLocation.of((double)x + 0.5, (double)player.getWorld().getHighestBlockYAt(x, z + i) + 1.1, (double)(z + i) + 0.5, chunk.world()).getBukkitLocation(), 1, (Object)dustOptions);
            }
        }
        if (dz == 1) {
            x = chunk.x() * 16 + shifting;
            z = chunk.z() * 16 + 15 - shifting;
            for (i = 0; i < 16 - 2 * shifting; ++i) {
                player.spawnParticle(Particle.REDSTONE, SimpleLocation.of((double)(x + i) + 0.5, (double)player.getWorld().getHighestBlockYAt(x + i, z) + 1.1, (double)z + 0.5, chunk.world()).getBukkitLocation(), 1, (Object)dustOptions);
            }
        }
        if (dz == -1) {
            x = chunk.x() * 16 + shifting;
            z = chunk.z() * 16 + shifting;
            for (i = 0; i < 16 - 2 * shifting; ++i) {
                player.spawnParticle(Particle.REDSTONE, SimpleLocation.of((double)(x + i) + 0.5, (double)player.getWorld().getHighestBlockYAt(x + i, z) + 1.1, (double)z + 0.5, chunk.world()).getBukkitLocation(), 1, (Object)dustOptions);
            }
        }
    }

    private void checkChunk(SimpleChunkLocation chunk, int dx, int dz, Player player) {
        if (Config.getBoolean("border-display.nation-border", false) && chunk.getNation() != null && chunk.getRelative(dx, dz).getNation() != chunk.getNation()) {
            this.drawBorder(chunk, dx, dz, player, chunk.getNation().getColor(), 0);
        } else if (Config.getBoolean("border-display.town-border", false) && chunk.isTownChunk() && chunk.getRelative(dx, dz).getTown() != chunk.getTown()) {
            this.drawBorder(chunk, dx, dz, player, Color.fromRGB((int)180, (int)180, (int)180), 0);
        }
    }

    @Override
    public void run() {
        int range = Config.getInt("border-display.range", 3);
        for (Player player : Bukkit.getOnlinePlayers()) {
            for (int i = -range; i <= range; ++i) {
                for (int j = -range; j <= range; ++j) {
                    if (i * i + j * j > range * range) continue;
                    SimpleChunkLocation chunk = SimpleLocation.of(player.getLocation()).getChunkLocation().getRelative(i, j);
                    this.checkChunk(chunk, 0, 1, player);
                    this.checkChunk(chunk, 1, 0, player);
                    this.checkChunk(chunk, 0, -1, player);
                    this.checkChunk(chunk, -1, 0, player);
                }
            }
        }
    }
}

