/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.manager;

import cn.jason31416.betternations.army.states.InvasionFlag;
import cn.jason31416.betternations.army.states.SiegeFlag;
import cn.jason31416.betternations.army.states.StructuredArmy;
import cn.jason31416.betternations.command.chat.ChatCommand;
import cn.jason31416.betternations.command.nation.NationClaimCommand;
import cn.jason31416.betternations.command.nation.NationUnclaimCommand;
import cn.jason31416.betternations.command.town.TownClaimCommand;
import cn.jason31416.betternations.command.town.TownUnclaimCommand;
import cn.jason31416.betternations.nation.Nation;
import cn.jason31416.betternations.nation.Permission;
import cn.jason31416.betternations.nation.Relation;
import cn.jason31416.betternations.nation.Town;
import cn.jason31416.betternations.nation.TownRole;
import cn.jason31416.betternations.structure.AbstractStructure;
import cn.jason31416.planetlib.Config;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.message.StringMessage;
import cn.jason31416.planetlib.wrapper.SimpleChunkLocation;
import cn.jason31416.planetlib.wrapper.SimpleLocation;
import cn.jason31416.planetlib.wrapper.SimplePlayer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.projectiles.ProjectileSource;

public class EventListener
implements Listener {
    public static Map<SimplePlayer, AutoClaimingMode> autoClaiming = new HashMap<SimplePlayer, AutoClaimingMode>();

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        autoClaiming.remove(SimplePlayer.of(event.getPlayer()));
        ChatCommand.playerChatMap.remove(event.getPlayer().getName());
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onChat(PlayerChatEvent event) {
        if (!Config.getBoolean("enable-chat", true)) {
            return;
        }
        SimplePlayer player = SimplePlayer.of(event.getPlayer());
        ChatCommand.ChatInfo ci = ChatCommand.playerChatMap.getOrDefault(player.getName(), ChatCommand.CTGlobal);
        Nation nation = player.getNation();
        event.setCancelled(true);
        if (nation == null) {
            Message message = Message.getMessage("chat.no_nation").add("sender", player.getName()).add("message", event.getMessage().replace("<", "\\<")).addContext(player);
            message.broadcast();
            return;
        }
        Message message = Message.getMessage("chat.with_nation").add("sender", player.getName()).add("nation", nation.getName()).add("nation_color", nation.getColorTag()).add("title", player.getRank().getDisplayName()).add("message", event.getMessage().replace("<", "\\<")).addContext(player);
        if (ci.type == ChatCommand.ChatType.NATION) {
            if (player.getNation() == null) {
                ChatCommand.playerChatMap.put(player.getName(), ChatCommand.CTGlobal);
            } else {
                message.add("domain", Message.getMessage("chat.prefix_nation").toFormatted());
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (SimplePlayer.of(p).getNation() != player.getNation()) continue;
                    message.send((CommandSender)p);
                }
                message.send((CommandSender)Bukkit.getConsoleSender());
                return;
            }
        }
        if (ci.type == ChatCommand.ChatType.TOWN) {
            Town t = ci.town;
            if (t == null || t.getRole(player) == TownRole.NONE) {
                ChatCommand.playerChatMap.put(player.getName(), ChatCommand.CTGlobal);
            } else {
                message = message.add("domain", Message.getMessage("chat.prefix_town").add("town", ci.town.getName()).toFormatted());
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (t.getRole(SimplePlayer.of(p)).equals((Object)TownRole.NONE)) continue;
                    message.send((CommandSender)p);
                }
                message.send((CommandSender)Bukkit.getConsoleSender());
                return;
            }
        }
        message.add("domain", Message.getMessage("chat.prefix_global")).broadcast();
    }

    public static void sendCrossChunkMessage(SimplePlayer player, SimpleChunkLocation from, SimpleChunkLocation to) {
        String subtitle;
        String title;
        if (to.getNation() != null) {
            title = new StringMessage(to.getNation().getColorTag() + to.getNation().getName()).toString();
            subtitle = to.getTown() != null ? to.getTown().getName() : Message.getMessage("town.wilderness").addContext(player).toString();
        } else {
            title = "";
            subtitle = Message.getMessage("town.wilderness").addContext(player).toString();
        }
        player.sendTitle(title, subtitle, 10, 20, 10);
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent event) {
        if (event.getTo() == null) {
            return;
        }
        SimplePlayer player = SimplePlayer.of(event.getPlayer());
        SimpleChunkLocation from = SimpleLocation.of(event.getFrom()).getChunkLocation();
        SimpleChunkLocation to = SimpleLocation.of(event.getTo()).getChunkLocation();
        if (from.isTownChunk() != to.isTownChunk() || from.getTown() != to.getTown() || from.getNation() != to.getNation() || from.isClaimed() != to.isClaimed()) {
            EventListener.sendCrossChunkMessage(player, from, to);
        }
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        if (event.getTo() == null) {
            return;
        }
        SimplePlayer player = SimplePlayer.of(event.getPlayer());
        SimpleChunkLocation from = SimpleLocation.of(event.getFrom()).getChunkLocation();
        SimpleChunkLocation to = SimpleLocation.of(event.getTo()).getChunkLocation();
        if (to.getNation() != null) {
            boolean bb;
            boolean bl = bb = to.getNation().getRelation(player.getNation()) != Relation.ALLY;
            if (!bb) {
                for (StructuredArmy i : (Set)StructuredArmy.armyLocationMap.getOrDefault(to, new HashSet())) {
                    if (i.stack.nation.getRelation(to.getNation()) == Relation.ALLY) continue;
                    bb = true;
                    break;
                }
            }
            if (Config.getBoolean("nation.prevent-unfriendly-elytra", false) && bb && event.getPlayer().isGliding()) {
                event.getPlayer().setGliding(false);
                Message.getMessage("town.cannot-fly").addContext(player).sendActionbar(player);
            }
        }
        if (!from.equals(to)) {
            if (autoClaiming.containsKey(SimplePlayer.of(event.getPlayer()))) {
                switch (autoClaiming.get(SimplePlayer.of(event.getPlayer()))) {
                    case CLAIM: {
                        NationClaimCommand.claimWithChecks(player, to).send((CommandSender)event.getPlayer());
                        break;
                    }
                    case UNCLAIM: {
                        NationUnclaimCommand.unclaimWithChecks(player, to).send((CommandSender)event.getPlayer());
                        break;
                    }
                    case TOWN_CLAIM: {
                        if (from.getTown() == null) break;
                        TownClaimCommand.claimWithChecks(player, to, from.getTown()).send((CommandSender)event.getPlayer());
                        break;
                    }
                    case TOWN_UNCLAIM: {
                        TownUnclaimCommand.unclaimWithChecks(player, to).send((CommandSender)event.getPlayer());
                    }
                }
            } else if (from.isTownChunk() != to.isTownChunk() || from.getTown() != to.getTown() || from.getNation() != to.getNation() || from.isClaimed() != to.isClaimed()) {
                EventListener.sendCrossChunkMessage(player, from, to);
            }
        }
    }

    @EventHandler
    public void onWaterFlow(BlockFromToEvent event) {
        SimpleChunkLocation to = SimpleLocation.of(event.getToBlock()).getChunkLocation();
        SimpleChunkLocation from = SimpleLocation.of(event.getBlock()).getChunkLocation();
        if (to.getNation() != from.getNation()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        SimplePlayer player = SimplePlayer.of(event.getPlayer());
        if (!player.hasPermission(Permission.BUILD, SimpleLocation.of(event.getBlock()))) {
            event.setCancelled(true);
            Message.getMessage("town.cannot-build").sendActionbar(player);
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        SimplePlayer player = SimplePlayer.of(event.getPlayer());
        if (!player.hasPermission(Permission.BUILD, SimpleLocation.of(event.getBlock()))) {
            event.setCancelled(true);
            Message.getMessage("town.cannot-build").sendActionbar(player);
        } else {
            SimpleChunkLocation chunk = SimpleLocation.of(event.getBlock()).getChunkLocation();
            if (chunk.isTownChunk()) {
                Town t = chunk.getTown();
                Objects.requireNonNull(t);
                t.devPoints += Config.getDouble("town.dev-points.block-place");
            }
        }
    }

    @EventHandler
    public void onPlayerDamageVehicle(VehicleDestroyEvent event) {
        SimpleLocation loc = SimpleLocation.of(event.getVehicle().getLocation());
        Entity entity = event.getAttacker();
        if (entity instanceof Player) {
            Player dmger = (Player)entity;
            if (loc.getChunkLocation().isTownChunk() && loc.getChunkLocation().getNation() != SimplePlayer.of(dmger).getNation()) {
                event.setCancelled(true);
            }
        } else {
            Projectile pj;
            ProjectileSource projectileSource;
            entity = event.getAttacker();
            if (entity instanceof Projectile && (projectileSource = (pj = (Projectile)entity).getShooter()) instanceof Player) {
                Player pl = (Player)projectileSource;
                if (loc.getChunkLocation().isTownChunk() && loc.getChunkLocation().getNation() != SimplePlayer.of(pl).getNation()) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onPlayerAttackedInTown(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player pl = (Player)entity;
            loc = SimpleLocation.of(pl.getLocation());
            SimplePlayer sp = SimplePlayer.of(pl);
            if (loc.getChunkLocation().isTownChunk() && loc.getChunkLocation().getNation() == sp.getNation()) {
                Entity entity2 = event.getDamager();
                if (entity2 instanceof Player) {
                    Player dmger = (Player)entity2;
                    sdmger = SimplePlayer.of(dmger);
                    if (((SimplePlayer)sdmger).getNation() != sp.getNation()) {
                        event.setCancelled(true);
                    }
                } else {
                    Player dmger;
                    SimplePlayer sdmger;
                    Projectile pj;
                    ProjectileSource projectileSource;
                    sdmger = event.getDamager();
                    if (sdmger instanceof Projectile && (projectileSource = (pj = (Projectile)sdmger).getShooter()) instanceof Player && (sdmger = SimplePlayer.of(dmger = (Player)projectileSource)).getNation() != sp.getNation()) {
                        event.setCancelled(true);
                    }
                }
            }
        } else if (!(event.getEntity() instanceof Monster)) {
            loc = SimpleLocation.of(event.getEntity().getLocation());
            Entity pj = event.getDamager();
            if (pj instanceof Player) {
                Player dmger = (Player)pj;
                if (loc.getChunkLocation().isTownChunk() && loc.getChunkLocation().getNation() != SimplePlayer.of(dmger).getNation()) {
                    event.setCancelled(true);
                }
            } else {
                Projectile pj2;
                ProjectileSource projectileSource;
                pj = event.getDamager();
                if (pj instanceof Projectile && (projectileSource = (pj2 = (Projectile)pj).getShooter()) instanceof Player) {
                    Player pl = (Player)projectileSource;
                    if (loc.getChunkLocation().isTownChunk() && loc.getChunkLocation().getNation() != SimplePlayer.of(pl).getNation()) {
                        event.setCancelled(true);
                    }
                }
            }
        }
    }

    @EventHandler
    public void onBlockInteract(PlayerInteractEvent event) {
        SimplePlayer player = SimplePlayer.of(event.getPlayer());
        if (event.getClickedBlock() == null) {
            return;
        }
        if (AbstractStructure.structures.containsKey(SimpleLocation.of(event.getClickedBlock())) && AbstractStructure.structures.get(SimpleLocation.of(event.getClickedBlock())) instanceof StructuredArmy) {
            return;
        }
        if (!player.hasPermission(Permission.BUILD, SimpleLocation.of(event.getClickedBlock()))) {
            event.setCancelled(true);
            Message.getMessage("town.cannot-build").sendActionbar(player);
        }
    }

    @EventHandler
    public void onEntityInteract(PlayerInteractEntityEvent event) {
        SimplePlayer player = SimplePlayer.of(event.getPlayer());
        if (!player.hasPermission(Permission.BUILD, SimpleLocation.of(event.getRightClicked().getLocation()))) {
            event.setCancelled(true);
            Message.getMessage("town.cannot-build").sendActionbar(player);
        }
    }

    @EventHandler
    public void onPistonRetract(BlockPistonRetractEvent event) {
        for (Block i : event.getBlocks()) {
            SimpleLocation tolocation = SimpleLocation.of(i);
            SimpleLocation fromLocation = SimpleLocation.of(i.getRelative(event.getDirection(), 1).getLocation());
            if (tolocation.getChunkLocation().getNation() == fromLocation.getChunkLocation().getNation()) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onPistonPush(BlockPistonExtendEvent event) {
        for (Block i : event.getBlocks()) {
            SimpleLocation tolocation = SimpleLocation.of(i);
            SimpleLocation fromLocation = SimpleLocation.of(i.getRelative(event.getDirection(), 1).getLocation());
            if (tolocation.getChunkLocation().getNation() == fromLocation.getChunkLocation().getNation()) continue;
            event.setCancelled(true);
            return;
        }
    }

    private void handleExplosion(List<Block> blocks) {
        HashMap isInvasionCache = new HashMap();
        blocks.removeIf(block -> {
            SimpleLocation loc = SimpleLocation.of(block);
            if (StructuredArmy.armyLocationMap.containsKey(loc.getChunkLocation())) {
                if (!isInvasionCache.containsKey(loc.getChunkLocation())) {
                    for (StructuredArmy i : StructuredArmy.armyLocationMap.get(loc.getChunkLocation())) {
                        if (!(i instanceof InvasionFlag) && !(i instanceof SiegeFlag)) continue;
                        isInvasionCache.put(loc.getChunkLocation(), true);
                        return true;
                    }
                    isInvasionCache.put(loc.getChunkLocation(), false);
                } else if (((Boolean)isInvasionCache.get(loc.getChunkLocation())).booleanValue()) {
                    return true;
                }
            }
            return loc.getChunkLocation().isTownChunk() || AbstractStructure.structures.containsKey(loc);
        });
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        this.handleExplosion(event.blockList());
    }

    @EventHandler
    public void onBlockExplode(BlockExplodeEvent event) {
        this.handleExplosion(event.blockList());
    }

    public static enum AutoClaimingMode {
        CLAIM,
        UNCLAIM,
        TOWN_CLAIM,
        TOWN_UNCLAIM;

    }
}

