/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.manager;

import cn.jason31416.betternations.BetterNations;
import cn.jason31416.betternations.army.ArmorType;
import cn.jason31416.betternations.army.ArmyType;
import cn.jason31416.betternations.item.ItemType;
import cn.jason31416.betternations.structure.PlaceableStructure;
import cn.jason31416.betternations.structure.types.UnitProductionStructure;
import cn.jason31416.planetlib.Config;
import cn.jason31416.planetlib.InvalidConfigurationException;
import cn.jason31416.planetlib.PlanetLib;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class LandArmyManager {
    public static Map<String, ArmyType> directPlacements = new HashMap<String, ArmyType>();

    public static void loadTypes(ConfigurationSection section) {
        for (String i : section.getKeys(false)) {
            ConfigurationSection typeSection = section.getConfigurationSection(i);
            if (typeSection == null) continue;
            ArmyType at = new ArmyType(i, typeSection.getString("name"), ArmorType.valueOf(typeSection.getString("armor", "UNARMED").toUpperCase()), Material.getMaterial((String)typeSection.getString("icon", "STONE").toUpperCase()));
            at.health = typeSection.getDouble("hp") * Config.getDouble("multiplier.army-hp", 1.0);
            at.maxSupply = typeSection.getDouble("supply") * Config.getDouble("multiplier.army-max-supply", 1.0);
            at.consumption = typeSection.getDouble("consume") * Config.getDouble("multiplier.army-supply-consumption", 1.0);
            at.type = typeSection.getString("type");
            ConfigurationSection damages = typeSection.getConfigurationSection("damage");
            if (damages == null) continue;
            for (String j : damages.getKeys(false)) {
                at.attack.put(ArmorType.valueOf(j.toUpperCase()), damages.getDouble(j) * Config.getDouble("multiplier.army-damage", 1.0));
            }
            at.register();
        }
    }

    public static int loadProductions(ConfigurationSection section) {
        int cnt = 0;
        for (String i : section.getKeys(false)) {
            ConfigurationSection prodSection = section.getConfigurationSection(i + ".recipes");
            if (prodSection == null) continue;
            UnitProductionStructure.materialMap.put(i, Objects.requireNonNull(Material.getMaterial((String)section.getString(i + ".material").toUpperCase())));
            PlaceableStructure.registerClass(i, UnitProductionStructure.class);
            HashMap<String, UnitProductionStructure.Recipe> recipeMap = new HashMap<String, UnitProductionStructure.Recipe>();
            for (String j : prodSection.getKeys(false)) {
                if (!ArmyType.armyTypes.containsKey(prodSection.getString(j + ".type", "").toLowerCase())) {
                    throw new InvalidConfigurationException("army.yml", i);
                }
                recipeMap.put(j, new UnitProductionStructure.Recipe(ArmyType.armyTypes.get(prodSection.getString(j + ".type", "").toLowerCase()), (long)(Config.getDouble("multiplier.army-train-speed", 1.0) * (double)prodSection.getLong(j + ".time") * 1000.0)));
                ++cnt;
            }
            UnitProductionStructure.recipes.put(i, recipeMap);
        }
        return cnt;
    }

    public static int loadDirectPlacements(ConfigurationSection section) {
        int cnt = 0;
        for (String i : section.getKeys(false)) {
            if (ItemType.getItemType(i) == null || ItemType.getItemType(i).getMaterial() == Material.AIR || !ArmyType.armyTypes.containsKey(section.getString(i).toLowerCase())) continue;
            directPlacements.put(i, ArmyType.armyTypes.get(section.getString(i).toLowerCase()));
            ++cnt;
        }
        return cnt;
    }

    public static void unregisterAll() {
        ArmyType.armyTypes.clear();
        UnitProductionStructure.recipes.clear();
        directPlacements.clear();
    }

    public static void loadAll() {
        int cnt;
        YamlConfiguration file;
        PlanetLib.instance.getLogger().info("\u001b[34mLoading armies:\u001b[0m");
        try {
            file = YamlConfiguration.loadConfiguration((File)new File(BetterNations.instance.getDataFolder(), "army.yml"));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load armies for BetterNations!");
        }
        if (file.isConfigurationSection("types")) {
            LandArmyManager.loadTypes(Objects.requireNonNull(file.getConfigurationSection("types")));
            BetterNations.instance.getLogger().info("\u001b[36m- Loaded " + Objects.requireNonNull(file.getConfigurationSection("types")).getKeys(false).size() + " types!\u001b[0m");
        }
        if (file.isConfigurationSection("production")) {
            cnt = LandArmyManager.loadProductions(Objects.requireNonNull(file.getConfigurationSection("production")));
            BetterNations.instance.getLogger().info("\u001b[36m- Loaded " + cnt + " production recipes!\u001b[0m");
        }
        if (file.isConfigurationSection("direct-placement")) {
            cnt = LandArmyManager.loadDirectPlacements(Objects.requireNonNull(file.getConfigurationSection("direct-placement")));
            BetterNations.instance.getLogger().info("\u001b[36m- Loaded " + cnt + " direct placement recipes!\u001b[0m");
        }
    }
}

