/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.mob;

import cn.jason31416.betternations.mob.SimpleMob;
import cn.jason31416.planetlib.hook.MythicMobsHook;
import cn.jason31416.planetlib.wrapper.SimpleLocation;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.mobs.ActiveMob;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class MythicMob
implements SimpleMob {
    ActiveMob mob;

    public MythicMob(String name, String type, SimpleLocation location) {
        this.mob = MythicMobsHook.spawnMob(type, location, null);
        if (this.mob == null) {
            throw new IllegalArgumentException("Invalid mob type: " + type);
        }
        this.mob.getEntity().setCustomName(name);
    }

    @Override
    public void teleport(SimpleLocation location) {
        this.mob.getEntity().teleport(BukkitAdapter.adapt((Location)location.getBukkitLocation()));
    }

    @Override
    public SimpleLocation getLocation() {
        return SimpleLocation.of(BukkitAdapter.adapt((AbstractLocation)this.mob.getEntity().getLocation()));
    }

    @Override
    public boolean isAlive() {
        return !this.mob.getEntity().getBukkitEntity().isDead();
    }

    @Override
    public void damage(double hp) {
        this.mob.getEntity().damage((float)hp);
    }

    @Override
    public void setMaxHealth(double hp) {
        this.mob.getEntity().setMaxHealth((double)((float)hp));
    }

    @Override
    public void setHealth(double hp) {
        this.mob.getEntity().setHealth(hp);
        this.mob.getEntity().setMaxHealth(hp);
    }

    @Override
    public void setTarget(LivingEntity target) {
        this.mob.setTarget(BukkitAdapter.adapt((Entity)target));
    }

    @Override
    public Entity getBukkitEntity() {
        return this.mob.getEntity().getBukkitEntity();
    }

    @Override
    public void remove() {
        this.mob.remove();
    }

    @Override
    public void setName(String name) {
        this.mob.getEntity().setCustomName(name);
    }
}

