/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.nation.resolution;

import cn.jason31416.betternations.nation.Nation;
import cn.jason31416.betternations.nation.NationalRank;
import cn.jason31416.betternations.nation.resolution.PlayerResolution;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.wrapper.SimplePlayer;
import javax.annotation.Nonnull;

public class PlayerRankResolution
extends PlayerResolution {
    public NationalRank rank;

    public PlayerRankResolution(Nation nation, SimplePlayer proposer, SimplePlayer target, NationalRank rank) {
        super(nation, proposer, target);
        this.rank = rank;
    }

    @Override
    public int importance() {
        if (this.rank == this.nation.getType().getOwnerRank()) {
            return 5;
        }
        if (this.nation.getRank(this.target).weight() >= 500 || this.rank.weight() >= 500) {
            return 3;
        }
        return 2;
    }

    @Override
    public void execute() {
        if (this.target.getNation() != this.nation) {
            return;
        }
        if (!this.nation.getType().allRanks.contains(this.rank)) {
            return;
        }
        if (this.target.getRank() == this.nation.getType().getOwnerRank()) {
            return;
        }
        if (this.rank == this.nation.getType().getOwnerRank()) {
            this.nation.setRank(this.nation.getOwner(), this.nation.getType().getDefaultRank());
            this.nation.setOwner(this.target);
        }
        this.nation.setRank(this.target, this.rank);
    }

    @Override
    @Nonnull
    public Message getResolutionContent() {
        return Message.getMessage("nation.resolution.description.set-rank").add("target", this.target.getName()).add("rank", this.rank.getDisplayName());
    }
}

