/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.nation.treaty;

import cn.jason31416.betternations.nation.Nation;
import cn.jason31416.betternations.nation.treaty.Term;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.message.MessageLoader;
import cn.jason31416.planetlib.message.StringMessage;
import cn.jason31416.planetlib.wrapper.SimplePlayer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class Treaty {
    public static Map<String, Treaty> treatyMap = new HashMap<String, Treaty>();
    public String name;
    public SimplePlayer proposer;
    public UUID id;
    public List<Term> terms = new ArrayList<Term>();
    public Set<Nation> signed = new HashSet<Nation>();
    public TreatyState state = TreatyState.EDITING;

    public Treaty(String name, SimplePlayer proposer) {
        this.name = name;
        this.proposer = proposer;
        this.id = UUID.randomUUID();
        treatyMap.put(name, this);
    }

    public void display(SimplePlayer player) {
        MessageLoader.getList("treaty.display.header").add("treaty", this.name).send(player);
        int cnt = 1;
        for (Term i : this.terms) {
            if (this.state == TreatyState.EDITING && this.proposer.equals(player)) {
                Message.getMessage("treaty.display.editing-term").add("id", cnt++).add("content", i.getDescription()).add("treaty", this.name).send(player);
                continue;
            }
            if (!i.check(this)) {
                Message.getMessage("treaty.display.cannot-execute-term").add("id", cnt++).add("content", i.getDescription()).send(player);
                continue;
            }
            if (i.from == player.getNation() || i.target == player.getNation()) {
                Message.getMessage("treaty.display.affected-term").add("id", cnt++).add("content", i.getDescription()).send(player);
                continue;
            }
            Message.getMessage("treaty.display.normal-term").add("id", cnt++).add("content", i.getDescription()).send(player);
        }
        new StringMessage("").send(player);
        if (this.state == TreatyState.PROPOSED) {
            Message.getMessage("treaty.display.status-pending").send(player);
        } else if (this.state == TreatyState.EDITING) {
            Message.getMessage("treaty.display.status-editing").send(player);
        } else if (this.state == TreatyState.ACTIVE) {
            Message.getMessage("treaty.display.status-active").send(player);
        }
        if (this.state == TreatyState.PROPOSED) {
            Set<Nation> affected = this.getAffected();
            MessageLoader.getList("treaty.display.footer-proposed").add("proposer", this.proposer.getName()).add("signed", String.join((CharSequence)", ", this.signed.stream().map(Nation::getName).toList())).add("waiting", String.join((CharSequence)", ", affected.stream().filter(n -> !this.signed.contains(n)).map(Nation::getName).toList())).send(player);
            if (affected.contains(player.getNation())) {
                new StringMessage("").send(player);
                Object s = "";
                s = this.signed.contains(player.getNation()) ? (String)s + Message.getMessage("treaty.display.signed-button").toFormatted() : (String)s + Message.getMessage("treaty.display.sign-button").add("treaty", this.name).toFormatted();
                s = (String)s + Message.getMessage("treaty.display.veto-button").add("treaty", this.name).toFormatted();
                player.sendMessage(new StringMessage((String)s));
            }
        } else if (this.state == TreatyState.EDITING && (this.proposer.equals(player) || player.getPlayer().isOp())) {
            new StringMessage("").send(player);
            Message.getMessage("treaty.display.add-term-button").add("treaty", this.name).send(player);
            Message.getMessage("treaty.display.submit-button").add("treaty", this.name).send(player);
            Message.getMessage("treaty.display.delete-button").add("treaty", this.name).send(player);
        }
    }

    public Set<Nation> getAffected() {
        HashSet<Nation> ret = new HashSet<Nation>();
        for (Term i : this.terms) {
            ret.add(i.from);
            ret.add(i.target);
        }
        return ret;
    }

    public void submit() {
        this.state = TreatyState.PROPOSED;
        Message.getMessage("treaty.submitted").add("id", this.id.toString()).add("proposer", this.proposer.getName()).add("treaty", this.name).broadcast();
    }

    public int sign(Nation nation) {
        if (!this.getAffected().contains(nation) || this.signed.contains(nation) || this.state != TreatyState.PROPOSED) {
            return 0;
        }
        this.signed.add(nation);
        Message.getMessage("treaty.signed").add("nation", nation.getName()).add("id", this.id.toString()).add("treaty", this.name).broadcast();
        if (this.getAffected().size() == this.signed.size()) {
            for (Term i : this.terms) {
                if (i.check(this)) continue;
                this.signed.remove(nation);
                return -1;
            }
            for (Term i : this.terms) {
                i.execute();
            }
            this.state = TreatyState.ACTIVE;
            Message.getMessage("treaty.activated").add("id", this.id.toString()).add("treaty", this.name).broadcast();
        }
        return 1;
    }

    public boolean veto(Nation nation) {
        if (!this.getAffected().contains(nation) || this.state != TreatyState.PROPOSED) {
            return false;
        }
        this.signed.clear();
        this.state = TreatyState.EDITING;
        Message.getMessage("treaty.vetoed").add("nation", nation.getName()).add("id", this.id.toString()).add("name", this.name).broadcast();
        return true;
    }

    public static enum TreatyState {
        EDITING,
        PROPOSED,
        ACTIVE;

    }
}

