/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.structure;

import cn.jason31416.betternations.BetterNations;
import cn.jason31416.betternations.army.states.ArmyCamp;
import cn.jason31416.betternations.army.states.InvasionFlag;
import cn.jason31416.betternations.army.states.SiegeFlag;
import cn.jason31416.betternations.structure.Hologram;
import cn.jason31416.betternations.structure.types.TownCore;
import cn.jason31416.betternations.structure.types.TownRuin;
import cn.jason31416.planetlib.data.IDataItem;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.wrapper.SimpleLocation;
import cn.jason31416.planetlib.wrapper.SimplePlayer;
import cn.jason31416.planetlib.wrapper.SimpleWorld;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class AbstractStructure {
    public static final Map<SimpleLocation, AbstractStructure> structures = new HashMap<SimpleLocation, AbstractStructure>();
    public static final Map<String, Class<? extends AbstractStructure>> structureTypes = new HashMap<String, Class<? extends AbstractStructure>>();
    public SimpleLocation location;
    public UUID uuid = UUID.randomUUID();
    public boolean exists = false;
    public Hologram hologram = null;

    public abstract Material getMaterial();

    public abstract boolean serialize(IDataItem var1);

    public abstract void deserialize(IDataItem var1);

    public String getHologramText() {
        return Message.getMessage("structure." + this.getID() + ".hologram").toString();
    }

    public String getID() {
        return this.getClass().getSimpleName().toLowerCase(Locale.ROOT);
    }

    public void place() {
        this.location.setBlockMaterial(this.getMaterial());
        this.hologram = Hologram.createHologram(SimpleLocation.of(this.location.getBlock().getLocation().add(0.5, 1.3, 0.5)), this.getHologramText());
        this.register();
        this.exists = true;
    }

    public void register() {
        structures.put(this.location, this);
    }

    public void unregister() {
        structures.remove(this.location);
    }

    public static boolean pack(IDataItem dataItem, AbstractStructure structure) {
        String structureType = structure.getID();
        boolean success = structure.serialize(dataItem);
        dataItem.put("structureType", structureType);
        dataItem.put("location", structure.location.x() + "_" + structure.location.y() + "_" + structure.location.z() + "_" + structure.location.world().getBukkitWorld().getUID().toString());
        dataItem.setUUID(structure.uuid);
        return success;
    }

    public void updateHologram() {
        this.hologram.setText(this.getHologramText());
    }

    public void breakStructure() {
        if (Bukkit.isPrimaryThread()) {
            this.hologram.removeHologram();
            this.location.setBlockMaterial(Material.AIR);
        } else {
            new BukkitRunnable(){

                public void run() {
                    AbstractStructure.this.hologram.removeHologram();
                    AbstractStructure.this.location.setBlockMaterial(Material.AIR);
                }
            }.runTaskLater((Plugin)BetterNations.instance, 0L);
        }
        this.exists = false;
    }

    public static AbstractStructure unpack(IDataItem dataItem) {
        AbstractStructure structure;
        String structureType = dataItem.getString("structureType");
        Class<? extends AbstractStructure> structureClass = structureTypes.get(structureType);
        if (structureClass == null) {
            throw new IllegalArgumentException("Unknown structure type: " + structureType);
        }
        try {
            structure = structureClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        structure.uuid = dataItem.getUUID();
        String[] locationStr = dataItem.getString("location").split("_");
        structure.location = new SimpleLocation(Double.parseDouble(locationStr[0]), Double.parseDouble(locationStr[1]), Double.parseDouble(locationStr[2]), SimpleWorld.of(UUID.fromString(locationStr[3]))).getBlockLocation();
        structure.deserialize(dataItem);
        structure.place();
        return structure;
    }

    public abstract boolean processInteraction(InteractionType var1, SimplePlayer var2);

    public static void registerStructureType(Class<? extends AbstractStructure> structureClass) {
        structureTypes.put(structureClass.getSimpleName().toLowerCase(), structureClass);
    }

    public static void registerAllStructures() {
        AbstractStructure.registerStructureType(TownCore.class);
        AbstractStructure.registerStructureType(ArmyCamp.class);
        AbstractStructure.registerStructureType(InvasionFlag.class);
        AbstractStructure.registerStructureType(SiegeFlag.class);
        AbstractStructure.registerStructureType(TownRuin.class);
    }

    public static enum InteractionType {
        NONE,
        INTERACT,
        BREAK,
        SNEAK_CLICK;

    }
}

