/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.structure;

import cn.jason31416.betternations.item.ItemType;
import cn.jason31416.betternations.structure.AbstractStructure;
import cn.jason31416.betternations.structure.types.Extractor;
import cn.jason31416.betternations.structure.types.Granary;
import cn.jason31416.betternations.structure.types.Outpost;
import java.util.HashMap;
import java.util.Map;

public abstract class PlaceableStructure
extends AbstractStructure {
    public static Map<String, Class<? extends PlaceableStructure>> placeableStructures = new HashMap<String, Class<? extends PlaceableStructure>>();
    public static Map<Class<? extends PlaceableStructure>, ItemType> structureMap = new HashMap<Class<? extends PlaceableStructure>, ItemType>();

    public static void registerClass(String id, Class<? extends PlaceableStructure> clazz) {
        placeableStructures.put(id, clazz);
        structureMap.put(clazz, ItemType.getItemType(id));
        AbstractStructure.registerStructureType(clazz);
    }

    @Override
    public void breakStructure() {
        super.breakStructure();
        if (this.location.getBukkitLocation().getWorld() == null) {
            return;
        }
        this.location.getBukkitLocation().getWorld().dropItem(this.location.getBukkitLocation(), structureMap.get(this.getClass()).getItemStack());
    }

    public static void registerAll() {
        PlaceableStructure.registerClass("granary", Granary.class);
        PlaceableStructure.registerClass("outpost", Outpost.class);
        PlaceableStructure.registerClass("extractor", Extractor.class);
    }
}

