/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.structure.types;

import cn.jason31416.betternations.item.ItemType;
import cn.jason31416.betternations.manager.NaturalResourcesManager;
import cn.jason31416.betternations.nation.Permission;
import cn.jason31416.betternations.structure.AbstractStructure;
import cn.jason31416.betternations.structure.PlaceableStructure;
import cn.jason31416.planetlib.data.IDataItem;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.wrapper.SimpleChunkLocation;
import cn.jason31416.planetlib.wrapper.SimplePlayer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class Extractor
extends PlaceableStructure {
    public static Map<SimpleChunkLocation, Extractor> extractors = new HashMap<SimpleChunkLocation, Extractor>();
    public int produced = 0;

    @Override
    public void register() {
        super.register();
        extractors.put(this.location.getChunkLocation(), this);
    }

    @Override
    public void unregister() {
        super.unregister();
        extractors.remove(this.location.getChunkLocation());
    }

    @Override
    public String getHologramText() {
        String name = "";
        if (this.getItemType() != null) {
            name = Objects.requireNonNull(this.getItemType().getItemStack().getItemMeta()).getDisplayName();
        }
        return Message.getMessage("structure.extractor.hologram").add("current", this.produced).add("item", name.replaceAll("\u00a7.", "")).toString();
    }

    @Override
    public Material getMaterial() {
        return Material.IRON_BLOCK;
    }

    @Override
    public boolean serialize(IDataItem dataItem) {
        dataItem.set("produced", this.produced);
        return true;
    }

    @Override
    public void deserialize(IDataItem dataItem) {
        if (dataItem.getInteger("produced") != null) {
            this.produced = dataItem.getInteger("produced");
        }
    }

    @Override
    public boolean processInteraction(AbstractStructure.InteractionType type, SimplePlayer player) {
        if (NaturalResourcesManager.naturalResourcesMap.containsKey(this.location.getChunkLocation()) && type == AbstractStructure.InteractionType.INTERACT && player.hasPermission(Permission.STRUCTURE, this.location) && this.produced > 0 && player.getPlayer().getInventory().firstEmpty() >= 0) {
            player.getPlayer().getInventory().addItem(new ItemStack[]{this.getItemType().getItemStack(this.produced)});
            this.produced = 0;
            this.updateHologram();
        }
        return player.hasPermission(Permission.STRUCTURE, this.location);
    }

    public ItemType getItemType() {
        return NaturalResourcesManager.naturalResourcesMap.get(this.location.getChunkLocation());
    }

    @Override
    public void breakStructure() {
        super.breakStructure();
        if (this.produced > 0) {
            this.location.world().getBukkitWorld().dropItem(this.location.getBukkitLocation().add(0.5, 0.5, 0.5), this.getItemType().getItemStack(this.produced));
        }
    }

    public static void tickAll() {
        for (SimpleChunkLocation location : extractors.keySet()) {
            if (!NaturalResourcesManager.naturalResourcesMap.containsKey(location)) continue;
            Extractor extractor = extractors.get(location);
            extractor.produced = Math.min(extractor.produced + 1, NaturalResourcesManager.naturalResourcesMap.get(location).getMaterial().getMaxStackSize());
            extractor.updateHologram();
        }
    }
}

