/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.structure.types;

import cn.jason31416.betternations.BetterNations;
import cn.jason31416.betternations.army.states.StructuredArmy;
import cn.jason31416.betternations.item.ItemType;
import cn.jason31416.betternations.manager.FromToAnimationManager;
import cn.jason31416.betternations.nation.Permission;
import cn.jason31416.betternations.nation.Relation;
import cn.jason31416.betternations.structure.AbstractStructure;
import cn.jason31416.betternations.structure.PlaceableStructure;
import cn.jason31416.planetlib.Config;
import cn.jason31416.planetlib.data.IDataItem;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.wrapper.SimpleChunkLocation;
import cn.jason31416.planetlib.wrapper.SimplePlayer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;

public class Granary
extends PlaceableStructure {
    public static Map<SimpleChunkLocation, Set<Granary>> granaries = new HashMap<SimpleChunkLocation, Set<Granary>>();
    public static Map<ItemType, Double> supplyWorth = new HashMap<ItemType, Double>();
    public double supply = 0.0;

    public static void loadSupplyWorth() {
        ConfigurationSection section = BetterNations.instance.getConfig().getConfigurationSection("supply");
        if (section == null) {
            return;
        }
        for (String i : section.getKeys(false)) {
            try {
                ItemType tp = ItemType.getItemType(i.toUpperCase());
                supplyWorth.put(tp, section.getDouble(i) * Config.getDouble("multiplier.food-supply-conversion", 1.0));
            }
            catch (RuntimeException e) {
                Bukkit.getLogger().warning(i + " in BetterNations config is not a valid item!");
            }
        }
    }

    @Override
    public void register() {
        super.register();
        if (!granaries.containsKey(this.location.getChunkLocation())) {
            granaries.put(this.location.getChunkLocation(), new HashSet());
        }
        granaries.get(this.location.getChunkLocation()).add(this);
        if (StructuredArmy.armyLocationMap.containsKey(this.location.getChunkLocation())) {
            for (StructuredArmy i : StructuredArmy.armyLocationMap.get(this.location.getChunkLocation())) {
                if (i.stack.nation.getRelation(this.location.getChunkLocation().getNation()) != Relation.ALLY) continue;
                new FromToAnimationManager(this, i, Color.YELLOW);
            }
        }
    }

    @Override
    public void unregister() {
        super.unregister();
        if (granaries.containsKey(this.location.getChunkLocation())) {
            granaries.get(this.location.getChunkLocation()).remove(this);
            if (granaries.get(this.location.getChunkLocation()).isEmpty()) {
                granaries.remove(this.location.getChunkLocation());
            }
        }
    }

    @Override
    public Material getMaterial() {
        return Material.HAY_BLOCK;
    }

    @Override
    public String getHologramText() {
        return Message.getMessage("structure.granary.hologram").add("supply", (double)Math.round(this.supply * 100.0) / 100.0).add("max_supply", Config.getDouble("combat.granary-supply-limit")).toString();
    }

    @Override
    public boolean serialize(IDataItem dataItem) {
        dataItem.set("supply", this.supply);
        return true;
    }

    @Override
    public void deserialize(IDataItem dataItem) {
        this.supply = dataItem.getDouble("supply");
    }

    @Override
    public boolean processInteraction(AbstractStructure.InteractionType type, SimplePlayer player) {
        if (!player.hasPermission(Permission.STRUCTURE, this.location)) {
            return false;
        }
        if (type == AbstractStructure.InteractionType.INTERACT) {
            if (!this.location.getChunkLocation().isTownChunk()) {
                return false;
            }
            ItemType mainHandItem = ItemType.getItemType(player.getPlayer().getInventory().getItemInMainHand());
            if (supplyWorth.containsKey(mainHandItem)) {
                if (this.supply + supplyWorth.get(mainHandItem) < Config.getDouble("combat.granary-supply-limit")) {
                    this.supply += supplyWorth.get(mainHandItem).doubleValue();
                    player.getPlayer().getInventory().getItemInMainHand().setAmount(Math.max(0, player.getPlayer().getInventory().getItemInMainHand().getAmount() - 1));
                    this.updateHologram();
                }
            } else {
                Message.getMessage("combat.item-not-edible").send(player);
            }
        }
        return true;
    }
}

