/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.planetlib.command;

import cn.jason31416.betternations.nation.Nation;
import cn.jason31416.planetlib.wrapper.SimplePlayer;

public enum ParameterType {
    STRING(input -> input, "<String>"),
    INTEGER(input -> {
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }, "<Integer>"),
    DOUBLE(input -> {
        try {
            return Double.parseDouble(input);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }, "<Number>"),
    PLAYER(SimplePlayer::of, "<Player>"),
    NATION(Nation::getNation, "<Nation>");

    public final ParameterChecker checker;
    public final String usage;

    private ParameterType(ParameterChecker checker, String usage) {
        this.checker = checker;
        this.usage = usage;
    }

    public String getUsage() {
        return this.usage;
    }

    public Object handle(String input) {
        return this.checker.handle(input);
    }

    public static interface ParameterChecker {
        public Object handle(String var1);
    }
}

