/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.planetlib.command;

import cn.jason31416.planetlib.command.ICommand;
import cn.jason31416.planetlib.command.ICommandContext;
import cn.jason31416.planetlib.command.IParentCommand;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.message.StaticMessages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class ParentCommand
implements ICommand,
IParentCommand {
    public final Map<String, ICommand> subCommands = new HashMap<String, ICommand>();

    public ParentCommand(String name, IParentCommand parent) {
        parent.registerSubCommand(name, this);
    }

    public ParentCommand(List<String> names, IParentCommand parent) {
        for (String name : names) {
            parent.registerSubCommand(name, this);
        }
    }

    @Override
    @Nullable
    public Message execute(ICommandContext context) {
        if (!context.args().isEmpty()) {
            if (this.subCommands.containsKey(context.getArg(0))) {
                return this.subCommands.get(context.getArg(0)).execute(context.getSubContext());
            }
            return StaticMessages.UNKNOWN_COMMAND;
        }
        return this.executeRaw(context);
    }

    @Override
    public List<String> tabComplete(ICommandContext context) {
        if (context.args().size() == 1) {
            ArrayList<String> result = new ArrayList<String>();
            for (String key : this.subCommands.keySet()) {
                if (!key.startsWith(context.getArg(0))) continue;
                result.add(key);
            }
            return result;
        }
        if (this.subCommands.containsKey(context.getArg(0))) {
            ICommand subCommand = this.subCommands.get(context.getArg(0));
            return subCommand.tabComplete(context.getSubContext());
        }
        return null;
    }

    @Override
    public void registerSubCommand(String name, ICommand command) {
        this.subCommands.put(name, command);
    }

    @Nullable
    public abstract Message executeRaw(ICommandContext var1);
}

