/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.planetlib.gui;

import cn.jason31416.betternations.item.CustomItemType;
import cn.jason31416.betternations.item.ItemType;
import cn.jason31416.planetlib.gui.GUISession;
import cn.jason31416.planetlib.hook.NbtHook;
import cn.jason31416.planetlib.message.StringMessage;
import cn.jason31416.planetlib.wrapper.SimplePlayer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;

public class GUI {
    public Map<Integer, Item> container = new HashMap<Integer, Item>();
    public int size;
    public Set<Integer> inputs = new HashSet<Integer>();
    public String title;
    public Inventory lstInventory;

    public Item getItem(int slot) {
        return this.container.get(slot);
    }

    public ItemGroup getItems(String id) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (Item item : this.container.values()) {
            if (!item.id.equals(id)) continue;
            items.add(item);
        }
        return new ItemGroup(items);
    }

    public GUI placeholder(String placeholder, String value) {
        for (Item item : this.container.values()) {
            item.placeholder(placeholder, value);
        }
        this.title = this.title.replace("%" + placeholder + "%", value);
        return this;
    }

    public Item addItem(String id, int slot) {
        Item item = new Item(id);
        item.setSlot(slot);
        this.container.put(slot, item);
        return item;
    }

    public Item addItem(String id, String name, int slot, Material material, int quantity) {
        Item item = new Item(id);
        item.setName(name);
        item.setMaterial(material);
        item.setQuantity(quantity);
        item.setSlot(slot);
        this.container.put(slot, item);
        return item;
    }

    public Item addItem(String id, int slot, ItemStack itemStack) {
        Item item = new Item(id);
        item.setItemStack(itemStack);
        item.setSlot(slot);
        this.container.put(slot, item);
        return item;
    }

    public List<Item> addItem(String id, String name, List<Integer> slots, Material material, int quantity) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (int i : slots) {
            Item item = new Item(id);
            item.setName(name);
            item.setMaterial(material);
            item.setQuantity(quantity);
            item.setSlot(i);
            this.container.put(i, item);
        }
        return items;
    }

    public void removeItem(int slot) {
        this.container.remove(slot);
    }

    protected ItemStack putNbt(Item item) {
        ItemStack itemStack = item.toBukkitItem();
        NbtHook.setTag(itemStack, "bn.guiItem", item.id);
        return itemStack;
    }

    public void handleClick(int slot, GUISession session, InventoryAction action, InventoryClickEvent event) {
        Item item = this.container.get(slot);
        if (item != null && item.clickHandler != null) {
            item.clickHandler.run(session, action, event);
        }
    }

    public void display(SimplePlayer player) {
        Inventory inv;
        this.lstInventory = inv = Bukkit.createInventory(null, (int)this.size, (String)new StringMessage(this.title).toString());
        for (Item item : this.container.values()) {
            inv.setItem(item.slot, this.putNbt(item));
        }
        player.getPlayer().openInventory(inv);
    }

    public void update() {
        if (this.lstInventory != null) {
            this.lstInventory.clear();
            for (Item item : this.container.values()) {
                this.lstInventory.setItem(item.slot, this.putNbt(item));
            }
        }
    }

    public GUI copy() {
        GUI gui = new GUI();
        gui.size = this.size;
        gui.title = this.title;
        gui.inputs = this.inputs;
        for (int key : this.container.keySet()) {
            gui.container.put(key, this.container.get(key).copy());
        }
        return gui;
    }

    public static class Item {
        public String name = "";
        public String id;
        public int quantity = 1;
        public int slot = 0;
        public boolean glow = false;
        public Map<Enchantment, Integer> enchantments = null;
        public int customModelData = -1;
        public Material material = Material.AIR;
        public List<String> lore = new ArrayList<String>();
        public String skullId = null;
        public ItemStack stack = null;
        public GUIRunnable clickHandler = null;

        public Item(String id) {
            this.id = id;
        }

        public Item setMaterial(Material material) {
            this.material = material;
            return this;
        }

        public Item setItemStack(ItemStack stack) {
            ItemType itemType = ItemType.getItemType(stack);
            if (itemType instanceof CustomItemType) {
                CustomItemType c = (CustomItemType)itemType;
                this.skullId = c.skullValue;
            }
            this.material = stack.getType();
            this.quantity = stack.getAmount();
            ItemMeta meta = stack.getItemMeta();
            if (meta == null) {
                return this;
            }
            this.name = meta.getDisplayName();
            this.lore = meta.getLore();
            if (meta.getEnchants().size() == 1 && meta.getEnchants().getOrDefault(Enchantment.DURABILITY, 0) == 1) {
                this.glow = true;
            } else if (meta.hasEnchants()) {
                this.enchantments = new HashMap<Enchantment, Integer>(meta.getEnchants());
            }
            if (meta.hasCustomModelData()) {
                this.customModelData = meta.getCustomModelData();
            }
            return this;
        }

        public void setAsVanillaItemStack(ItemStack stack) {
            this.stack = stack;
        }

        public Item setName(String name) {
            this.name = name;
            return this;
        }

        public Item setQuantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        public Item setLore(List<String> lore) {
            this.lore = lore;
            return this;
        }

        public Item setSlot(int slot) {
            this.slot = slot;
            return this;
        }

        public Item removeLoreLine(int lineId) {
            if (this.lore.size() > lineId) {
                this.lore.remove(lineId);
            }
            return this;
        }

        public Item setGlow(boolean glow) {
            this.glow = glow;
            return this;
        }

        public Item setCustomModelData(int data) {
            this.customModelData = data;
            return this;
        }

        public Item setSkullID(String skullID) {
            this.skullId = skullID;
            return this;
        }

        public Item setClickHandler(GUIRunnable clickHandler) {
            this.clickHandler = clickHandler;
            return this;
        }

        public Item placeholder(String placeholder, String value) {
            this.name = this.name.replace("%" + placeholder + "%", value);
            if (this.lore != null) {
                this.lore.replaceAll(s -> s.replace("%" + placeholder + "%", value));
            }
            return this;
        }

        public ItemStack toBukkitItem() {
            if (this.stack != null) {
                return this.stack.clone();
            }
            ItemStack item = new ItemStack(this.material, this.quantity);
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(this.name);
                meta.setLore(this.lore);
                if (this.glow) {
                    meta.addEnchant(Enchantment.DURABILITY, 1, true);
                    meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                } else if (this.enchantments != null) {
                    for (Enchantment i : this.enchantments.keySet()) {
                        meta.addEnchant(i, this.enchantments.get(i).intValue(), true);
                    }
                }
                if (this.customModelData != -1) {
                    meta.setCustomModelData(Integer.valueOf(this.customModelData));
                }
                if (meta instanceof SkullMeta) {
                    SkullMeta mt = (SkullMeta)meta;
                    if (this.skullId != null) {
                        try {
                            PlayerProfile profile = Bukkit.getServer().createPlayerProfile(UUID.randomUUID());
                            PlayerTextures textures = profile.getTextures();
                            textures.setSkin(new URL("https://textures.minecraft.net/texture/" + this.skullId));
                            profile.setTextures(textures);
                            mt.setOwnerProfile(profile);
                        }
                        catch (MalformedURLException ignored) {
                            throw new RuntimeException(ignored);
                        }
                    }
                }
                item.setItemMeta(meta);
            }
            return item;
        }

        public Item copy() {
            Item item = new Item(this.id);
            item.name = this.name;
            item.quantity = this.quantity;
            item.material = this.material;
            item.lore = new ArrayList<String>(this.lore);
            item.slot = this.slot;
            item.customModelData = this.customModelData;
            item.skullId = this.skullId;
            item.glow = this.glow;
            if (this.enchantments != null) {
                item.enchantments = new HashMap<Enchantment, Integer>(this.enchantments);
            }
            return item;
        }
    }

    public static class ItemGroup {
        public List<Item> items = new ArrayList<Item>();

        public ItemGroup(List<Item> items) {
            this.items = items;
        }

        @Deprecated
        public void setAsVanillaItemStack(ItemStack stack) {
            for (Item item : this.items) {
                item.setAsVanillaItemStack(stack);
            }
        }

        public ItemGroup setSkullID(String skullID) {
            for (Item item : this.items) {
                item.setSkullID(skullID);
            }
            return this;
        }

        public ItemGroup setItemStack(ItemStack stack) {
            for (Item item : this.items) {
                item.setItemStack(stack);
            }
            return this;
        }

        public ItemGroup setName(String name) {
            for (Item item : this.items) {
                item.setName(name);
            }
            return this;
        }

        public ItemGroup setMaterial(Material material) {
            for (Item item : this.items) {
                item.setMaterial(material);
            }
            return this;
        }

        public ItemGroup setQuantity(int quantity) {
            for (Item item : this.items) {
                item.setQuantity(quantity);
            }
            return this;
        }

        public ItemGroup setGlow(boolean glow) {
            for (Item item : this.items) {
                item.setGlow(glow);
            }
            return this;
        }

        public ItemGroup setLore(List<String> lore) {
            for (Item item : this.items) {
                item.setLore(lore);
            }
            return this;
        }

        public ItemGroup removeLoreLine(int lineId) {
            for (Item item : this.items) {
                item.removeLoreLine(lineId);
            }
            return this;
        }

        public ItemGroup setClickHandler(GUIRunnable clickHandler) {
            for (Item item : this.items) {
                item.setClickHandler(clickHandler);
            }
            return this;
        }

        public ItemStack toBukkitItem() {
            if (this.items.isEmpty()) {
                return null;
            }
            return this.items.get(0).toBukkitItem();
        }

        public ItemGroup placeholder(String placeholder, String value) {
            for (Item item : this.items) {
                item.placeholder(placeholder, value);
            }
            return this;
        }
    }

    public static interface GUIRunnable {
        public void run(GUISession var1, InventoryAction var2, InventoryClickEvent var3);
    }

    public static class CloseGuiRunnable
    implements GUIRunnable {
        @Override
        public void run(GUISession session, InventoryAction action, InventoryClickEvent event) {
            session.close();
        }
    }

    public static class SwitchGuiRunnable
    implements GUIRunnable {
        public String guiName;

        public SwitchGuiRunnable(String guiName) {
            this.guiName = guiName;
        }

        @Override
        public void run(GUISession session, InventoryAction action, InventoryClickEvent event) {
            session.display(this.guiName);
        }
    }

    public static class CommandRunnable
    implements GUIRunnable {
        public String command;

        public CommandRunnable(String command) {
            this.command = command;
        }

        @Override
        public void run(GUISession session, InventoryAction action, InventoryClickEvent event) {
            Bukkit.dispatchCommand((CommandSender)session.player.getPlayer(), (String)this.command);
        }
    }
}

