/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.planetlib.hook;

import cn.jason31416.planetlib.PlanetLib;
import cn.jason31416.planetlib.wrapper.SimpleLocation;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.util.Collection;
import java.util.Collections;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.jetbrains.annotations.Nullable;

public class MythicMobsHook {
    public static boolean enabled = false;

    public static void init() {
        if (Bukkit.getPluginManager().getPlugin("MythicMobs") == null) {
            PlanetLib.instance.getLogger().info("\u001b[31mFailed to hook MythicMobs\u001b[0m");
            enabled = false;
            return;
        }
        PlanetLib.instance.getLogger().info("\u001b[32mHook MythicMobs successfully\u001b[0m");
        enabled = true;
    }

    @Nullable
    public static ActiveMob spawnMob(String mobName, SimpleLocation position, @Nullable Integer level) {
        if (level == null) {
            level = 1;
        }
        if (!enabled) {
            return null;
        }
        try (MythicBukkit mythicBukkit = MythicBukkit.inst();){
            MythicMob mob = mythicBukkit.getMobManager().getMythicMob(mobName).orElse(null);
            if (mob != null) {
                ActiveMob activeMob = mob.spawn(BukkitAdapter.adapt((Location)position.getBukkitLocation()), (double)level.intValue());
                return activeMob;
            }
            PlanetLib.instance.getLogger().severe("ERROR: Unable to find mob: " + mobName + "!");
        }
        return null;
    }

    public static Collection<String> loadedMobTypes() {
        if (!enabled) {
            return Collections.emptySet();
        }
        try (MythicBukkit mythicBukkit = MythicBukkit.inst();){
            Collection collection = mythicBukkit.getMobManager().getMobNames();
            return collection;
        }
    }
}

