/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.planetlib.wrapper;

import cn.jason31416.betternations.army.states.InvasionFlag;
import cn.jason31416.betternations.army.states.SiegeFlag;
import cn.jason31416.betternations.army.states.StructuredArmy;
import cn.jason31416.betternations.nation.Nation;
import cn.jason31416.betternations.nation.NationalRank;
import cn.jason31416.betternations.nation.Permission;
import cn.jason31416.betternations.nation.Relation;
import cn.jason31416.planetlib.Config;
import cn.jason31416.planetlib.hook.VaultHook;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.wrapper.SimpleLocation;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public record SimplePlayer(OfflinePlayer offlinePlayer) implements ConfigurationSerializable
{
    public String getName() {
        return this.offlinePlayer.getName();
    }

    public UUID getUUID() {
        return this.offlinePlayer.getUniqueId();
    }

    public boolean isOnline() {
        return this.offlinePlayer.isOnline();
    }

    public SimpleLocation getLocation() {
        if (!this.isOnline()) {
            throw new IllegalStateException("Player is not online");
        }
        return SimpleLocation.of(this.getPlayer().getLocation());
    }

    public Player getPlayer() {
        if (!this.isOnline()) {
            throw new IllegalStateException("Player is not online");
        }
        return this.offlinePlayer.getPlayer();
    }

    public boolean hasPermission(Permission p) {
        return this.getRank().hasPermission(p);
    }

    public boolean hasPermission(Permission p, SimpleLocation location) {
        if ((p == Permission.STRUCTURE || p == Permission.BUILD) && this.offlinePlayer.isOp()) {
            return true;
        }
        if ((p == Permission.STRUCTURE || p == Permission.BUILD) && StructuredArmy.armyLocationMap.containsKey(location.getChunkLocation())) {
            for (StructuredArmy i : StructuredArmy.armyLocationMap.get(location.getChunkLocation())) {
                if (!(i instanceof InvasionFlag) && !(i instanceof SiegeFlag)) continue;
                return false;
            }
        }
        if (location.getChunkLocation().getNation() == null) {
            return true;
        }
        if (location.getChunkLocation().getTown() != null) {
            return location.getChunkLocation().getTown().getRole(this).hasPermission(p);
        }
        return this.getRank().hasPermission(p) && location.getChunkLocation().getNation().getRelation(this.getNation()) == Relation.ALLY;
    }

    public void sendMessage(Message message) {
        if (!this.isOnline()) {
            return;
        }
        message.send((CommandSender)this.getPlayer());
    }

    public void sendTitle(String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        if (!this.isOnline()) {
            return;
        }
        this.getPlayer().sendTitle(title, subtitle, fadeIn, stay, fadeOut);
    }

    @Nullable
    public Nation getNation() {
        return Nation.playerNationMap.get(this);
    }

    public NationalRank getRank() {
        if (this.getNation() == null) {
            return NationalRank.NONE;
        }
        return this.getNation().getRank(this);
    }

    public double getBalance() {
        return VaultHook.getBalance(this.offlinePlayer);
    }

    public void addBalance(double amount) {
        VaultHook.depositBalance(this.offlinePlayer, amount * Config.getDouble("multiplier.global-cost", 1.0));
    }

    public boolean withdrawBalance(double amount) {
        return VaultHook.withdrawBalance(this.offlinePlayer, amount * Config.getDouble("multiplier.global-cost", 1.0));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SimplePlayer)) {
            return false;
        }
        SimplePlayer other = (SimplePlayer)obj;
        return this.offlinePlayer.getUniqueId().equals(other.offlinePlayer.getUniqueId());
    }

    @Override
    public int hashCode() {
        return this.offlinePlayer.getUniqueId().hashCode();
    }

    public static SimplePlayer of(OfflinePlayer offlinePlayer) {
        return new SimplePlayer(offlinePlayer);
    }

    public static SimplePlayer of(Player player) {
        return new SimplePlayer((OfflinePlayer)player);
    }

    public static SimplePlayer of(CommandSender player) {
        if (player instanceof Player) {
            return new SimplePlayer((OfflinePlayer)((Player)player));
        }
        return null;
    }

    public static SimplePlayer of(UUID uuid) {
        return new SimplePlayer(Bukkit.getOfflinePlayer((UUID)uuid));
    }

    public static SimplePlayer of(String name) {
        return new SimplePlayer(Bukkit.getOfflinePlayer((String)name));
    }

    @NotNull
    public Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("uuid", this.getUUID().toString());
        return map;
    }

    @NotNull
    public static SimplePlayer deserialize(@NotNull Map<String, Object> map) {
        UUID uuid = UUID.fromString((String)map.get("uuid"));
        return new SimplePlayer(Bukkit.getOfflinePlayer((UUID)uuid));
    }
}

