/*
 * Decompiled with CFR 0.152.
 */
package gjum.minecraft.civ.snitchmod.common;

import gjum.minecraft.civ.snitchmod.common.SnitchSqliteDb;
import gjum.minecraft.civ.snitchmod.common.model.JalistEntry;
import gjum.minecraft.civ.snitchmod.common.model.Snitch;
import gjum.minecraft.civ.snitchmod.common.model.SnitchAlert;
import gjum.minecraft.civ.snitchmod.common.model.SnitchBroken;
import gjum.minecraft.civ.snitchmod.common.model.SnitchRename;
import gjum.minecraft.civ.snitchmod.common.model.WorldPos;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SnitchesStore {
    @NotNull
    public final String server;
    private final HashMap<WorldPos, Snitch> snitches = new HashMap(1000);
    private final ConcurrentLinkedQueue<Snitch> queuedDBSnitches = new ConcurrentLinkedQueue();
    @Nullable
    private SnitchSqliteDb db;

    public SnitchesStore(@NotNull String server) {
        this.server = server;
        try {
            this.db = new SnitchSqliteDb(server);
            for (Snitch snitch : this.db.selectAllSnitches()) {
                this.snitches.put(snitch.pos, snitch);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new Thread(){

            @Override
            public void run() {
                int lastAddedSnitchCount = 0;
                while (true) {
                    Snitch newSnitch;
                    try {
                        TimeUnit.MILLISECONDS.sleep(1000L);
                    }
                    catch (InterruptedException err) {
                        Thread.currentThread().interrupt();
                    }
                    long startTime = System.currentTimeMillis();
                    ArrayList<Snitch> snitches = new ArrayList<Snitch>(lastAddedSnitchCount);
                    do {
                        if ((newSnitch = SnitchesStore.this.queuedDBSnitches.poll()) == null) continue;
                        snitches.add(newSnitch);
                    } while (newSnitch != null && snitches.size() < 1000 && System.currentTimeMillis() - startTime < 1000L);
                    if (SnitchesStore.this.db != null) {
                        SnitchesStore.this.db.upsertSnitches(snitches);
                    }
                    lastAddedSnitchCount = snitches.size();
                }
            }
        }.start();
    }

    public void close() {
        if (this.db != null) {
            this.db.close();
        }
    }

    @Nullable
    public Snitch getSnitch(@NotNull WorldPos pos) {
        return this.snitches.get((Object)pos);
    }

    @Nullable
    public Snitch getSnitch(@NotNull String world, @NotNull BlockPos pos) {
        return this.snitches.get((Object)new WorldPos(this.server, world, pos));
    }

    public Collection<Snitch> getAllSnitches() {
        return this.snitches.values();
    }

    public void updateSnitchesFromJalist(List<JalistEntry> jalist) {
        ArrayList<Snitch> jalistSnitches = new ArrayList<Snitch>(jalist.size());
        for (JalistEntry entry : jalist) {
            Snitch snitch = this.snitches.computeIfAbsent(entry.pos, Snitch::new);
            snitch.updateFromJalist(entry);
            jalistSnitches.add(snitch);
        }
        if (this.db != null) {
            this.db.upsertSnitches(jalistSnitches);
        }
    }

    public void updateSnitchFromRename(SnitchRename rename) {
        Snitch snitch = this.snitches.computeIfAbsent(rename.pos, Snitch::new);
        snitch.updateFromRename(rename);
        this.upsertSnitchToDB(snitch);
    }

    public void updateSnitchFromAlert(SnitchAlert alert) {
        Snitch snitch = this.snitches.computeIfAbsent(alert.pos, Snitch::new);
        snitch.updateFromAlert(alert);
        this.upsertSnitchToDB(snitch);
    }

    public void updateSnitchFromCreation(Snitch snitch) {
        this.snitches.put(snitch.pos, snitch);
        this.upsertSnitchToDB(snitch);
    }

    public void updateSnitchBroken(SnitchBroken snitchBroken) {
        Snitch snitch = this.snitches.computeIfAbsent(snitchBroken.pos, Snitch::new);
        snitch.updateFromBroken(snitchBroken);
        this.upsertSnitchToDB(snitch);
    }

    @Nullable
    public Snitch updateSnitchGone(@NotNull WorldPos pos) {
        Snitch snitch = this.snitches.get((Object)pos);
        if (snitch == null) {
            return null;
        }
        snitch.updateGone();
        this.upsertSnitchToDB(snitch);
        return snitch;
    }

    @Nullable
    public Snitch updateSnitchNoLongerGone(@NotNull WorldPos pos) {
        Snitch snitch = this.snitches.get((Object)pos);
        if (snitch == null) {
            return null;
        }
        if (!snitch.isGone()) {
            return null;
        }
        snitch.updateNoLongerGone();
        this.upsertSnitchToDB(snitch);
        return snitch;
    }

    @Nullable
    public Snitch deleteSnitch(@NotNull WorldPos pos) {
        Snitch snitch = this.snitches.remove((Object)pos);
        if (snitch == null) {
            return null;
        }
        this.db.deleteSnitch(pos);
        return snitch;
    }

    private void upsertSnitchToDB(Snitch snitch) {
        if (snitch != null) {
            this.queuedDBSnitches.add(snitch);
        }
    }
}

