/*
 * Decompiled with CFR 0.152.
 */
package gjum.minecraft.civ.snitchmod.common.mixins;

import gjum.minecraft.civ.snitchmod.common.SnitchMod;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.game.ClientboundContainerSetContentPacket;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public abstract class MixinClientPacketListener {
    @Inject(method={"handleSystemChat(Lnet/minecraft/network/protocol/game/ClientboundSystemChatPacket;)V"}, at={@At(value="HEAD")}, cancellable=true)
    protected void onHandleChat(ClientboundSystemChatPacket packet, CallbackInfo ci) {
        if (!Minecraft.getInstance().isSameThread()) {
            return;
        }
        try {
            boolean dropPacket = SnitchMod.getMod().handleChat(packet.content());
            if (dropPacket) {
                ci.cancel();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Inject(method={"handleContainerContent(Lnet/minecraft/network/protocol/game/ClientboundContainerSetContentPacket;)V"}, at={@At(value="HEAD")})
    protected void onHandleContainerContent(ClientboundContainerSetContentPacket packetIn, CallbackInfo ci) {
        if (!Minecraft.getInstance().isSameThread()) {
            return;
        }
        try {
            SnitchMod.getMod().handleWindowItems(packetIn.items());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Inject(method={"handleLogin(Lnet/minecraft/network/protocol/game/ClientboundLoginPacket;)V"}, at={@At(value="HEAD")})
    protected void onHandleLogin(ClientboundLoginPacket packet, CallbackInfo ci) {
        if (!Minecraft.getInstance().isSameThread()) {
            return;
        }
        Minecraft.getInstance().execute(() -> {
            try {
                SnitchMod.getMod().handleConnectedToServer();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
    }
}

