/*
 * Decompiled with CFR 0.152.
 */
package gjum.minecraft.civ.snitchmod.common.model;

import gjum.minecraft.civ.snitchmod.common.model.WorldPos;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class SnitchBroken {
    public final long ts;
    @NotNull
    public final WorldPos pos;
    @NotNull
    public final String group;
    private static final Pattern brokenPattern = Pattern.compile("^(\\S+) was reinforced on (\\S+) owned by ([A-Za-z0-9_]{3,17}).*");

    public SnitchBroken(@NotNull WorldPos pos, @NotNull String group) {
        this.pos = pos;
        this.group = group;
        this.ts = System.currentTimeMillis();
    }

    public static SnitchBroken fromChat(@NotNull Component message, @NotNull BlockPos lastBrokenBlockPos, @NotNull String server, @NotNull String world) {
        String text = message.getString().replaceAll("\u00a7.", "");
        Matcher textMatch = brokenPattern.matcher(text);
        if (!textMatch.matches()) {
            return null;
        }
        String group = textMatch.group(2);
        int x = lastBrokenBlockPos.getX();
        int y = lastBrokenBlockPos.getY();
        int z = lastBrokenBlockPos.getZ();
        return new SnitchBroken(new WorldPos(server, world, x, y, z), group);
    }
}

