/*
 * Decompiled with CFR 0.152.
 */
package gjum.minecraft.civ.snitchmod.common.model;

import gjum.minecraft.civ.snitchmod.common.model.Direction;
import gjum.minecraft.civ.snitchmod.common.model.Snitch;
import gjum.minecraft.civ.snitchmod.common.model.WorldPos;
import net.minecraft.core.BlockPos;
import org.jetbrains.annotations.NotNull;

public class SnitchFieldPreview {
    private Snitch source;
    private Direction direction;
    private Snitch field;

    public SnitchFieldPreview(Snitch source, Direction direction) {
        this.source = source;
        this.direction = direction;
        BlockPos previewPos = SnitchFieldPreview.transposeSnitchFieldPositionByDirection(source.getPos(), direction);
        this.field = new Snitch(new WorldPos(source.getPos().getServer(), source.getPos().getWorld(), previewPos.getX(), previewPos.getY(), previewPos.getZ()));
    }

    @NotNull
    public static BlockPos transposeSnitchFieldPositionByDirection(@NotNull BlockPos fieldCenter, @NotNull Direction direction) {
        double pitch;
        int x = fieldCenter.getX();
        int y = fieldCenter.getY();
        int z = fieldCenter.getZ();
        double yaw = direction.yaw().value();
        if ((yaw = (yaw + 180.0) % 360.0) < 0.0) {
            yaw += 360.0;
        }
        if ((pitch = direction.pitch().value()) <= -60.0) {
            return new BlockPos(x, y + 23, z);
        }
        if (pitch > -60.0 && pitch <= -30.0) {
            y += 22;
        } else if (pitch > -30.0 && pitch <= 30.0) {
            if (yaw >= 337.5 || yaw < 22.5) {
                return new BlockPos(x, y, z - 23);
            }
            if (yaw >= 67.5 && yaw < 112.5) {
                return new BlockPos(x + 23, y, z);
            }
            if (yaw >= 157.5 && yaw < 202.5) {
                return new BlockPos(x, y, z + 23);
            }
            if (yaw >= 247.5 && yaw < 292.5) {
                return new BlockPos(x - 23, y, z);
            }
        } else if (pitch > 30.0 && pitch <= 60.0) {
            y -= 22;
        } else if (pitch >= 60.0) {
            return new BlockPos(x, y - 23, z);
        }
        if (yaw >= 337.5 || yaw < 22.5) {
            return new BlockPos(x, y, z - 22);
        }
        if (yaw >= 22.5 && yaw < 67.5) {
            return new BlockPos(x + 22, y, z - 22);
        }
        if (yaw >= 67.5 && yaw < 112.5) {
            return new BlockPos(x + 22, y, z);
        }
        if (yaw >= 112.5 && yaw < 157.5) {
            return new BlockPos(x + 22, y, z + 22);
        }
        if (yaw >= 157.5 && yaw < 202.5) {
            return new BlockPos(x, y, z + 22);
        }
        if (yaw >= 202.5 && yaw < 247.5) {
            return new BlockPos(x - 22, y, z + 22);
        }
        if (yaw >= 247.5 && yaw < 292.5) {
            return new BlockPos(x - 22, y, z);
        }
        if (yaw >= 292.5 && yaw < 337.5) {
            return new BlockPos(x - 22, y, z - 22);
        }
        throw new IllegalArgumentException(String.format("Out of range values of yaw %f and/or pitch %f.", direction.yaw().value(), direction.pitch().value()));
    }

    public Snitch source() {
        return this.source;
    }

    public Direction direction() {
        return this.direction;
    }

    public Snitch field() {
        return this.field;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SnitchFieldPreview)) {
            return false;
        }
        SnitchFieldPreview p = (SnitchFieldPreview)obj;
        return this.field.pos.equals((Object)p.field.pos);
    }
}

