/*
 * Decompiled with CFR 0.152.
 */
package gjum.minecraft.civ.snitchmod.common.model;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class WorldPos
extends BlockPos {
    @NotNull
    public final String server;
    @NotNull
    public final String world;

    public WorldPos(@NotNull String server, @NotNull String world, int x, int y, int z) {
        super(x, y, z);
        this.server = server;
        this.world = world;
    }

    public WorldPos(@NotNull String server, @NotNull String world, BlockPos pos) {
        super((Vec3i)pos);
        this.server = server;
        this.world = world;
    }

    @NotNull
    public String getServer() {
        return this.server;
    }

    @NotNull
    public String getWorld() {
        return this.world;
    }

    public Vec3 getCenter() {
        return new Vec3((double)this.getX() + 0.5, (double)this.getY() + 0.5, (double)this.getZ() + 0.5);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorldPos)) {
            return false;
        }
        WorldPos worldPos = (WorldPos)((Object)o);
        if (!super.equals(o)) {
            return false;
        }
        return this.server.equals(worldPos.server) && this.world.equals(worldPos.world);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.server, this.world);
    }
}

