/*
 * Decompiled with CFR 0.152.
 */
package gjum.minecraft.civ.snitchmod.common;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gjum.minecraft.civ.snitchmod.common.SnitchMod;
import gjum.minecraft.civ.snitchmod.common.Utils;
import gjum.minecraft.civ.snitchmod.common.model.Snitch;
import gjum.minecraft.civ.snitchmod.common.model.SnitchFieldPreview;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShapeRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL11;

public class Renderer {
    private static final Minecraft mc = Minecraft.getInstance();
    private static final Utils.Color BLACK = new Utils.Color(0x333333);
    private static final Utils.Color WHITE = new Utils.Color(0xEEEEEE);
    private static final Utils.Color RED = new Utils.Color(15614038);
    private static final Utils.Color GREEN = new Utils.Color(2673746);
    private static final Utils.Color BLUE = new Utils.Color(45823);
    private static final Utils.Color YELLOW = new Utils.Color(15652928);
    private static final Utils.Color ORANGE = new Utils.Color(15630656);
    private static final Utils.Color PINK = new Utils.Color(0xFC66CC);
    private static PoseStack eventPoseStack = null;

    public static void renderOverlays(PoseStack poseStack) {
        eventPoseStack = poseStack;
        if (Renderer.mc.player == null) {
            return;
        }
        if (Renderer.mc.level == null) {
            return;
        }
        if (Renderer.mc.options.hideGui) {
            return;
        }
        Vec3 camPos = Renderer.mc.gameRenderer.getMainCamera().getPosition();
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.mul((Matrix4fc)eventPoseStack.last().pose());
        modelViewStack.translate((float)(-camPos.x), (float)(-camPos.y), (float)(-camPos.z));
        if (SnitchMod.getMod().rangeOverlayVisible) {
            int fieldDist = 260;
            SnitchMod.getMod().streamNearbySnitches(Renderer.mc.player.position(), fieldDist).filter(s -> !s.wasBroken()).limit(100L).forEach(Renderer::renderSnitch);
        }
        if (SnitchMod.getMod().placementHelperVisible) {
            int placeHelperDist = 50;
            SnitchMod.getMod().streamNearbySnitches(Renderer.mc.player.position(), placeHelperDist).filter(Snitch::isAlive).limit(10L).forEach(Renderer::renderPlacementHelper);
        }
        if (SnitchMod.getMod().snitchFieldToPreview != null) {
            Renderer.renderSnitchFieldPreview(SnitchMod.getMod().snitchFieldToPreview);
        }
        RenderSystem.lineWidth((float)1.0f);
        modelViewStack.popMatrix();
        MultiBufferSource.BufferSource buffers = Minecraft.getInstance().renderBuffers().bufferSource();
        buffers.endBatch();
        eventPoseStack = null;
    }

    private static void renderSnitchFieldPreview(SnitchFieldPreview preview) {
        Utils.Color color = PINK;
        float boxAlpha = 0.2f;
        float lineAlpha = 1.0f;
        float lineWidth = 2.0f;
        int blockHlDist = 64;
        AABB range = preview.field().getRangeAABB();
        boolean playerInRange = range.contains(Renderer.mc.player.position());
        AABB rangeBox = playerInRange ? range.inflate(-0.01) : range.inflate(0.01);
        try (RenderBufferGuard ignored = RenderBufferGuard.open(true, true, false);){
            Renderer.renderFilledBox(rangeBox, color, 0.2f);
            Renderer.renderBoxOutline(rangeBox, color, 1.0f, 2.0f);
            Renderer.renderBoxGuides(rangeBox, color, 1.0f, 2.0f);
        }
        if (preview.field().pos.distSqr((Vec3i)Renderer.mc.player.blockPosition()) < 4096.0) {
            ignored = RenderBufferGuard.open(false, false, false);
            try {
                AABB blockBox = new AABB((BlockPos)preview.field().pos).inflate(0.01);
                Renderer.renderBoxOutline(blockBox, color, 1.0f, 2.0f);
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
        }
    }

    private static void renderSnitch(Snitch snitch) {
        AABB outlineBox;
        AABB range = snitch.getRangeAABB();
        boolean playerInRange = range.contains(Renderer.mc.player.position());
        AABB rangeBox = playerInRange ? range.inflate(-0.01) : range.inflate(0.01);
        AABB aABB = outlineBox = playerInRange ? range.inflate(-0.01) : range.inflate(0.01);
        if (playerInRange) {
            snitch.maybeRefreshed = true;
        }
        long now = System.currentTimeMillis();
        long snitchTimer = snitch.getType() != null ? snitch.getType().timer : Snitch.Type.NOTEBLOCK.timer;
        static enum SnitchLiveliness {
            BROKEN(RED),
            GONE(RED),
            LONG_TIME_NOT_SEEN(RED),
            CULLED(RED),
            WILL_CULL(ORANGE),
            WILL_CULL_MAYBE_REFRESHED(GREEN),
            DORMANT_NOW(ORANGE),
            DORMANT_NOW_MAYBE_REFRESHED(GREEN),
            DORMANT_SOON(ORANGE),
            DORMANT_SOON_MAYBE_REFRESHED(GREEN),
            DORMANT_SOONISH(YELLOW),
            DORMANT_SOONISH_MAYBE_REFRESHED(GREEN),
            DORMANT_EVENTUALLY(GREEN);

            private final Utils.Color color;

            private SnitchLiveliness(Utils.Color color) {
                this.color = color;
            }
        }
        SnitchLiveliness snitchLiveliness = SnitchLiveliness.DORMANT_EVENTUALLY;
        if (snitch.wasBroken()) {
            snitchLiveliness = SnitchLiveliness.BROKEN;
        } else if (snitch.isGone()) {
            snitchLiveliness = SnitchLiveliness.GONE;
        } else if (snitch.getLastSeenTs() != 0L && now - snitch.getLastSeenTs() > snitchTimer) {
            snitchLiveliness = SnitchLiveliness.LONG_TIME_NOT_SEEN;
        } else if (snitch.hasCullTs() && snitch.getCullTs() < now) {
            snitchLiveliness = SnitchLiveliness.CULLED;
        } else if (snitch.hasCullTs() && snitch.getCullTs() > now) {
            snitchLiveliness = snitch.maybeRefreshed ? SnitchLiveliness.WILL_CULL_MAYBE_REFRESHED : SnitchLiveliness.WILL_CULL;
        } else if (snitch.hasDormantTs() && snitch.getDormantTs() < now) {
            snitchLiveliness = snitch.maybeRefreshed ? SnitchLiveliness.DORMANT_NOW_MAYBE_REFRESHED : SnitchLiveliness.DORMANT_NOW;
        } else if (snitch.hasDormantTs() && snitch.getDormantTs() > now) {
            long goodThreshold = 604800000L;
            long badThreshold = 259200000L;
            long delta = snitch.getDormantTs() - now;
            if (delta < 604800000L) {
                snitchLiveliness = delta >= 259200000L ? (snitch.maybeRefreshed ? SnitchLiveliness.DORMANT_SOONISH_MAYBE_REFRESHED : SnitchLiveliness.DORMANT_SOONISH) : (snitch.maybeRefreshed ? SnitchLiveliness.DORMANT_SOON_MAYBE_REFRESHED : SnitchLiveliness.DORMANT_SOON);
            }
        }
        float boxAlpha = 0.2f;
        float lineAlpha = 1.0f;
        if (snitch.isGone()) {
            boxAlpha = 0.0f;
            lineAlpha = 0.5f;
        }
        float lineWidth = 2.0f;
        try (RenderBufferGuard ignored = RenderBufferGuard.open(true, true, false);){
            Renderer.renderFilledBox(rangeBox, snitchLiveliness.color, boxAlpha);
            if (!snitch.isGone()) {
                Renderer.renderBoxOutline(outlineBox, snitchLiveliness.color, lineAlpha, 2.0f);
            }
        }
        int blockHlDist = 64;
        if (snitch.pos.distSqr((Vec3i)Renderer.mc.player.blockPosition()) < 4096.0) {
            try (RenderBufferGuard ignored = RenderBufferGuard.open(false, false, false);){
                AABB blockBox = new AABB((BlockPos)snitch.pos).inflate(0.01);
                Utils.Color boxOutlineColor = snitchLiveliness.color;
                if (SnitchMod.getMod().snitchFieldToPreview != null && SnitchMod.getMod().snitchFieldToPreview.source().equals(snitch)) {
                    boxOutlineColor = PINK;
                }
                Renderer.renderBoxOutline(blockBox, boxOutlineColor, lineAlpha, 2.0f);
                Utils.Color boxFillColor = snitch.isGone() ? BLACK : snitchLiveliness.color;
                Renderer.renderFilledBox(blockBox, boxFillColor, boxAlpha);
            }
        }
        record ColoredComponent(Component text, Utils.Color color) {
        }
        ArrayList<ColoredComponent> linesToRender = new ArrayList<ColoredComponent>(3);
        boolean playerLookingAtSnitch = Utils.playerIsLookingAtSnitch(Renderer.mc.player, snitch);
        Vec3 eyePosition = new Vec3(Renderer.mc.player.position().x, Renderer.mc.player.position().y + 1.0, Renderer.mc.player.position().z);
        if ((!snitch.isGone() && playerInRange || playerLookingAtSnitch) && (eyePosition.y != (double)snitch.pos.getY() || eyePosition.distanceTo(snitch.pos.getCenter()) > 3.0)) {
            String group;
            String name = snitch.getName();
            if (name != null && !name.isEmpty()) {
                linesToRender.add(new ColoredComponent((Component)Component.literal((String)name), WHITE));
            }
            if ((group = snitch.getGroup()) != null) {
                linesToRender.add(new ColoredComponent((Component)Component.literal((String)String.format("[%s]", group)), WHITE));
            }
            String lastSeenText = null;
            if (snitch.getLastSeenTs() != 0L) {
                lastSeenText = String.format("last seen %s", Renderer.timestampRelativeText(snitch.getLastSeenTs()));
            }
            String maxSnitchTimerText = "";
            if (playerLookingAtSnitch) {
                maxSnitchTimerText = String.format(" / %s", Renderer.durationToText(snitchTimer));
            }
            Object livelinessText = null;
            switch (snitchLiveliness.ordinal()) {
                case 0: {
                    livelinessText = "broken " + Renderer.timestampRelativeText(snitch.getBrokenTs());
                    break;
                }
                case 1: {
                    livelinessText = "gone " + Renderer.timestampRelativeText(snitch.getGoneTs());
                    break;
                }
                case 2: {
                    livelinessText = lastSeenText;
                    break;
                }
                case 3: {
                    livelinessText = "culled " + Renderer.timestampRelativeText(snitch.getCullTs());
                    break;
                }
                case 4: 
                case 5: {
                    livelinessText = String.format("culls %s%s", Renderer.timestampRelativeText(snitch.getCullTs()), maxSnitchTimerText);
                    break;
                }
                case 6: 
                case 7: {
                    livelinessText = "deactivated " + Renderer.timestampRelativeText(snitch.getDormantTs());
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    if (!snitch.hasDormantTs()) break;
                    livelinessText = String.format("deactivates %s%s", Renderer.timestampRelativeText(snitch.getDormantTs()), maxSnitchTimerText);
                }
            }
            if (livelinessText != null) {
                if (snitch.maybeRefreshed) {
                    switch (snitchLiveliness.ordinal()) {
                        case 5: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 12: {
                            livelinessText = (String)livelinessText + " (refreshed?)";
                            break;
                        }
                    }
                }
                linesToRender.add(new ColoredComponent((Component)Component.literal((String)livelinessText), snitchLiveliness.color));
            }
            if (playerLookingAtSnitch) {
                linesToRender.add(new ColoredComponent((Component)Component.literal((String)String.format("%d %d %d", snitch.getPos().getX(), snitch.getPos().getY(), snitch.getPos().getZ())), WHITE));
                if (snitch.getType() != null) {
                    linesToRender.add(new ColoredComponent((Component)Component.literal((String)StringUtils.capitalize((String)snitch.getType().toString().replaceAll("_", ""))), WHITE));
                }
                if (lastSeenText != null && snitchLiveliness != SnitchLiveliness.LONG_TIME_NOT_SEEN) {
                    linesToRender.add(new ColoredComponent((Component)Component.literal((String)lastSeenText), WHITE));
                }
            }
        }
        Vec3 center = snitch.pos.getCenter();
        int offset = -1;
        for (ColoredComponent line : linesToRender) {
            Renderer.renderTextFacingCamera(line.text, center, offset, 1.0f, line.color.hex);
            ++offset;
        }
    }

    private static void renderPlacementHelper(Snitch snitch) {
        boolean playerInRange = snitch.getRangeAABB().contains(Renderer.mc.player.position());
        if (playerInRange) {
            return;
        }
        AABB helperBox = new AABB((BlockPos)snitch.pos).inflate(22.3);
        try (RenderBufferGuard ignored = RenderBufferGuard.open(true, true, false);){
            Renderer.renderFilledBox(helperBox, BLUE, 0.2f);
        }
    }

    private static void renderBoxOutline(AABB box, Utils.Color color, float alpha, float lineWidth) {
        try (RenderBufferGuard guard = RenderBufferGuard.open();){
            RenderSystem.lineWidth((float)lineWidth);
            VertexConsumer vertexConsumer = guard.bufferSource.getBuffer(RenderType.debugLineStrip((double)lineWidth));
            ShapeRenderer.renderLineBox((PoseStack)eventPoseStack, (VertexConsumer)vertexConsumer, (double)box.minX, (double)box.minY, (double)box.minZ, (double)box.maxX, (double)box.maxY, (double)box.maxZ, (float)color.r, (float)color.g, (float)color.b, (float)alpha);
        }
    }

    private static void renderFilledBox(AABB box, Utils.Color color, float alpha) {
        try (RenderBufferGuard guard = RenderBufferGuard.open();){
            VertexConsumer vertexConsumer = guard.bufferSource.getBuffer(RenderType.debugQuads());
            float minX = (float)box.minX;
            float minY = (float)box.minY;
            float minZ = (float)box.minZ;
            float maxX = (float)box.maxX;
            float maxY = (float)box.maxY;
            float maxZ = (float)box.maxZ;
            for (Direction direction : Direction.values()) {
                ShapeRenderer.renderFace((PoseStack)eventPoseStack, (VertexConsumer)vertexConsumer, (Direction)direction, (float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, (float)color.r, (float)color.g, (float)color.b, (float)alpha);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderBoxGuides(AABB box, Utils.Color color, float a, float lineWidth) {
        boolean initialLineSmooth = GL11.glIsEnabled((int)2848);
        RenderSystem.lineWidth((float)lineWidth);
        float r = color.r;
        float g = color.g;
        float b = color.b;
        Vec3 center = box.getCenter();
        float radius = (float)(box.maxX - center.x);
        try (RenderBufferGuard guard = RenderBufferGuard.open();){
            PoseStack poseStack = new PoseStack();
            PoseStack.Pose pose = poseStack.last();
            GL11.glEnable((int)2848);
            VertexConsumer vertexConsumer = guard.bufferSource.getBuffer(RenderType.debugLineStrip((double)lineWidth));
            vertexConsumer.addVertex(pose, (float)center.x + 1.0f, (float)center.y, (float)center.z).setColor(r, g, b, a).setNormal(1.0f, 0.0f, 0.0f);
            vertexConsumer.addVertex(pose, (float)center.x + radius, (float)center.y, (float)center.z).setColor(r, g, b, a).setNormal(1.0f, 0.0f, 0.0f);
            vertexConsumer.addVertex(pose, (float)center.x - 1.0f, (float)center.y, (float)center.z).setColor(r, g, b, a).setNormal(-1.0f, 0.0f, 0.0f);
            vertexConsumer.addVertex(pose, (float)center.x - radius, (float)center.y, (float)center.z).setColor(r, g, b, a).setNormal(-1.0f, 0.0f, 0.0f);
            vertexConsumer.addVertex(pose, (float)center.x, (float)center.y + 1.0f, (float)center.z).setColor(r, g, b, a).setNormal(0.0f, 1.0f, 0.0f);
            vertexConsumer.addVertex(pose, (float)center.x, (float)center.y + radius, (float)center.z).setColor(r, g, b, a).setNormal(1.0f, 0.0f, 0.0f);
            vertexConsumer.addVertex(pose, (float)center.x, (float)center.y - 1.0f, (float)center.z).setColor(r, g, b, a).setNormal(0.0f, -1.0f, 0.0f);
            vertexConsumer.addVertex(pose, (float)center.x, (float)center.y - radius, (float)center.z).setColor(r, g, b, a).setNormal(-1.0f, 0.0f, 0.0f);
            vertexConsumer.addVertex(pose, (float)center.x, (float)center.y, (float)center.z + 1.0f).setColor(r, g, b, a).setNormal(0.0f, 0.0f, 1.0f);
            vertexConsumer.addVertex(pose, (float)center.x, (float)center.y, (float)center.z + radius).setColor(r, g, b, a).setNormal(0.0f, 0.0f, 1.0f);
            vertexConsumer.addVertex(pose, (float)center.x, (float)center.y, (float)center.z - 1.0f).setColor(r, g, b, a).setNormal(0.0f, 0.0f, -1.0f);
            vertexConsumer.addVertex(pose, (float)center.x, (float)center.y, (float)center.z - radius).setColor(r, g, b, a).setNormal(0.0f, 0.0f, -1.0f);
        }
        finally {
            if (!initialLineSmooth) {
                GL11.glDisable((int)2848);
            }
        }
    }

    private static void renderTextFacingCamera(Component text, Vec3 pos, float offset, float scale, int colorAlphaHex) {
        float w = Renderer.mc.font.width((FormattedText)text);
        float x = -w / 2.0f;
        float f = -(0.5f - offset);
        Objects.requireNonNull(Renderer.mc.font);
        float y = f * (float)(9 + 2);
        boolean shadow = false;
        scale = (float)((double)scale * ((double)0.005f * (Renderer.mc.player.position().distanceTo(pos) / 2.4)));
        scale = Math.clamp(scale, 0.015f, 0.15f);
        Matrix4f matrix = new Matrix4f((Matrix4fc)eventPoseStack.last().pose());
        matrix.scale(scale, -scale, 1.0f);
        float bgOpacity = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
        int bgColor = (int)(bgOpacity * 255.0f) << 24;
        int flags = 0;
        try (RenderBufferGuard guard = RenderBufferGuard.open(false, false, false);){
            Renderer.mc.font.drawInBatch(text, x, y, colorAlphaHex, shadow, matrix, (MultiBufferSource)guard.bufferSource, Font.DisplayMode.SEE_THROUGH, bgColor, flags);
        }
    }

    @NotNull
    private static String timestampRelativeText(long ts) {
        long now = System.currentTimeMillis();
        if (ts < now) {
            return Renderer.durationToText(now - ts) + " ago";
        }
        return "in " + Renderer.durationToText(ts - now);
    }

    @NotNull
    private static String durationToText(long ms) {
        if (ms < 0L) {
            ms = -ms;
        }
        if (ms < 1000L) {
            return ms + "ms";
        }
        long sec = ms / 1000L;
        if (sec < 100L) {
            return sec + "s";
        }
        long min = sec / 60L;
        if (min < 100L) {
            return min + "min";
        }
        long hours = min / 60L;
        if (hours < 48L) {
            return hours + "h";
        }
        long days = hours / 24L;
        return days + " days";
    }

    public static class RenderBufferGuard
    implements AutoCloseable {
        public MultiBufferSource.BufferSource bufferSource;
        private static ByteBufferBuilder byteBufferBuilder = new ByteBufferBuilder(262144);
        private static MultiBufferSource.BufferSource sBufferSource = null;
        private static RenderBufferGuard current = null;
        private RenderBufferGuard parent = current;
        private int referenceCount = 1;
        private boolean enableDepthTest;
        private boolean enableDepthMask;
        private boolean enableCullFace;
        private boolean initialDepthTestValue;
        private boolean initialDepthMask;
        private boolean initialCullFace;

        private RenderBufferGuard(boolean enableDepthTest, boolean enableDepthMask, boolean enableCullFace) {
            current = this;
            this.enableDepthTest = enableDepthTest;
            this.enableDepthMask = enableDepthMask;
            this.enableCullFace = enableCullFace;
            this.initialDepthTestValue = GL11.glIsEnabled((int)2929);
            this.initialDepthMask = GL11.glGetBoolean((int)2930);
            this.initialCullFace = GL11.glIsEnabled((int)2884);
            if (this.parent != null) {
                sBufferSource.endBatch();
                byteBufferBuilder.clear();
            } else {
                sBufferSource = MultiBufferSource.immediate((ByteBufferBuilder)byteBufferBuilder);
            }
            this.bufferSource = sBufferSource;
            if (enableDepthTest) {
                GL11.glEnable((int)2929);
            } else {
                GL11.glDisable((int)2929);
            }
            GL11.glDepthMask((boolean)enableDepthMask);
            if (enableCullFace) {
                GL11.glEnable((int)2884);
            } else {
                GL11.glDisable((int)2884);
            }
        }

        public static RenderBufferGuard open(boolean enableDepthTest, boolean enableDepthMask, boolean enableCullFace) {
            if (current != null && RenderBufferGuard.current.enableDepthTest == enableDepthTest && RenderBufferGuard.current.enableDepthMask == enableDepthMask && RenderBufferGuard.current.enableCullFace == enableCullFace) {
                ++RenderBufferGuard.current.referenceCount;
                return current;
            }
            return new RenderBufferGuard(enableDepthTest, enableDepthMask, enableCullFace);
        }

        public static RenderBufferGuard open() {
            if (current != null) {
                ++RenderBufferGuard.current.referenceCount;
                return current;
            }
            return new RenderBufferGuard(GL11.glIsEnabled((int)2929), GL11.glGetBoolean((int)2930), GL11.glIsEnabled((int)2884));
        }

        @Override
        public void close() {
            if (this.referenceCount > 1) {
                --this.referenceCount;
                return;
            }
            current = this.parent;
            try {
                this.bufferSource.endBatch();
            }
            finally {
                if (this.initialDepthTestValue) {
                    GL11.glEnable((int)2929);
                } else {
                    GL11.glDisable((int)2929);
                }
                GL11.glDepthMask((boolean)this.initialDepthMask);
                if (this.initialCullFace) {
                    GL11.glEnable((int)2884);
                } else {
                    GL11.glDisable((int)2884);
                }
                if (this.parent == null) {
                    sBufferSource = null;
                }
            }
        }
    }
}

