/*
 * Decompiled with CFR 0.152.
 */
package gjum.minecraft.civ.snitchmod.common;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import gjum.minecraft.civ.snitchmod.common.Renderer;
import gjum.minecraft.civ.snitchmod.common.SnitchesStore;
import gjum.minecraft.civ.snitchmod.common.Utils;
import gjum.minecraft.civ.snitchmod.common.model.Direction;
import gjum.minecraft.civ.snitchmod.common.model.JalistEntry;
import gjum.minecraft.civ.snitchmod.common.model.Snitch;
import gjum.minecraft.civ.snitchmod.common.model.SnitchAlert;
import gjum.minecraft.civ.snitchmod.common.model.SnitchCreatedChatParser;
import gjum.minecraft.civ.snitchmod.common.model.SnitchFieldPreview;
import gjum.minecraft.civ.snitchmod.common.model.SnitchRename;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class SnitchMod {
    private static final Minecraft mc = Minecraft.getInstance();
    protected static final KeyMapping openGuiKey = new KeyMapping("key.snitchmod.openGui", InputConstants.Type.KEYSYM, 76, "category.snitchmod");
    protected static final KeyMapping toggleOverlayKey = new KeyMapping("key.snitchmod.toggleOverlay", InputConstants.Type.KEYSYM, 79, "category.snitchmod");
    protected static final KeyMapping togglePlacementKey = new KeyMapping("key.snitchmod.togglePlacement", InputConstants.Type.KEYSYM, 80, "category.snitchmod");
    protected static final KeyMapping previewSnitchFieldKey = new KeyMapping("key.snitchmod.togglePreviewSnitchFieldKey", InputConstants.Type.KEYSYM, 78, "category.snitchmod");
    protected static final KeyMapping toggleSnitchGoneStatusKey = new KeyMapping("key.snitchmod.toggleSnitchGoneStatusKey", InputConstants.Type.KEYSYM, 261, "category.snitchmod");
    protected static final KeyMapping toggleSnitchFieldRenderKey = new KeyMapping("key.snitchmod.toggleSnitchFieldRenderKey", InputConstants.Type.KEYSYM, 84, "category.snitchmod");
    private static SnitchMod INSTANCE;
    public boolean rangeOverlayVisible = false;
    public boolean placementHelperVisible = false;
    @Nullable
    public SnitchFieldPreview snitchFieldToPreview = null;
    @Nullable
    public Snitch lastBrokenSnitch = null;
    @Nullable
    private SnitchesStore store;

    public static SnitchMod getMod() {
        return INSTANCE;
    }

    public SnitchMod() {
        if (INSTANCE != null) {
            throw new IllegalStateException("Constructor called twice");
        }
        INSTANCE = this;
    }

    @Nullable
    public String getCurrentServer() {
        ServerData currentServer = mc.getCurrentServer();
        if (currentServer == null) {
            return null;
        }
        return currentServer.ip;
    }

    public String getCurrentWorld() {
        String dimension;
        if (SnitchMod.mc.level == null) {
            return null;
        }
        return switch (dimension = SnitchMod.mc.level.dimension().location().getPath()) {
            case "overworld" -> "world";
            case "the_nether" -> "world_nether";
            case "the_end" -> "world_the_end";
            default -> dimension;
        };
    }

    public UUID getClientUuid() {
        if (SnitchMod.mc.player == null) {
            return null;
        }
        return SnitchMod.mc.player.getUUID();
    }

    @Nullable
    public SnitchesStore getStore() {
        String server = this.getCurrentServer();
        if (this.store != null && !this.store.server.equals(server)) {
            this.store.close();
            this.store = null;
        }
        if (this.store == null && server != null) {
            this.store = new SnitchesStore(server);
        }
        return this.store;
    }

    public void handleConnectedToServer() {
        this.getStore();
    }

    public void handleDisconnectedFromServer() {
        if (this.store != null) {
            this.store.close();
        }
        this.store = null;
    }

    public void handleTick() {
        while (openGuiKey.consumeClick()) {
            this.store.close();
            this.store = null;
            this.getStore();
            this.logToChat((Component)Component.literal((String)"Reloaded the database"));
        }
        while (toggleSnitchGoneStatusKey.consumeClick() && SnitchMod.getMod().rangeOverlayVisible) {
            Optional<Snitch> optSnitch = SnitchMod.getMod().streamNearbySnitches(SnitchMod.mc.player.position(), 260).filter(s -> !s.wasBroken()).limit(100L).filter(s -> Utils.playerIsLookingAtSnitch(SnitchMod.mc.player, s)).findFirst();
            if (optSnitch.isEmpty()) {
                this.logToChat((Component)Component.literal((String)"Error: you must be looking at a snitch to change its status"));
                break;
            }
            Snitch snitch = optSnitch.get();
            String formattedSnitch = String.format("\"%s\" on [%s] at %d %d %d", snitch.getName() != null ? snitch.getName() : "", snitch.getGroup(), snitch.getPos().getX(), snitch.getPos().getY(), snitch.getPos().getZ());
            if (snitch.isGone()) {
                this.store.updateSnitchNoLongerGone(snitch.pos);
                this.logToChat((Component)Component.literal((String)String.format("Marked snitch %s as alive", formattedSnitch)));
                continue;
            }
            this.store.updateSnitchGone(snitch.pos);
            this.logToChat((Component)Component.literal((String)String.format("Marked snitch %s as gone", formattedSnitch)));
        }
        while (toggleOverlayKey.consumeClick()) {
            this.rangeOverlayVisible = !this.rangeOverlayVisible;
            this.logToChat((Component)Component.literal((String)("Range overlay " + (this.rangeOverlayVisible ? "visible" : "hidden"))));
        }
        while (togglePlacementKey.consumeClick()) {
            boolean bl = this.placementHelperVisible = !this.placementHelperVisible;
            if (this.placementHelperVisible) {
                this.snitchFieldToPreview = null;
            }
            this.logToChat((Component)Component.literal((String)("Placement helper " + (this.placementHelperVisible ? "visible" : "hidden"))));
        }
        while (previewSnitchFieldKey.consumeClick()) {
            Optional<Snitch> optNearestSnitch = this.streamNearbySnitches(SnitchMod.mc.player.position(), 46).filter(Snitch::isAlive).findFirst();
            if (optNearestSnitch.isEmpty()) {
                this.snitchFieldToPreview = null;
                this.logToChat((Component)Component.literal((String)"No nearby alive snitches to base a field preview on"));
                break;
            }
            Snitch nearestSnitch = optNearestSnitch.get();
            if (this.placementHelperVisible) {
                this.placementHelperVisible = false;
            }
            SnitchFieldPreview newSnitchFieldToPreview = new SnitchFieldPreview(nearestSnitch, Direction.ofPlayer(SnitchMod.mc.player));
            if (this.snitchFieldToPreview != null && newSnitchFieldToPreview.equals(this.snitchFieldToPreview)) {
                this.logToChat((Component)Component.literal((String)"Turning off the snitch field preview"));
                this.snitchFieldToPreview = null;
                break;
            }
            this.snitchFieldToPreview = newSnitchFieldToPreview;
            this.logToChat((Component)Component.literal((String)"Showing a snitch field preview in the direction you're looking"));
        }
    }

    public boolean handleChat(Component message) {
        this.getStore();
        if (this.store == null) {
            return false;
        }
        SnitchAlert snitchAlert = SnitchAlert.fromChat(message, this.store.server, this.getCurrentWorld());
        if (snitchAlert != null) {
            this.store.updateSnitchFromAlert(snitchAlert);
            return false;
        }
        SnitchRename snitchRename = SnitchRename.fromChat(message, this.store.server, this.getCurrentWorld(), this.getClientUuid());
        if (snitchRename != null) {
            this.store.updateSnitchFromRename(snitchRename);
            return false;
        }
        Snitch snitchCreated = SnitchCreatedChatParser.fromChat(message, this.store.server, this.getCurrentWorld(), this.getClientUuid());
        if (snitchCreated != null) {
            Snitch alreadyExistingSnitch = this.store.getSnitch(snitchCreated.pos);
            this.store.updateSnitchFromCreation(snitchCreated);
            if (alreadyExistingSnitch != null && alreadyExistingSnitch.getName() != null && !alreadyExistingSnitch.getName().equals("")) {
                SnitchMod.mc.player.connection.sendCommand(String.format("janameat %d %d %d %s", alreadyExistingSnitch.pos.getX(), alreadyExistingSnitch.pos.getY(), alreadyExistingSnitch.pos.getZ(), alreadyExistingSnitch.getName()));
                this.logToChat((Component)Component.literal((String)String.format("Named the replaced snitch \"%s\"", alreadyExistingSnitch.getName())));
            }
            if (this.snitchFieldToPreview != null && this.snitchFieldToPreview.field().pos.equals((Object)snitchCreated.pos)) {
                if (this.placementHelperVisible) {
                    this.placementHelperVisible = false;
                }
                this.snitchFieldToPreview = new SnitchFieldPreview(snitchCreated, this.snitchFieldToPreview.direction());
                this.logToChat((Component)Component.literal((String)"Showing an inferred snitch field preview"));
            }
            return false;
        }
        return false;
    }

    public void handleWindowItems(List<ItemStack> stacks) {
        this.getStore();
        if (this.store == null) {
            return;
        }
        ArrayList<JalistEntry> jalistEntries = new ArrayList<JalistEntry>(stacks.size());
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack stack = stacks.get(i);
            try {
                JalistEntry jalistEntry = JalistEntry.fromStack(stack, this.store.server);
                if (jalistEntry == null) continue;
                jalistEntries.add(jalistEntry);
                continue;
            }
            catch (Throwable e) {
                System.err.println("Failed parsing jalist stack " + i + " " + String.valueOf(stack));
                e.printStackTrace();
                this.logToChat((Component)Component.literal((String)("Failed reading snitch " + i + " on JAList page")));
            }
        }
        this.store.updateSnitchesFromJalist(jalistEntries);
        if (jalistEntries.size() > 0) {
            this.logToChat((Component)Component.literal((String)("Found " + jalistEntries.size() + " snitches on JAList page")));
        }
    }

    public void handleRenderBlockOverlay(PoseStack poseStack) {
        Renderer.renderOverlays(poseStack);
    }

    public Stream<Snitch> streamNearbySnitches(Vec3 playerPos, int distance) {
        this.getStore();
        if (this.store == null) {
            return Stream.empty();
        }
        return this.store.getAllSnitches().stream().filter(s -> s.getPos().getCenter().distanceTo(playerPos) < (double)distance).sorted(Comparator.comparing(s -> s.getPos().getCenter().distanceTo(playerPos)));
    }

    private void logToChat(Component msg) {
        SnitchMod.mc.gui.getChat().addMessage((Component)Component.literal((String)"[SnitchMod] ").append(msg));
    }
}

