/*
 * Decompiled with CFR 0.152.
 */
package gjum.minecraft.civ.snitchmod.common.model;

import gjum.minecraft.civ.snitchmod.common.model.Snitch;
import gjum.minecraft.civ.snitchmod.common.model.WorldPos;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemLore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JalistEntry {
    public final long ts;
    @NotNull
    public final WorldPos pos;
    @NotNull
    public final String group;
    @NotNull
    public final Snitch.Type type;
    @NotNull
    public final String name;
    public final long dormantTs;
    public final long cullTs;
    private static final Pattern locationPattern = Pattern.compile("^Location: (?:([A-Za-z][^ ]+),? )?([-0-9]+),? ([-0-9]+),? ([-0-9]+)");
    private static final Pattern groupPattern = Pattern.compile("^Group: ([^ ]+)");
    private static final Pattern lifetimePattern = Pattern.compile("^Will (cull|go dormant) in (?:([0-9]+) ?h(?:our)?s? ?)?(?:([0-9]+) ?m(?:in)?(?:ute)?s? ?)?(?:([0-9]+) ?s(?:ec)?(?:ond)?s?)? *");

    public JalistEntry(long ts, @NotNull WorldPos pos, @NotNull String group, @NotNull Snitch.Type type, @NotNull String name, long dormantTs, long cullTs) {
        this.ts = ts;
        this.pos = pos;
        this.group = group;
        this.type = type;
        this.name = name;
        this.dormantTs = dormantTs;
        this.cullTs = cullTs;
    }

    @Nullable
    public static JalistEntry fromStack(ItemStack stack, @NotNull String server) {
        Snitch.Type type;
        if (stack.getItem() == Items.NOTE_BLOCK) {
            type = Snitch.Type.NOTEBLOCK;
        } else if (stack.getItem() == Items.JUKEBOX) {
            type = Snitch.Type.JUKEBOX;
        } else {
            return null;
        }
        if (stack.get(DataComponents.CUSTOM_NAME) == null) {
            return null;
        }
        if (stack.get(DataComponents.LORE) == null) {
            return null;
        }
        String name = ((Component)stack.get(DataComponents.CUSTOM_NAME)).getString();
        List lores = ((ItemLore)stack.get(DataComponents.LORE)).lines();
        if (lores.size() < 3) {
            return null;
        }
        Matcher locationMatch = locationPattern.matcher(((Component)lores.get(0)).getString());
        if (!locationMatch.matches()) {
            return null;
        }
        Matcher groupMatch = groupPattern.matcher(((Component)lores.get(1)).getString());
        if (!groupMatch.matches()) {
            return null;
        }
        Matcher lifetimeMatch = lifetimePattern.matcher(((Component)lores.get(2)).getString());
        if (!lifetimeMatch.matches()) {
            return null;
        }
        String world = locationMatch.group(1);
        int x = Integer.parseInt(locationMatch.group(2));
        int y = Integer.parseInt(locationMatch.group(3));
        int z = Integer.parseInt(locationMatch.group(4));
        String group = groupMatch.group(1);
        long ts = System.currentTimeMillis();
        String lifetimeType = lifetimeMatch.group(1);
        long h = 0L;
        if (lifetimeMatch.group(2) != null) {
            h = Integer.parseInt(lifetimeMatch.group(2));
        }
        long m = 0L;
        if (lifetimeMatch.group(3) != null) {
            m = Integer.parseInt(lifetimeMatch.group(3));
        }
        long s = 0L;
        if (lifetimeMatch.group(4) != null) {
            s = Integer.parseInt(lifetimeMatch.group(4));
        }
        long lifetimeDurationMs = (h * 3600L + m * 60L + s) * 1000L;
        long dormantTs = 0L;
        long cullTs = 0L;
        if (lifetimeType.equals("go dormant")) {
            dormantTs = ts + lifetimeDurationMs;
        } else if (lifetimeType.equals("cull")) {
            cullTs = ts + lifetimeDurationMs;
        } else {
            System.err.println("Ignoring malformed jalist entry with lifetime type: " + lifetimeType);
            return null;
        }
        WorldPos pos = new WorldPos(server, world, x, y, z);
        return new JalistEntry(ts, pos, group, type, name, dormantTs, cullTs);
    }
}

