/*
 * Decompiled with CFR 0.152.
 */
package gjum.minecraft.civ.snitchmod.common.model;

import gjum.minecraft.civ.snitchmod.common.Utils;
import gjum.minecraft.civ.snitchmod.common.model.WorldPos;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SnitchRename {
    public final long ts;
    @NotNull
    public final WorldPos pos;
    @NotNull
    public final String snitchName;
    @Nullable
    private final String snitchOldName;
    @Nullable
    public final String group;
    @NotNull
    public final UUID clientUuid;
    static Pattern renamePattern = Pattern.compile("^\\s*(?:Set|Changed) snitch name to (.+?)(?: from (.*?))?");
    static Pattern hoverPattern = Pattern.compile("Location: (?:\\(?([^\\n)]+)\\)? )?\\[([-0-9]+),? ([-0-9]+),? ([-0-9]+)\\] *\\nName: ([^\\n]*) *\\nGroup: ([^ ]+).*", 8);

    public SnitchRename(long ts, @NotNull WorldPos pos, @NotNull String snitchName, @Nullable String snitchOldName, @Nullable String group, @NotNull UUID clientUuid) {
        this.ts = ts;
        this.pos = pos;
        this.snitchName = snitchName;
        this.snitchOldName = snitchOldName;
        this.group = group;
        this.clientUuid = clientUuid;
    }

    @Nullable
    public static SnitchRename fromChat(@NotNull Component message, @NotNull String server, @NotNull String world, @NotNull UUID clientUuid) {
        String text = message.getString().replaceAll("\u00a7.", "");
        Matcher textMatch = renamePattern.matcher(text);
        if (!textMatch.matches()) {
            return null;
        }
        String snitchName = textMatch.group(1);
        String snitchOldName = textMatch.group(2);
        HoverEvent hoverEvent = ((Component)message.getSiblings().get(0)).getStyle().getHoverEvent();
        if (hoverEvent == null || hoverEvent.action() != HoverEvent.Action.SHOW_TEXT) {
            return null;
        }
        String hoverText = ((HoverEvent.ShowText)hoverEvent).value().getString().replaceAll("\u00a7.", "");
        Matcher hoverMatch = hoverPattern.matcher(hoverText);
        if (!hoverMatch.matches()) {
            return null;
        }
        world = Utils.nonEmptyOrDefault(hoverMatch.group(1), world);
        int x = Integer.parseInt(hoverMatch.group(2));
        int y = Integer.parseInt(hoverMatch.group(3));
        int z = Integer.parseInt(hoverMatch.group(4));
        String group = hoverMatch.group(6);
        WorldPos pos = new WorldPos(server, world, x, y, z);
        long now = System.currentTimeMillis();
        return new SnitchRename(now, pos, snitchName, snitchOldName, group, clientUuid);
    }
}

