/*
 * Decompiled with CFR 0.152.
 */
package gjum.minecraft.civ.snitchmod.common;

import com.mojang.blaze3d.systems.RenderSystem;
import gjum.minecraft.civ.snitchmod.common.SnitchMod;
import gjum.minecraft.civ.snitchmod.common.Utils;
import gjum.minecraft.civ.snitchmod.common.model.Snitch;
import gjum.minecraft.civ.snitchmod.common.model.SnitchFieldPreview;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_9799;
import net.minecraft.class_9974;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL11;

public class Renderer {
    private static final class_310 mc = class_310.method_1551();
    private static final Utils.Color BLACK = new Utils.Color(0x333333);
    private static final Utils.Color WHITE = new Utils.Color(0xEEEEEE);
    private static final Utils.Color RED = new Utils.Color(15614038);
    private static final Utils.Color GREEN = new Utils.Color(2673746);
    private static final Utils.Color BLUE = new Utils.Color(45823);
    private static final Utils.Color YELLOW = new Utils.Color(15652928);
    private static final Utils.Color ORANGE = new Utils.Color(15630656);
    private static final Utils.Color PINK = new Utils.Color(0xFC66CC);
    private static class_4587 eventPoseStack = null;

    public static void renderOverlays(class_4587 poseStack) {
        eventPoseStack = poseStack;
        if (Renderer.mc.field_1724 == null) {
            return;
        }
        if (Renderer.mc.field_1687 == null) {
            return;
        }
        if (Renderer.mc.field_1690.field_1842) {
            return;
        }
        class_243 camPos = Renderer.mc.field_1773.method_19418().method_19326();
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.mul((Matrix4fc)eventPoseStack.method_23760().method_23761());
        modelViewStack.translate((float)(-camPos.field_1352), (float)(-camPos.field_1351), (float)(-camPos.field_1350));
        if (SnitchMod.getMod().rangeOverlayVisible) {
            int fieldDist = 260;
            SnitchMod.getMod().streamNearbySnitches(Renderer.mc.field_1724.method_19538(), fieldDist).filter(s -> !s.wasBroken()).limit(100L).forEach(Renderer::renderSnitch);
        }
        if (SnitchMod.getMod().placementHelperVisible) {
            int placeHelperDist = 50;
            SnitchMod.getMod().streamNearbySnitches(Renderer.mc.field_1724.method_19538(), placeHelperDist).filter(Snitch::isAlive).limit(10L).forEach(Renderer::renderPlacementHelper);
        }
        if (SnitchMod.getMod().snitchFieldToPreview != null) {
            Renderer.renderSnitchFieldPreview(SnitchMod.getMod().snitchFieldToPreview);
        }
        RenderSystem.lineWidth((float)1.0f);
        modelViewStack.popMatrix();
        class_4597.class_4598 buffers = class_310.method_1551().method_22940().method_23000();
        buffers.method_22993();
        eventPoseStack = null;
    }

    private static void renderSnitchFieldPreview(SnitchFieldPreview preview) {
        Utils.Color color = PINK;
        float boxAlpha = 0.2f;
        float lineAlpha = 1.0f;
        float lineWidth = 2.0f;
        int blockHlDist = 64;
        class_238 range = preview.field().getRangeAABB();
        boolean playerInRange = range.method_1006(Renderer.mc.field_1724.method_19538());
        class_238 rangeBox = playerInRange ? range.method_1014(-0.01) : range.method_1014(0.01);
        try (RenderBufferGuard ignored = RenderBufferGuard.open(true, true, false);){
            Renderer.renderFilledBox(rangeBox, color, 0.2f);
            Renderer.renderBoxOutline(rangeBox, color, 1.0f, 2.0f);
            Renderer.renderBoxGuides(rangeBox, color, 1.0f, 2.0f);
        }
        if (preview.field().pos.method_10262((class_2382)Renderer.mc.field_1724.method_24515()) < 4096.0) {
            ignored = RenderBufferGuard.open(false, false, false);
            try {
                class_238 blockBox = new class_238((class_2338)preview.field().pos).method_1014(0.01);
                Renderer.renderBoxOutline(blockBox, color, 1.0f, 2.0f);
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
        }
    }

    private static void renderSnitch(Snitch snitch) {
        class_238 outlineBox;
        class_238 range = snitch.getRangeAABB();
        boolean playerInRange = range.method_1006(Renderer.mc.field_1724.method_19538());
        class_238 rangeBox = playerInRange ? range.method_1014(-0.01) : range.method_1014(0.01);
        class_238 class_2383 = outlineBox = playerInRange ? range.method_1014(-0.01) : range.method_1014(0.01);
        if (playerInRange) {
            snitch.maybeRefreshed = true;
        }
        long now = System.currentTimeMillis();
        long snitchTimer = snitch.getType() != null ? snitch.getType().timer : Snitch.Type.NOTEBLOCK.timer;
        static enum SnitchLiveliness {
            BROKEN(RED),
            GONE(RED),
            LONG_TIME_NOT_SEEN(RED),
            CULLED(RED),
            WILL_CULL(ORANGE),
            WILL_CULL_MAYBE_REFRESHED(GREEN),
            DORMANT_NOW(ORANGE),
            DORMANT_NOW_MAYBE_REFRESHED(GREEN),
            DORMANT_SOON(ORANGE),
            DORMANT_SOON_MAYBE_REFRESHED(GREEN),
            DORMANT_SOONISH(YELLOW),
            DORMANT_SOONISH_MAYBE_REFRESHED(GREEN),
            DORMANT_EVENTUALLY(GREEN);

            private final Utils.Color color;

            private SnitchLiveliness(Utils.Color color) {
                this.color = color;
            }
        }
        SnitchLiveliness snitchLiveliness = SnitchLiveliness.DORMANT_EVENTUALLY;
        if (snitch.wasBroken()) {
            snitchLiveliness = SnitchLiveliness.BROKEN;
        } else if (snitch.isGone()) {
            snitchLiveliness = SnitchLiveliness.GONE;
        } else if (snitch.getLastSeenTs() != 0L && now - snitch.getLastSeenTs() > snitchTimer) {
            snitchLiveliness = SnitchLiveliness.LONG_TIME_NOT_SEEN;
        } else if (snitch.hasCullTs() && snitch.getCullTs() < now) {
            snitchLiveliness = SnitchLiveliness.CULLED;
        } else if (snitch.hasCullTs() && snitch.getCullTs() > now) {
            snitchLiveliness = snitch.maybeRefreshed ? SnitchLiveliness.WILL_CULL_MAYBE_REFRESHED : SnitchLiveliness.WILL_CULL;
        } else if (snitch.hasDormantTs() && snitch.getDormantTs() < now) {
            snitchLiveliness = snitch.maybeRefreshed ? SnitchLiveliness.DORMANT_NOW_MAYBE_REFRESHED : SnitchLiveliness.DORMANT_NOW;
        } else if (snitch.hasDormantTs() && snitch.getDormantTs() > now) {
            long goodThreshold = 604800000L;
            long badThreshold = 259200000L;
            long delta = snitch.getDormantTs() - now;
            if (delta < 604800000L) {
                snitchLiveliness = delta >= 259200000L ? (snitch.maybeRefreshed ? SnitchLiveliness.DORMANT_SOONISH_MAYBE_REFRESHED : SnitchLiveliness.DORMANT_SOONISH) : (snitch.maybeRefreshed ? SnitchLiveliness.DORMANT_SOON_MAYBE_REFRESHED : SnitchLiveliness.DORMANT_SOON);
            }
        }
        float boxAlpha = 0.2f;
        float lineAlpha = 1.0f;
        if (snitch.isGone()) {
            boxAlpha = 0.0f;
            lineAlpha = 0.5f;
        }
        float lineWidth = 2.0f;
        try (RenderBufferGuard ignored = RenderBufferGuard.open(true, true, false);){
            Renderer.renderFilledBox(rangeBox, snitchLiveliness.color, boxAlpha);
            if (!snitch.isGone()) {
                Renderer.renderBoxOutline(outlineBox, snitchLiveliness.color, lineAlpha, 2.0f);
            }
        }
        int blockHlDist = 64;
        if (snitch.pos.method_10262((class_2382)Renderer.mc.field_1724.method_24515()) < 4096.0) {
            try (RenderBufferGuard ignored = RenderBufferGuard.open(false, false, false);){
                class_238 blockBox = new class_238((class_2338)snitch.pos).method_1014(0.01);
                Utils.Color boxOutlineColor = snitchLiveliness.color;
                if (SnitchMod.getMod().snitchFieldToPreview != null && SnitchMod.getMod().snitchFieldToPreview.source().equals(snitch)) {
                    boxOutlineColor = PINK;
                }
                Renderer.renderBoxOutline(blockBox, boxOutlineColor, lineAlpha, 2.0f);
                Utils.Color boxFillColor = snitch.isGone() ? BLACK : snitchLiveliness.color;
                Renderer.renderFilledBox(blockBox, boxFillColor, boxAlpha);
            }
        }
        record ColoredComponent(class_2561 text, Utils.Color color) {
        }
        ArrayList<ColoredComponent> linesToRender = new ArrayList<ColoredComponent>(3);
        boolean playerLookingAtSnitch = Utils.playerIsLookingAtSnitch(Renderer.mc.field_1724, snitch);
        class_243 eyePosition = new class_243(Renderer.mc.field_1724.method_19538().field_1352, Renderer.mc.field_1724.method_19538().field_1351 + 1.0, Renderer.mc.field_1724.method_19538().field_1350);
        if ((!snitch.isGone() && playerInRange || playerLookingAtSnitch) && (eyePosition.field_1351 != (double)snitch.pos.method_10264() || eyePosition.method_1022(snitch.pos.method_46558()) > 3.0)) {
            String group;
            String name = snitch.getName();
            if (name != null && !name.isEmpty()) {
                linesToRender.add(new ColoredComponent((class_2561)class_2561.method_43470((String)name), WHITE));
            }
            if ((group = snitch.getGroup()) != null) {
                linesToRender.add(new ColoredComponent((class_2561)class_2561.method_43470((String)String.format("[%s]", group)), WHITE));
            }
            String lastSeenText = null;
            if (snitch.getLastSeenTs() != 0L) {
                lastSeenText = String.format("last seen %s", Renderer.timestampRelativeText(snitch.getLastSeenTs()));
            }
            String maxSnitchTimerText = "";
            if (playerLookingAtSnitch) {
                maxSnitchTimerText = String.format(" / %s", Renderer.durationToText(snitchTimer));
            }
            Object livelinessText = null;
            switch (snitchLiveliness.ordinal()) {
                case 0: {
                    livelinessText = "broken " + Renderer.timestampRelativeText(snitch.getBrokenTs());
                    break;
                }
                case 1: {
                    livelinessText = "gone " + Renderer.timestampRelativeText(snitch.getGoneTs());
                    break;
                }
                case 2: {
                    livelinessText = lastSeenText;
                    break;
                }
                case 3: {
                    livelinessText = "culled " + Renderer.timestampRelativeText(snitch.getCullTs());
                    break;
                }
                case 4: 
                case 5: {
                    livelinessText = String.format("culls %s%s", Renderer.timestampRelativeText(snitch.getCullTs()), maxSnitchTimerText);
                    break;
                }
                case 6: 
                case 7: {
                    livelinessText = "deactivated " + Renderer.timestampRelativeText(snitch.getDormantTs());
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    if (!snitch.hasDormantTs()) break;
                    livelinessText = String.format("deactivates %s%s", Renderer.timestampRelativeText(snitch.getDormantTs()), maxSnitchTimerText);
                }
            }
            if (livelinessText != null) {
                if (snitch.maybeRefreshed) {
                    switch (snitchLiveliness.ordinal()) {
                        case 5: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 12: {
                            livelinessText = (String)livelinessText + " (refreshed?)";
                            break;
                        }
                    }
                }
                linesToRender.add(new ColoredComponent((class_2561)class_2561.method_43470((String)livelinessText), snitchLiveliness.color));
            }
            if (playerLookingAtSnitch) {
                linesToRender.add(new ColoredComponent((class_2561)class_2561.method_43470((String)String.format("%d %d %d", snitch.getPos().method_10263(), snitch.getPos().method_10264(), snitch.getPos().method_10260())), WHITE));
                if (snitch.getType() != null) {
                    linesToRender.add(new ColoredComponent((class_2561)class_2561.method_43470((String)StringUtils.capitalize((String)snitch.getType().toString().replaceAll("_", ""))), WHITE));
                }
                if (lastSeenText != null && snitchLiveliness != SnitchLiveliness.LONG_TIME_NOT_SEEN) {
                    linesToRender.add(new ColoredComponent((class_2561)class_2561.method_43470((String)lastSeenText), WHITE));
                }
            }
        }
        class_243 center = snitch.pos.method_46558();
        int offset = -1;
        for (ColoredComponent line : linesToRender) {
            Renderer.renderTextFacingCamera(line.text, center, offset, 1.0f, line.color.hex);
            ++offset;
        }
    }

    private static void renderPlacementHelper(Snitch snitch) {
        boolean playerInRange = snitch.getRangeAABB().method_1006(Renderer.mc.field_1724.method_19538());
        if (playerInRange) {
            return;
        }
        class_238 helperBox = new class_238((class_2338)snitch.pos).method_1014(22.3);
        try (RenderBufferGuard ignored = RenderBufferGuard.open(true, true, false);){
            Renderer.renderFilledBox(helperBox, BLUE, 0.2f);
        }
    }

    private static void renderBoxOutline(class_238 box, Utils.Color color, float alpha, float lineWidth) {
        try (RenderBufferGuard guard = RenderBufferGuard.open();){
            RenderSystem.lineWidth((float)lineWidth);
            class_4588 vertexConsumer = guard.bufferSource.getBuffer(class_1921.method_49043((double)lineWidth));
            class_9974.method_62292((class_4587)eventPoseStack, (class_4588)vertexConsumer, (double)box.field_1323, (double)box.field_1322, (double)box.field_1321, (double)box.field_1320, (double)box.field_1325, (double)box.field_1324, (float)color.r, (float)color.g, (float)color.b, (float)alpha);
        }
    }

    private static void renderFilledBox(class_238 box, Utils.Color color, float alpha) {
        try (RenderBufferGuard guard = RenderBufferGuard.open();){
            class_4588 vertexConsumer = guard.bufferSource.getBuffer(class_1921.method_49042());
            float minX = (float)box.field_1323;
            float minY = (float)box.field_1322;
            float minZ = (float)box.field_1321;
            float maxX = (float)box.field_1320;
            float maxY = (float)box.field_1325;
            float maxZ = (float)box.field_1324;
            for (class_2350 direction : class_2350.values()) {
                class_9974.method_62297((class_4587)eventPoseStack, (class_4588)vertexConsumer, (class_2350)direction, (float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, (float)color.r, (float)color.g, (float)color.b, (float)alpha);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderBoxGuides(class_238 box, Utils.Color color, float a, float lineWidth) {
        boolean initialLineSmooth = GL11.glIsEnabled((int)2848);
        RenderSystem.lineWidth((float)lineWidth);
        float r = color.r;
        float g = color.g;
        float b = color.b;
        class_243 center = box.method_1005();
        float radius = (float)(box.field_1320 - center.field_1352);
        try (RenderBufferGuard guard = RenderBufferGuard.open();){
            class_4587 poseStack = new class_4587();
            class_4587.class_4665 pose = poseStack.method_23760();
            GL11.glEnable((int)2848);
            class_4588 vertexConsumer = guard.bufferSource.getBuffer(class_1921.method_49043((double)lineWidth));
            vertexConsumer.method_56824(pose, (float)center.field_1352 + 1.0f, (float)center.field_1351, (float)center.field_1350).method_22915(r, g, b, a).method_22914(1.0f, 0.0f, 0.0f);
            vertexConsumer.method_56824(pose, (float)center.field_1352 + radius, (float)center.field_1351, (float)center.field_1350).method_22915(r, g, b, a).method_22914(1.0f, 0.0f, 0.0f);
            vertexConsumer.method_56824(pose, (float)center.field_1352 - 1.0f, (float)center.field_1351, (float)center.field_1350).method_22915(r, g, b, a).method_22914(-1.0f, 0.0f, 0.0f);
            vertexConsumer.method_56824(pose, (float)center.field_1352 - radius, (float)center.field_1351, (float)center.field_1350).method_22915(r, g, b, a).method_22914(-1.0f, 0.0f, 0.0f);
            vertexConsumer.method_56824(pose, (float)center.field_1352, (float)center.field_1351 + 1.0f, (float)center.field_1350).method_22915(r, g, b, a).method_22914(0.0f, 1.0f, 0.0f);
            vertexConsumer.method_56824(pose, (float)center.field_1352, (float)center.field_1351 + radius, (float)center.field_1350).method_22915(r, g, b, a).method_22914(1.0f, 0.0f, 0.0f);
            vertexConsumer.method_56824(pose, (float)center.field_1352, (float)center.field_1351 - 1.0f, (float)center.field_1350).method_22915(r, g, b, a).method_22914(0.0f, -1.0f, 0.0f);
            vertexConsumer.method_56824(pose, (float)center.field_1352, (float)center.field_1351 - radius, (float)center.field_1350).method_22915(r, g, b, a).method_22914(-1.0f, 0.0f, 0.0f);
            vertexConsumer.method_56824(pose, (float)center.field_1352, (float)center.field_1351, (float)center.field_1350 + 1.0f).method_22915(r, g, b, a).method_22914(0.0f, 0.0f, 1.0f);
            vertexConsumer.method_56824(pose, (float)center.field_1352, (float)center.field_1351, (float)center.field_1350 + radius).method_22915(r, g, b, a).method_22914(0.0f, 0.0f, 1.0f);
            vertexConsumer.method_56824(pose, (float)center.field_1352, (float)center.field_1351, (float)center.field_1350 - 1.0f).method_22915(r, g, b, a).method_22914(0.0f, 0.0f, -1.0f);
            vertexConsumer.method_56824(pose, (float)center.field_1352, (float)center.field_1351, (float)center.field_1350 - radius).method_22915(r, g, b, a).method_22914(0.0f, 0.0f, -1.0f);
        }
        finally {
            if (!initialLineSmooth) {
                GL11.glDisable((int)2848);
            }
        }
    }

    private static void renderTextFacingCamera(class_2561 text, class_243 pos, float offset, float scale, int colorAlphaHex) {
        float w = Renderer.mc.field_1772.method_27525((class_5348)text);
        float x = -w / 2.0f;
        float f = -(0.5f - offset);
        Objects.requireNonNull(Renderer.mc.field_1772);
        float y = f * (float)(9 + 2);
        boolean shadow = false;
        scale = (float)((double)scale * ((double)0.005f * (Renderer.mc.field_1724.method_19538().method_1022(pos) / 2.4)));
        scale = Math.clamp(scale, 0.015f, 0.15f);
        Matrix4f matrix = new Matrix4f((Matrix4fc)eventPoseStack.method_23760().method_23761());
        matrix.scale(scale, -scale, 1.0f);
        float bgOpacity = class_310.method_1551().field_1690.method_19343(0.25f);
        int bgColor = (int)(bgOpacity * 255.0f) << 24;
        int flags = 0;
        try (RenderBufferGuard guard = RenderBufferGuard.open(false, false, false);){
            Renderer.mc.field_1772.method_27522(text, x, y, colorAlphaHex, shadow, matrix, (class_4597)guard.bufferSource, class_327.class_6415.field_33994, bgColor, flags);
        }
    }

    @NotNull
    private static String timestampRelativeText(long ts) {
        long now = System.currentTimeMillis();
        if (ts < now) {
            return Renderer.durationToText(now - ts) + " ago";
        }
        return "in " + Renderer.durationToText(ts - now);
    }

    @NotNull
    private static String durationToText(long ms) {
        if (ms < 0L) {
            ms = -ms;
        }
        if (ms < 1000L) {
            return ms + "ms";
        }
        long sec = ms / 1000L;
        if (sec < 100L) {
            return sec + "s";
        }
        long min = sec / 60L;
        if (min < 100L) {
            return min + "min";
        }
        long hours = min / 60L;
        if (hours < 48L) {
            return hours + "h";
        }
        long days = hours / 24L;
        return days + " days";
    }

    public static class RenderBufferGuard
    implements AutoCloseable {
        public class_4597.class_4598 bufferSource;
        private static class_9799 byteBufferBuilder = new class_9799(262144);
        private static class_4597.class_4598 sBufferSource = null;
        private static RenderBufferGuard current = null;
        private RenderBufferGuard parent = current;
        private int referenceCount = 1;
        private boolean enableDepthTest;
        private boolean enableDepthMask;
        private boolean enableCullFace;
        private boolean initialDepthTestValue;
        private boolean initialDepthMask;
        private boolean initialCullFace;

        private RenderBufferGuard(boolean enableDepthTest, boolean enableDepthMask, boolean enableCullFace) {
            current = this;
            this.enableDepthTest = enableDepthTest;
            this.enableDepthMask = enableDepthMask;
            this.enableCullFace = enableCullFace;
            this.initialDepthTestValue = GL11.glIsEnabled((int)2929);
            this.initialDepthMask = GL11.glGetBoolean((int)2930);
            this.initialCullFace = GL11.glIsEnabled((int)2884);
            if (this.parent != null) {
                sBufferSource.method_22993();
                byteBufferBuilder.method_60809();
            } else {
                sBufferSource = class_4597.method_22991((class_9799)byteBufferBuilder);
            }
            this.bufferSource = sBufferSource;
            if (enableDepthTest) {
                GL11.glEnable((int)2929);
            } else {
                GL11.glDisable((int)2929);
            }
            GL11.glDepthMask((boolean)enableDepthMask);
            if (enableCullFace) {
                GL11.glEnable((int)2884);
            } else {
                GL11.glDisable((int)2884);
            }
        }

        public static RenderBufferGuard open(boolean enableDepthTest, boolean enableDepthMask, boolean enableCullFace) {
            if (current != null && RenderBufferGuard.current.enableDepthTest == enableDepthTest && RenderBufferGuard.current.enableDepthMask == enableDepthMask && RenderBufferGuard.current.enableCullFace == enableCullFace) {
                ++RenderBufferGuard.current.referenceCount;
                return current;
            }
            return new RenderBufferGuard(enableDepthTest, enableDepthMask, enableCullFace);
        }

        public static RenderBufferGuard open() {
            if (current != null) {
                ++RenderBufferGuard.current.referenceCount;
                return current;
            }
            return new RenderBufferGuard(GL11.glIsEnabled((int)2929), GL11.glGetBoolean((int)2930), GL11.glIsEnabled((int)2884));
        }

        @Override
        public void close() {
            if (this.referenceCount > 1) {
                --this.referenceCount;
                return;
            }
            current = this.parent;
            try {
                this.bufferSource.method_22993();
            }
            finally {
                if (this.initialDepthTestValue) {
                    GL11.glEnable((int)2929);
                } else {
                    GL11.glDisable((int)2929);
                }
                GL11.glDepthMask((boolean)this.initialDepthMask);
                if (this.initialCullFace) {
                    GL11.glEnable((int)2884);
                } else {
                    GL11.glDisable((int)2884);
                }
                if (this.parent == null) {
                    sBufferSource = null;
                }
            }
        }
    }
}

