/*
 * Decompiled with CFR 0.152.
 */
package gjum.minecraft.civ.snitchmod.common;

import gjum.minecraft.civ.snitchmod.common.Renderer;
import gjum.minecraft.civ.snitchmod.common.SnitchesStore;
import gjum.minecraft.civ.snitchmod.common.Utils;
import gjum.minecraft.civ.snitchmod.common.model.Direction;
import gjum.minecraft.civ.snitchmod.common.model.JalistEntry;
import gjum.minecraft.civ.snitchmod.common.model.Snitch;
import gjum.minecraft.civ.snitchmod.common.model.SnitchAlert;
import gjum.minecraft.civ.snitchmod.common.model.SnitchCreatedChatParser;
import gjum.minecraft.civ.snitchmod.common.model.SnitchFieldPreview;
import gjum.minecraft.civ.snitchmod.common.model.SnitchRename;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_4587;
import net.minecraft.class_642;
import org.jetbrains.annotations.Nullable;

public abstract class SnitchMod {
    private static final class_310 mc = class_310.method_1551();
    protected static final class_304 openGuiKey = new class_304("key.snitchmod.openGui", class_3675.class_307.field_1668, 76, "category.snitchmod");
    protected static final class_304 toggleOverlayKey = new class_304("key.snitchmod.toggleOverlay", class_3675.class_307.field_1668, 79, "category.snitchmod");
    protected static final class_304 togglePlacementKey = new class_304("key.snitchmod.togglePlacement", class_3675.class_307.field_1668, 80, "category.snitchmod");
    protected static final class_304 previewSnitchFieldKey = new class_304("key.snitchmod.togglePreviewSnitchFieldKey", class_3675.class_307.field_1668, 78, "category.snitchmod");
    protected static final class_304 toggleSnitchGoneStatusKey = new class_304("key.snitchmod.toggleSnitchGoneStatusKey", class_3675.class_307.field_1668, 261, "category.snitchmod");
    protected static final class_304 toggleSnitchFieldRenderKey = new class_304("key.snitchmod.toggleSnitchFieldRenderKey", class_3675.class_307.field_1668, 84, "category.snitchmod");
    private static SnitchMod INSTANCE;
    public boolean rangeOverlayVisible = false;
    public boolean placementHelperVisible = false;
    @Nullable
    public SnitchFieldPreview snitchFieldToPreview = null;
    @Nullable
    public Snitch lastBrokenSnitch = null;
    @Nullable
    private SnitchesStore store;

    public static SnitchMod getMod() {
        return INSTANCE;
    }

    public SnitchMod() {
        if (INSTANCE != null) {
            throw new IllegalStateException("Constructor called twice");
        }
        INSTANCE = this;
    }

    @Nullable
    public String getCurrentServer() {
        class_642 currentServer = mc.method_1558();
        if (currentServer == null) {
            return null;
        }
        return currentServer.field_3761;
    }

    public String getCurrentWorld() {
        String dimension;
        if (SnitchMod.mc.field_1687 == null) {
            return null;
        }
        return switch (dimension = SnitchMod.mc.field_1687.method_27983().method_29177().method_12832()) {
            case "overworld" -> "world";
            case "the_nether" -> "world_nether";
            case "the_end" -> "world_the_end";
            default -> dimension;
        };
    }

    public UUID getClientUuid() {
        if (SnitchMod.mc.field_1724 == null) {
            return null;
        }
        return SnitchMod.mc.field_1724.method_5667();
    }

    @Nullable
    public SnitchesStore getStore() {
        String server = this.getCurrentServer();
        if (this.store != null && !this.store.server.equals(server)) {
            this.store.close();
            this.store = null;
        }
        if (this.store == null && server != null) {
            this.store = new SnitchesStore(server);
        }
        return this.store;
    }

    public void handleConnectedToServer() {
        this.getStore();
    }

    public void handleDisconnectedFromServer() {
        if (this.store != null) {
            this.store.close();
        }
        this.store = null;
    }

    public void handleTick() {
        while (openGuiKey.method_1436()) {
            this.store.close();
            this.store = null;
            this.getStore();
            this.logToChat((class_2561)class_2561.method_43470((String)"Reloaded the database"));
        }
        while (toggleSnitchGoneStatusKey.method_1436() && SnitchMod.getMod().rangeOverlayVisible) {
            Optional<Snitch> optSnitch = SnitchMod.getMod().streamNearbySnitches(SnitchMod.mc.field_1724.method_19538(), 260).filter(s -> !s.wasBroken()).limit(100L).filter(s -> Utils.playerIsLookingAtSnitch(SnitchMod.mc.field_1724, s)).findFirst();
            if (optSnitch.isEmpty()) {
                this.logToChat((class_2561)class_2561.method_43470((String)"Error: you must be looking at a snitch to change its status"));
                break;
            }
            Snitch snitch = optSnitch.get();
            String formattedSnitch = String.format("\"%s\" on [%s] at %d %d %d", snitch.getName() != null ? snitch.getName() : "", snitch.getGroup(), snitch.getPos().method_10263(), snitch.getPos().method_10264(), snitch.getPos().method_10260());
            if (snitch.isGone()) {
                this.store.updateSnitchNoLongerGone(snitch.pos);
                this.logToChat((class_2561)class_2561.method_43470((String)String.format("Marked snitch %s as alive", formattedSnitch)));
                continue;
            }
            this.store.updateSnitchGone(snitch.pos);
            this.logToChat((class_2561)class_2561.method_43470((String)String.format("Marked snitch %s as gone", formattedSnitch)));
        }
        while (toggleOverlayKey.method_1436()) {
            this.rangeOverlayVisible = !this.rangeOverlayVisible;
            this.logToChat((class_2561)class_2561.method_43470((String)("Range overlay " + (this.rangeOverlayVisible ? "visible" : "hidden"))));
        }
        while (togglePlacementKey.method_1436()) {
            boolean bl = this.placementHelperVisible = !this.placementHelperVisible;
            if (this.placementHelperVisible) {
                this.snitchFieldToPreview = null;
            }
            this.logToChat((class_2561)class_2561.method_43470((String)("Placement helper " + (this.placementHelperVisible ? "visible" : "hidden"))));
        }
        while (previewSnitchFieldKey.method_1436()) {
            Optional<Snitch> optNearestSnitch = this.streamNearbySnitches(SnitchMod.mc.field_1724.method_19538(), 46).filter(Snitch::isAlive).findFirst();
            if (optNearestSnitch.isEmpty()) {
                this.snitchFieldToPreview = null;
                this.logToChat((class_2561)class_2561.method_43470((String)"No nearby alive snitches to base a field preview on"));
                break;
            }
            Snitch nearestSnitch = optNearestSnitch.get();
            if (this.placementHelperVisible) {
                this.placementHelperVisible = false;
            }
            SnitchFieldPreview newSnitchFieldToPreview = new SnitchFieldPreview(nearestSnitch, Direction.ofPlayer(SnitchMod.mc.field_1724));
            if (this.snitchFieldToPreview != null && newSnitchFieldToPreview.equals(this.snitchFieldToPreview)) {
                this.logToChat((class_2561)class_2561.method_43470((String)"Turning off the snitch field preview"));
                this.snitchFieldToPreview = null;
                break;
            }
            this.snitchFieldToPreview = newSnitchFieldToPreview;
            this.logToChat((class_2561)class_2561.method_43470((String)"Showing a snitch field preview in the direction you're looking"));
        }
    }

    public boolean handleChat(class_2561 message) {
        this.getStore();
        if (this.store == null) {
            return false;
        }
        SnitchAlert snitchAlert = SnitchAlert.fromChat(message, this.store.server, this.getCurrentWorld());
        if (snitchAlert != null) {
            this.store.updateSnitchFromAlert(snitchAlert);
            return false;
        }
        SnitchRename snitchRename = SnitchRename.fromChat(message, this.store.server, this.getCurrentWorld(), this.getClientUuid());
        if (snitchRename != null) {
            this.store.updateSnitchFromRename(snitchRename);
            return false;
        }
        Snitch snitchCreated = SnitchCreatedChatParser.fromChat(message, this.store.server, this.getCurrentWorld(), this.getClientUuid());
        if (snitchCreated != null) {
            Snitch alreadyExistingSnitch = this.store.getSnitch(snitchCreated.pos);
            this.store.updateSnitchFromCreation(snitchCreated);
            if (alreadyExistingSnitch != null && alreadyExistingSnitch.getName() != null && !alreadyExistingSnitch.getName().equals("")) {
                SnitchMod.mc.field_1724.field_3944.method_45730(String.format("janameat %d %d %d %s", alreadyExistingSnitch.pos.method_10263(), alreadyExistingSnitch.pos.method_10264(), alreadyExistingSnitch.pos.method_10260(), alreadyExistingSnitch.getName()));
                this.logToChat((class_2561)class_2561.method_43470((String)String.format("Named the replaced snitch \"%s\"", alreadyExistingSnitch.getName())));
            }
            if (this.snitchFieldToPreview != null && this.snitchFieldToPreview.field().pos.equals((Object)snitchCreated.pos)) {
                if (this.placementHelperVisible) {
                    this.placementHelperVisible = false;
                }
                this.snitchFieldToPreview = new SnitchFieldPreview(snitchCreated, this.snitchFieldToPreview.direction());
                this.logToChat((class_2561)class_2561.method_43470((String)"Showing an inferred snitch field preview"));
            }
            return false;
        }
        return false;
    }

    public void handleWindowItems(List<class_1799> stacks) {
        this.getStore();
        if (this.store == null) {
            return;
        }
        ArrayList<JalistEntry> jalistEntries = new ArrayList<JalistEntry>(stacks.size());
        for (int i = 0; i < stacks.size(); ++i) {
            class_1799 stack = stacks.get(i);
            try {
                JalistEntry jalistEntry = JalistEntry.fromStack(stack, this.store.server);
                if (jalistEntry == null) continue;
                jalistEntries.add(jalistEntry);
                continue;
            }
            catch (Throwable e) {
                System.err.println("Failed parsing jalist stack " + i + " " + String.valueOf(stack));
                e.printStackTrace();
                this.logToChat((class_2561)class_2561.method_43470((String)("Failed reading snitch " + i + " on JAList page")));
            }
        }
        this.store.updateSnitchesFromJalist(jalistEntries);
        if (jalistEntries.size() > 0) {
            this.logToChat((class_2561)class_2561.method_43470((String)("Found " + jalistEntries.size() + " snitches on JAList page")));
        }
    }

    public void handleRenderBlockOverlay(class_4587 poseStack) {
        Renderer.renderOverlays(poseStack);
    }

    public Stream<Snitch> streamNearbySnitches(class_243 playerPos, int distance) {
        this.getStore();
        if (this.store == null) {
            return Stream.empty();
        }
        return this.store.getAllSnitches().stream().filter(s -> s.getPos().method_46558().method_1022(playerPos) < (double)distance).sorted(Comparator.comparing(s -> s.getPos().method_46558().method_1022(playerPos)));
    }

    private void logToChat(class_2561 msg) {
        SnitchMod.mc.field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)"[SnitchMod] ").method_10852(msg));
    }
}

