/*
 * Decompiled with CFR 0.152.
 */
package gjum.minecraft.civ.snitchmod.common.model;

import gjum.minecraft.civ.snitchmod.common.model.Snitch;
import gjum.minecraft.civ.snitchmod.common.model.WorldPos;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JalistEntry {
    public final long ts;
    @NotNull
    public final WorldPos pos;
    @NotNull
    public final String group;
    @NotNull
    public final Snitch.Type type;
    @NotNull
    public final String name;
    public final long dormantTs;
    public final long cullTs;
    private static final Pattern locationPattern = Pattern.compile("^Location: (?:([A-Za-z][^ ]+),? )?([-0-9]+),? ([-0-9]+),? ([-0-9]+)");
    private static final Pattern groupPattern = Pattern.compile("^Group: ([^ ]+)");
    private static final Pattern lifetimePattern = Pattern.compile("^Will (cull|go dormant) in (?:([0-9]+) ?h(?:our)?s? ?)?(?:([0-9]+) ?m(?:in)?(?:ute)?s? ?)?(?:([0-9]+) ?s(?:ec)?(?:ond)?s?)? *");

    public JalistEntry(long ts, @NotNull WorldPos pos, @NotNull String group, @NotNull Snitch.Type type, @NotNull String name, long dormantTs, long cullTs) {
        this.ts = ts;
        this.pos = pos;
        this.group = group;
        this.type = type;
        this.name = name;
        this.dormantTs = dormantTs;
        this.cullTs = cullTs;
    }

    @Nullable
    public static JalistEntry fromStack(class_1799 stack, @NotNull String server) {
        Snitch.Type type;
        if (stack.method_7909() == class_1802.field_8643) {
            type = Snitch.Type.NOTEBLOCK;
        } else if (stack.method_7909() == class_1802.field_8565) {
            type = Snitch.Type.JUKEBOX;
        } else {
            return null;
        }
        if (stack.method_58694(class_9334.field_49631) == null) {
            return null;
        }
        if (stack.method_58694(class_9334.field_49632) == null) {
            return null;
        }
        String name = ((class_2561)stack.method_58694(class_9334.field_49631)).getString();
        List lores = ((class_9290)stack.method_58694(class_9334.field_49632)).comp_2400();
        if (lores.size() < 3) {
            return null;
        }
        Matcher locationMatch = locationPattern.matcher(((class_2561)lores.get(0)).getString());
        if (!locationMatch.matches()) {
            return null;
        }
        Matcher groupMatch = groupPattern.matcher(((class_2561)lores.get(1)).getString());
        if (!groupMatch.matches()) {
            return null;
        }
        Matcher lifetimeMatch = lifetimePattern.matcher(((class_2561)lores.get(2)).getString());
        if (!lifetimeMatch.matches()) {
            return null;
        }
        String world = locationMatch.group(1);
        int x = Integer.parseInt(locationMatch.group(2));
        int y = Integer.parseInt(locationMatch.group(3));
        int z = Integer.parseInt(locationMatch.group(4));
        String group = groupMatch.group(1);
        long ts = System.currentTimeMillis();
        String lifetimeType = lifetimeMatch.group(1);
        long h = 0L;
        if (lifetimeMatch.group(2) != null) {
            h = Integer.parseInt(lifetimeMatch.group(2));
        }
        long m = 0L;
        if (lifetimeMatch.group(3) != null) {
            m = Integer.parseInt(lifetimeMatch.group(3));
        }
        long s = 0L;
        if (lifetimeMatch.group(4) != null) {
            s = Integer.parseInt(lifetimeMatch.group(4));
        }
        long lifetimeDurationMs = (h * 3600L + m * 60L + s) * 1000L;
        long dormantTs = 0L;
        long cullTs = 0L;
        if (lifetimeType.equals("go dormant")) {
            dormantTs = ts + lifetimeDurationMs;
        } else if (lifetimeType.equals("cull")) {
            cullTs = ts + lifetimeDurationMs;
        } else {
            System.err.println("Ignoring malformed jalist entry with lifetime type: " + lifetimeType);
            return null;
        }
        WorldPos pos = new WorldPos(server, world, x, y, z);
        return new JalistEntry(ts, pos, group, type, name, dormantTs, cullTs);
    }
}

