/*
 * Decompiled with CFR 0.152.
 */
package gjum.minecraft.civ.snitchmod.common.model;

import gjum.minecraft.civ.snitchmod.common.model.JalistEntry;
import gjum.minecraft.civ.snitchmod.common.model.SnitchAlert;
import gjum.minecraft.civ.snitchmod.common.model.SnitchBroken;
import gjum.minecraft.civ.snitchmod.common.model.SnitchRename;
import gjum.minecraft.civ.snitchmod.common.model.WorldPos;
import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Snitch {
    private static final String JUKEBOX_DB_REPRESENTATION = "jukebox";
    private static final String NOTEBLOCK_DB_REPRESENTATION = "note_block";
    public boolean maybeRefreshed;
    @NotNull
    public final WorldPos pos;
    @Nullable
    private String group;
    @Nullable
    private Type type;
    @Nullable
    private String name;
    private long dormantTs;
    private long cullTs;
    private long firstSeenTs;
    private long lastSeenTs;
    private long createdTs;
    @Nullable
    private UUID createdByUuid;
    private long renamedTs;
    @Nullable
    private UUID renamedByUuid;
    private long lostJalistAccessTs;
    private long brokenTs;
    private long goneTs;
    @NotNull
    private HashSet<String> tags = new HashSet();
    @Nullable
    private String notes;

    public Snitch(@NotNull WorldPos pos) {
        this.pos = pos;
    }

    public Snitch(@NotNull String server, @NotNull String world, int x, int y, int z, @Nullable String group, @Nullable String rawType, @Nullable String name, long dormantTs, long cullTs, long firstSeenTs, long lastSeenTs, long createdTs, @Nullable String createdByUuid, long renamedTs, @Nullable String renamedByUuid, long lostJalistAccessTs, long brokenTs, long goneTs, @Nullable String tags, @Nullable String notes) {
        this.pos = new WorldPos(server, world, x, y, z);
        this.group = group;
        if (rawType != null) {
            String type;
            switch (type = rawType.trim().toLowerCase()) {
                case "jukebox": 
                case "juke_box": 
                case "juke box": 
                case "logsnitch": {
                    this.type = Type.JUKEBOX;
                    break;
                }
                case "note_block": 
                case "noteblock": 
                case "note block": 
                case "snitch": {
                    this.type = Type.NOTEBLOCK;
                }
            }
        }
        this.name = name;
        this.dormantTs = dormantTs;
        this.cullTs = cullTs;
        this.firstSeenTs = firstSeenTs;
        this.lastSeenTs = lastSeenTs;
        this.createdTs = createdTs;
        if (createdByUuid != null) {
            this.createdByUuid = UUID.fromString(createdByUuid);
        }
        this.renamedTs = renamedTs;
        if (renamedByUuid != null) {
            this.renamedByUuid = UUID.fromString(renamedByUuid);
        }
        this.lostJalistAccessTs = lostJalistAccessTs;
        this.brokenTs = brokenTs;
        this.goneTs = goneTs;
        this.tags.clear();
        if (tags != null && !tags.isEmpty()) {
            this.tags.addAll(Arrays.asList(tags.split("\n")));
        }
        this.notes = notes;
    }

    public void updateFromCreation(String group, @Nullable Type type, UUID createdByUuid) {
        this.group = group;
        this.createdByUuid = createdByUuid;
        this.type = type;
        this.firstSeenTs = this.createdTs = System.currentTimeMillis();
        this.lastSeenTs = this.createdTs;
        if (type != null) {
            this.dormantTs = this.createdTs + type.timer;
        }
    }

    public void updateFromJalist(JalistEntry jalist) {
        this.group = jalist.group;
        this.type = jalist.type;
        this.name = jalist.name;
        this.dormantTs = jalist.dormantTs;
        this.cullTs = jalist.cullTs;
        this.updateSeen(jalist.ts);
        this.lostJalistAccessTs = 0L;
        this.maybeRefreshed = false;
    }

    public void updateFromRename(SnitchRename rename) {
        this.group = rename.group;
        this.name = rename.snitchName;
        this.renamedTs = rename.ts;
        this.renamedByUuid = rename.clientUuid;
        this.updateSeen(rename.ts);
    }

    public void updateFromAlert(SnitchAlert alert) {
        this.group = alert.group;
        this.name = alert.snitchName;
        if (this.dormantTs != 0L && this.dormantTs < alert.ts) {
            this.dormantTs = 0L;
        }
        if (this.cullTs != 0L && this.cullTs < alert.ts) {
            this.cullTs = 0L;
        }
        this.updateSeen(alert.ts);
    }

    public void updateFromBroken(SnitchBroken snitchBroken) {
        this.group = snitchBroken.group;
        this.dormantTs = 0L;
        this.cullTs = 0L;
        this.updateSeen(snitchBroken.ts);
        this.brokenTs = snitchBroken.ts;
        this.goneTs = snitchBroken.ts;
    }

    public void updateGone() {
        this.goneTs = System.currentTimeMillis();
    }

    public void updateNoLongerGone() {
        this.goneTs = 0L;
    }

    private void updateSeen(long ts) {
        if (this.firstSeenTs == 0L || this.firstSeenTs > ts) {
            this.firstSeenTs = ts;
        }
        if (this.lastSeenTs < ts) {
            this.lastSeenTs = ts;
        }
    }

    public WorldPos getPos() {
        return this.pos;
    }

    public class_238 getRangeAABB() {
        return new class_238((class_2338)this.pos).method_1014(11.0);
    }

    @Nullable
    public String getGroup() {
        return this.group;
    }

    @Nullable
    public Type getType() {
        return this.type;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public boolean isAlive() {
        if (this.brokenTs != 0L || this.goneTs != 0L) {
            return false;
        }
        if (this.dormantTs == 0L && this.cullTs == 0L) {
            return true;
        }
        long now = System.currentTimeMillis();
        return !(this.dormantTs != 0L && now >= this.dormantTs || this.cullTs != 0L && now >= this.cullTs);
    }

    public long getDormantTs() {
        return this.dormantTs;
    }

    public boolean hasDormantTs() {
        return this.dormantTs != 0L;
    }

    public long getCullTs() {
        return this.cullTs;
    }

    public boolean hasCullTs() {
        return this.cullTs != 0L;
    }

    public long getFirstSeenTs() {
        return this.firstSeenTs;
    }

    public long getLastSeenTs() {
        return this.lastSeenTs;
    }

    public long getCreatedTs() {
        return this.createdTs;
    }

    public boolean hasCreatedTs() {
        return this.createdTs != 0L;
    }

    @Nullable
    public UUID getCreatedByUuid() {
        return this.createdByUuid;
    }

    public long getRenamedTs() {
        return this.renamedTs;
    }

    public boolean hasRenamedTs() {
        return this.renamedTs != 0L;
    }

    @Nullable
    public UUID getRenamedByUuid() {
        return this.renamedByUuid;
    }

    public long getLostJalistAccessTs() {
        return this.lostJalistAccessTs;
    }

    public boolean haveLostJalistAccess() {
        return this.lostJalistAccessTs != 0L;
    }

    public long getBrokenTs() {
        return this.brokenTs;
    }

    public boolean wasBroken() {
        return this.brokenTs != 0L;
    }

    public long getGoneTs() {
        return this.goneTs;
    }

    public boolean isGone() {
        return this.goneTs != 0L;
    }

    @NotNull
    public HashSet<String> getTags() {
        return this.tags;
    }

    @Nullable
    public String getNotes() {
        return this.notes;
    }

    public static enum Type {
        JUKEBOX(3628800000L, "jukebox"),
        NOTEBLOCK(2419200000L, "note_block");

        public final long timer;
        public final String dbRepresentation;

        private Type(long timer, String dbRepresentation) {
            this.timer = timer;
            this.dbRepresentation = dbRepresentation;
        }

        public String toString() {
            return this.dbRepresentation;
        }
    }
}

