/*
 * Decompiled with CFR 0.152.
 */
package gjum.minecraft.civ.snitchmod.common.model;

import gjum.minecraft.civ.snitchmod.common.Utils;
import gjum.minecraft.civ.snitchmod.common.model.WorldPos;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SnitchAlert {
    public final long ts;
    @NotNull
    public final WorldPos pos;
    @NotNull
    public final String action;
    @NotNull
    public final String accountName;
    @NotNull
    public final String snitchName;
    @Nullable
    public final String group;
    static Pattern alertPattern = Pattern.compile("^(Enter|Login|Logout) +([A-Za-z0-9_]{3,17}) +(.+) +\\[(?:([A-Za-z][^ ]+),? )?([-0-9]+),? ([-0-9]+),? ([-0-9]+)\\].*");
    static Pattern hoverPattern = Pattern.compile("Location: (?:\\(?([^\\n)]+)\\)? )?\\[([-0-9]+),? ([-0-9]+),? ([-0-9]+)\\] *\\n(?:Name: ([^\\n]+)\\n)?Group: ([^ ]+).*", 8);

    public SnitchAlert(long ts, @NotNull WorldPos pos, @NotNull String action, @NotNull String accountName, @NotNull String snitchName, @Nullable String group) {
        this.ts = ts;
        this.pos = pos;
        this.action = action;
        this.accountName = accountName;
        this.snitchName = snitchName;
        this.group = group;
    }

    @Nullable
    public static SnitchAlert fromChat(@NotNull class_2561 message, @NotNull String server, @NotNull String world) {
        String hoverText;
        Matcher hoverMatch;
        String text = message.getString().replaceAll("\u00a7.", "");
        Matcher textMatch = alertPattern.matcher(text);
        if (!textMatch.matches()) {
            return null;
        }
        String action = textMatch.group(1);
        String accountName = textMatch.group(2);
        String snitchName = textMatch.group(3);
        world = Utils.nonEmptyOrDefault(textMatch.group(4), world);
        int x = Integer.parseInt(textMatch.group(5));
        int y = Integer.parseInt(textMatch.group(6));
        int z = Integer.parseInt(textMatch.group(7));
        String group = null;
        class_2568 hoverEvent = ((class_2561)message.method_10855().get(0)).method_10866().method_10969();
        if (hoverEvent != null && hoverEvent.method_10892() == class_2568.class_5247.field_24342 && (hoverMatch = hoverPattern.matcher(hoverText = ((class_2568.class_10613)hoverEvent).comp_3510().getString().replaceAll("\u00a7.", ""))).matches()) {
            world = Utils.nonEmptyOrDefault(hoverMatch.group(1), world);
            group = hoverMatch.group(6);
        }
        long now = System.currentTimeMillis();
        WorldPos pos = new WorldPos(server, world, x, y, z);
        return new SnitchAlert(now, pos, action, accountName, snitchName, group);
    }
}

