/*
 * Decompiled with CFR 0.152.
 */
package gjum.minecraft.civ.snitchmod.common.model;

import gjum.minecraft.civ.snitchmod.common.Utils;
import gjum.minecraft.civ.snitchmod.common.model.Snitch;
import gjum.minecraft.civ.snitchmod.common.model.WorldPos;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class SnitchCreatedChatParser {
    static Pattern createdPattern = Pattern.compile("^Created (\\S+) on group (\\S+) at \\[(?:\\(?([^\\n)]+)\\)? )?([-0-9.]+) ([-0-9.]+) ([-0-9.]+)\\].*");

    public static Snitch fromChat(class_2561 message, String server, String world, @NotNull UUID clientUuid) {
        String text = message.getString().replaceAll("\u00a7.", "");
        Matcher textMatch = createdPattern.matcher(text);
        if (!textMatch.matches()) {
            return null;
        }
        String rawType = textMatch.group(1).trim().toLowerCase();
        Snitch.Type type = null;
        if (rawType.equals("logsnitch")) {
            type = Snitch.Type.JUKEBOX;
        } else if (rawType.equals("snitch")) {
            type = Snitch.Type.NOTEBLOCK;
        }
        String group = textMatch.group(2);
        world = Utils.nonEmptyOrDefault(textMatch.group(3), world);
        int x = Integer.parseInt(textMatch.group(4));
        int y = Integer.parseInt(textMatch.group(5));
        int z = Integer.parseInt(textMatch.group(6));
        Snitch snitch = new Snitch(new WorldPos(server, world, x, y, z));
        snitch.updateFromCreation(group, type, clientUuid);
        return snitch;
    }
}

