/*
 * Decompiled with CFR 0.152.
 */
package com.codex.cant_sleep;

import com.codex.cant_sleep.config.CantSleepConfigController;
import com.codex.cant_sleep.config.CantSleepConfigValues;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;

public final class CantSleepSleepRules {
    private static final class_2561 INSOMNIA_TEXT = class_2561.method_43471((String)"cant_sleep.message.insomnia");
    private static final long TICKS_PER_DAY = 24000L;
    private static final Map<UUID, PlayerNightState> NIGHT_CACHE = new ConcurrentHashMap<UUID, PlayerNightState>();

    private CantSleepSleepRules() {
    }

    public static void register() {
        UseBlockCallback.EVENT.register(CantSleepSleepRules::handleBedUse);
    }

    private static class_1269 handleBedUse(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        if (!(player instanceof class_3222)) {
            return class_1269.field_5811;
        }
        class_3222 serverPlayer = (class_3222)player;
        if (hand != class_1268.field_5808) {
            return class_1269.field_5811;
        }
        if (!(world instanceof class_3218)) {
            return class_1269.field_5811;
        }
        class_3218 serverWorld = (class_3218)world;
        class_2680 state = serverWorld.method_8320(hitResult.method_17777());
        if (!(state.method_26204() instanceof class_2244)) {
            return class_1269.field_5811;
        }
        if (!serverWorld.method_8597().comp_648()) {
            return class_1269.field_5811;
        }
        if (!CantSleepSleepRules.isSleepWindow(serverWorld)) {
            return class_1269.field_5811;
        }
        if (!CantSleepSleepRules.isInsomniaNight(serverPlayer, serverWorld)) {
            return class_1269.field_5811;
        }
        serverPlayer.method_7353(INSOMNIA_TEXT, true);
        return class_1269.field_5814;
    }

    private static boolean isSleepWindow(class_3218 world) {
        return world.method_23886() || world.method_8546();
    }

    private static boolean isInsomniaNight(class_3222 player, class_3218 world) {
        CantSleepConfigValues config = CantSleepConfigController.current();
        double chance = config.insomniaChance();
        if (chance <= 0.0) {
            return false;
        }
        if (chance >= 1.0) {
            return true;
        }
        long dayIndex = world.method_8532() / 24000L;
        PlayerNightState state = NIGHT_CACHE.compute(player.method_5667(), (uuid, existing) -> {
            if (existing != null && existing.dayIndex == dayIndex) {
                return existing;
            }
            boolean insomnia = world.method_8409().method_43058() < chance;
            return new PlayerNightState(dayIndex, insomnia);
        });
        return state.insomnia;
    }

    private record PlayerNightState(long dayIndex, boolean insomnia) {
    }
}

