/*
 * Decompiled with CFR 0.152.
 */
package com.codex.cant_sleep.config;

import com.codex.cant_sleep.config.CantSleepConfigValues;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CantSleepConfigStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"cant_sleep-config");
    private static final double MIN_CHANCE = 0.0;
    private static final double MAX_CHANCE = 1.0;

    private CantSleepConfigStorage() {
    }

    public static CantSleepConfigValues loadOrCreate() {
        CantSleepConfigValues cantSleepConfigValues;
        block9: {
            CantSleepConfigValues defaults = CantSleepConfigStorage.normalized(0.15);
            Path path = CantSleepConfigStorage.configPath();
            if (!Files.exists(path, new LinkOption[0])) {
                CantSleepConfigStorage.writeConfig(path, defaults);
                return defaults;
            }
            CommentedFileConfig file = CantSleepConfigStorage.openFile(path);
            try {
                file.load();
                CantSleepConfigValues loaded = CantSleepConfigStorage.fromToml((CommentedConfig)file, defaults);
                CantSleepConfigStorage.writeToFile(file, loaded);
                cantSleepConfigValues = loaded;
                if (file == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    LOGGER.error("Failed to load {}: {}", new Object[]{"cant_sleep.toml", t.toString(), t});
                    CantSleepConfigStorage.writeConfig(path, defaults);
                    return defaults;
                }
            }
            file.close();
        }
        return cantSleepConfigValues;
    }

    public static CantSleepConfigValues overwrite(double insomniaChance) {
        CantSleepConfigValues updated = CantSleepConfigStorage.normalized(insomniaChance);
        CantSleepConfigStorage.writeConfig(CantSleepConfigStorage.configPath(), updated);
        return updated;
    }

    private static CantSleepConfigValues fromToml(CommentedConfig config, CantSleepConfigValues defaults) {
        double chance = defaults.insomniaChance();
        Object rawChance = config.get("insomnia_probability");
        if (rawChance instanceof Number) {
            Number number = (Number)rawChance;
            chance = number.doubleValue();
        }
        return CantSleepConfigStorage.normalized(chance);
    }

    private static void writeConfig(Path path, CantSleepConfigValues config) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create config directory for {}", (Object)"cant_sleep.toml", (Object)e);
            return;
        }
        try (CommentedFileConfig file = CantSleepConfigStorage.openFile(path);){
            file.load();
            CantSleepConfigStorage.writeToFile(file, config);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to write {}: {}", new Object[]{"cant_sleep.toml", t.toString(), t});
        }
    }

    private static CommentedFileConfig openFile(Path path) {
        return (CommentedFileConfig)CommentedFileConfig.builder((Path)path).preserveInsertionOrder().autosave().writingMode(WritingMode.REPLACE).build();
    }

    private static void writeToFile(CommentedFileConfig file, CantSleepConfigValues config) {
        file.set("#", (Object)"Can't Sleep - Config");
        file.set("#1", (Object)"Controls the chance that a night becomes unrestful.");
        file.set("insomnia_probability", (Object)config.insomniaChance());
        file.setComment("insomnia_probability", "Value between 0.0 and 1.0. 0.15 means 15% of nights cause insomnia.");
        file.save();
    }

    private static CantSleepConfigValues normalized(double insomniaChance) {
        double sanitized = Math.max(0.0, Math.min(1.0, insomniaChance));
        return new CantSleepConfigValues(sanitized);
    }

    private static Path configPath() {
        return FabricLoader.getInstance().getConfigDir().resolve("cant_sleep.toml");
    }
}

