/*
 * Decompiled with CFR 0.152.
 */
package me.duart.cucm;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadLocalRandom;
import me.clip.placeholderapi.PlaceholderAPI;
import me.duart.cucm.commands.ReloadCommand;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.command.UnknownCommandEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class CustomUnknownCommandMessage
extends JavaPlugin
implements Listener {
    private final MiniMessage mini = MiniMessage.miniMessage();
    private final CopyOnWriteArrayList<Component> cache = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<String> rawCache = new CopyOnWriteArrayList();
    private boolean useList;
    private boolean papiPresent = false;

    public void onEnable() {
        this.saveDefaultConfig();
        this.rebuildCache();
        this.detectSoftDependencies();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Bukkit.getCommandMap().register("cucmreload", (Command)new ReloadCommand(this));
    }

    @EventHandler
    public void onUnknownCommand(@NotNull UnknownCommandEvent event) {
        if (this.cache.isEmpty()) {
            return;
        }
        int index = this.useList ? ThreadLocalRandom.current().nextInt(this.cache.size()) : 0;
        String raw = this.rawCache.get(index);
        CommandSender commandSender = event.getSender();
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            raw = this.applyInternalPlaceholders(player, raw);
            if (this.papiPresent && raw.contains("%")) {
                raw = PlaceholderAPI.setPlaceholders((Player)player, (String)raw);
            }
        } else {
            raw = raw.replace("{player}", "Console").replace("<player>", "Console").replace("{displayname}", "Console").replace("<displayname>", "Console");
        }
        Component chosen = this.mini.deserialize((Object)raw);
        event.message(chosen);
    }

    @NotNull
    private String applyInternalPlaceholders(@NotNull Player player, @NotNull String text) {
        String displayName = (String)this.mini.serialize(player.displayName());
        return text.replace("{player}", player.getName()).replace("<player>", player.getName()).replace("{displayname}", displayName).replace("<displayname>", displayName);
    }

    public void rebuildCache() {
        this.cache.clear();
        this.rawCache.clear();
        this.useList = this.getConfig().getBoolean("use-multiple-messages", false);
        if (this.useList) {
            for (String raw : this.getConfig().getStringList("message-list")) {
                this.rawCache.add(raw);
                this.cache.add(this.mini.deserialize((Object)raw));
            }
        } else {
            String raw = this.getConfig().getString("single-message", "<red>Unknown Command, please use <gold>/help</gold> for more information.");
            this.rawCache.add(raw);
            this.cache.add(this.mini.deserialize((Object)raw));
        }
    }

    public void detectSoftDependencies() {
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            this.papiPresent = true;
            this.getLogger().info("PlaceholderAPI detected, hooking into it...");
        }
    }
}

